/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.IsosurfaceValuePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class IsosurfaceValueWindow
extends BaseWindow {
    private AbinitMpViewer viewer;
    private FileItem fileItem;
    private IsosurfaceValuePanel isosurfaceValuePanel;

    public IsosurfaceValueWindow(AbinitMpViewer abinitMpViewer, FileItem fileItem) {
        super(MyResourceBundle.getResourceString("IsosurfaceValueWindow.Title") + "(" + fileItem.filename + ")");
        this.viewer = abinitMpViewer;
        this.fileItem = fileItem;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("IsosurfaceValueWindow.fileMenuTitle", "IsosurfaceValueWindow.fileMenu", (Action)new fileListener()));
        this.isosurfaceValuePanel = new IsosurfaceValuePanel(abinitMpViewer, fileItem);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.isosurfaceValuePanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(1));
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("draw"));
        myButton.addActionListener(new drawListener());
        jPanel.add(myButton);
        this.mainPanel.add((Component)jPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension2.width > 2000) {
            dimension2.width /= 2;
        }
        this.setLocation(dimension2.width - dimension.width, 0);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
                IsosurfaceValueWindow.this.isosurfaceValuePanel.closeSectionAssignWindow();
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    public IsosurfaceValuePanel getIsosurfaceValuePanel() {
        return this.isosurfaceValuePanel;
    }

    private class drawListener
    implements ActionListener {
        private drawListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((IsosurfaceValueWindow)IsosurfaceValueWindow.this).fileItem.isosurfaceValue = IsosurfaceValueWindow.this.isosurfaceValuePanel.getValue();
            IsosurfaceValueWindow.this.viewer.createNode(IsosurfaceValueWindow.this.fileItem, null);
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("IsosurfaceValueWindow.fileMenu");
            char c = string.charAt(0);
            if (IsosurfaceValueWindow.this.getNemonic(stringArray[0]) == c) {
                IsosurfaceValueWindow.this.setVisible(false);
            }
        }
    }
}

