/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.ResidueData;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.CalculateChargeWindow;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class CalculateChargePanel
extends GridBagLayoutPanel {
    private AbinitMpViewer viewer;
    private JTextField fromText;
    private JTextField toText;
    private JTextField listText;
    private JTextField resultText;
    private MyRadioButton fragmentRadioButton;
    private MyRadioButton residueRadioButton;
    private MyRadioButton atomRadioButton;
    private MyRadioButton rangeRadioButton;
    private MyRadioButton listRadioButton;
    private CalculateChargeWindow calculateChargeWindow;
    private int[] listNo;
    private boolean fromOrTo = true;

    public CalculateChargePanel(AbinitMpViewer abinitMpViewer, CalculateChargeWindow calculateChargeWindow) {
        this.viewer = abinitMpViewer;
        this.calculateChargeWindow = calculateChargeWindow;
        this.fragmentRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("fragment"));
        this.residueRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("residue"));
        this.atomRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("atom"));
        this.fragmentRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fragmentRadioButton);
        buttonGroup.add(this.residueRadioButton);
        buttonGroup.add(this.atomRadioButton);
        FlowLayout flowLayout = new FlowLayout(0);
        MyPanel myPanel = new MyPanel(flowLayout);
        myPanel.add(this.fragmentRadioButton);
        myPanel.add(this.residueRadioButton);
        myPanel.add(this.atomRadioButton);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("CalculateChargePanel.type")), 0, 0, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, 0, 5, 1, 1.0, 0.0);
        this.rangeRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("CalculateChargePanel.range"));
        this.listRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("CalculateChargePanel.list"));
        this.rangeRadioButton.setSelected(true);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rangeRadioButton);
        buttonGroup.add(this.listRadioButton);
        this.fromText = new JTextField(5);
        this.toText = new JTextField(5);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(new MyLabel(MyResourceBundle.getResourceString("from")));
        myPanel.add(this.fromText);
        myPanel.add(new MyLabel(MyResourceBundle.getResourceString("to")));
        myPanel.add(this.toText);
        this.layoutObject(this.rangeRadioButton, 0, 1, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, 1, 5, 1, 1.0, 0.0);
        this.listText = new JTextField(10);
        this.layoutObject(this.listRadioButton, 0, 2, 5, 1, 1.0, 0.0);
        this.layoutObject(this.listText, 5, 2, 0, 1, 1.0, 0.0);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("apply"));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("close"));
        myButton.addActionListener(new applyButtonListener());
        myButton2.addActionListener(new closeButtonListener());
        flowLayout = new FlowLayout(1);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(myButton);
        myPanel.add(myButton2);
        this.layoutObject(myPanel, 0, 3, 0, 1, 1.0, 0.0);
        this.resultText = new JTextField(10);
        this.resultText.setEditable(false);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(this.resultText);
        BevelBorder bevelBorder = new BevelBorder(1);
        myPanel.setBorder(new TitledBorder(bevelBorder, MyResourceBundle.getResourceString("CalculateChargePanel.sum"), 1, 1));
        this.layoutObject(myPanel, 0, 4, 0, 1, 1.0, 0.0);
    }

    public void setNumber(int n, int n2, int n3) {
        String string = this.fragmentRadioButton.isSelected() ? Integer.toString(n2) : (this.residueRadioButton.isSelected() ? Integer.toString(n) : Integer.toString(n3));
        if (this.rangeRadioButton.isSelected()) {
            if (this.fromOrTo) {
                this.fromText.setText(string);
            } else {
                this.toText.setText(string);
            }
            this.fromOrTo = !this.fromOrTo;
        } else {
            String string2 = this.listText.getText();
            if (string2 == null) {
                string2 = new String();
            }
            string2 = string2 + " " + string;
            this.listText.setText(string2);
        }
    }

    private void createInList() {
        String string = this.listText.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(this.listText.getText());
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        this.listNo = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.listNo[i] = Integer.parseInt((String)vector.get(i));
        }
    }

    private boolean isInList(int n) {
        for (int i = 0; i < this.listNo.length; ++i) {
            if (this.listNo[i] != n) continue;
            return true;
        }
        return false;
    }

    class closeButtonListener
    extends AbstractAction {
        closeButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalculateChargePanel.this.calculateChargeWindow.setVisible(false);
        }
    }

    class applyButtonListener
    extends AbstractAction {
        applyButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float f = 0.0f;
            try {
                int n;
                int n2 = 0;
                int n3 = 0;
                CheckPointFile checkPointFile = CalculateChargePanel.this.viewer.getCurrentTabCpfFile();
                if (checkPointFile == null) {
                    return;
                }
                PdbFile pdbFile = checkPointFile.pdbFile;
                if (CalculateChargePanel.this.rangeRadioButton.isSelected()) {
                    n2 = Integer.parseInt(CalculateChargePanel.this.fromText.getText());
                    if (n2 > (n3 = Integer.parseInt(CalculateChargePanel.this.toText.getText()))) {
                        int n4 = n3;
                        n3 = n2;
                        n2 = n4;
                    }
                } else {
                    CalculateChargePanel.this.createInList();
                }
                float[] fArray = new float[checkPointFile.numberOfFragment];
                Vector vector = pdbFile.chains;
                for (n = 0; n < vector.size(); ++n) {
                    ChainData chainData = (ChainData)vector.get(n);
                    Vector vector2 = null;
                    Vector vector3 = null;
                    for (int i = 0; i < 2; ++i) {
                        Object object;
                        int n5;
                        if (i == 0) {
                            vector2 = chainData.atomTable;
                            vector3 = chainData.residueTable;
                        } else {
                            vector2 = chainData.hemTable;
                            vector3 = chainData.hemResidueTable;
                        }
                        if (CalculateChargePanel.this.fragmentRadioButton.isSelected()) {
                            for (n5 = 0; n5 < vector2.size(); ++n5) {
                                object = (AtomData)vector2.get(n5);
                                fArray[((AtomData)object).fragmentNo - 1] = fArray[((AtomData)object).fragmentNo - 1] + ((AtomData)object).mulliken;
                            }
                            continue;
                        }
                        if (CalculateChargePanel.this.residueRadioButton.isSelected()) {
                            AtomData atomData;
                            int n6;
                            if (CalculateChargePanel.this.rangeRadioButton.isSelected()) {
                                for (n5 = 0; n5 < vector3.size(); ++n5) {
                                    object = (ResidueData)vector3.get(n5);
                                    if (n2 > ((ResidueData)object).no || ((ResidueData)object).no > n3) continue;
                                    for (n6 = ((ResidueData)object).startNo; n6 <= ((ResidueData)object).endNo; ++n6) {
                                        atomData = (AtomData)vector2.get(n6);
                                        f += atomData.mulliken;
                                    }
                                }
                                continue;
                            }
                            for (n5 = 0; n5 < vector3.size(); ++n5) {
                                object = (ResidueData)vector3.get(n5);
                                if (!CalculateChargePanel.this.isInList(((ResidueData)object).no)) continue;
                                for (n6 = ((ResidueData)object).startNo; n6 <= ((ResidueData)object).endNo; ++n6) {
                                    atomData = (AtomData)vector2.get(n6);
                                    f += atomData.mulliken;
                                }
                            }
                            continue;
                        }
                        if (CalculateChargePanel.this.rangeRadioButton.isSelected()) {
                            for (n5 = 0; n5 < vector2.size(); ++n5) {
                                object = (AtomData)vector2.get(n5);
                                if (n2 > ((AtomData)object).no || ((AtomData)object).no > n3) continue;
                                f += ((AtomData)object).mulliken;
                            }
                            continue;
                        }
                        for (n5 = 0; n5 < vector2.size(); ++n5) {
                            object = (AtomData)vector2.get(n5);
                            if (!CalculateChargePanel.this.isInList(((AtomData)object).no)) continue;
                            f += ((AtomData)object).mulliken;
                        }
                    }
                }
                if (CalculateChargePanel.this.fragmentRadioButton.isSelected()) {
                    if (CalculateChargePanel.this.rangeRadioButton.isSelected()) {
                        for (n = n2 - 1; n < n3; ++n) {
                            f += fArray[n];
                        }
                    } else {
                        for (n = 0; n < fArray.length; ++n) {
                            if (!CalculateChargePanel.this.isInList(n + 1)) continue;
                            f += fArray[n];
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog((Component)actionEvent.getSource(), "Wrong number or emply", "Error message", 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                JOptionPane.showMessageDialog((Component)actionEvent.getSource(), "Fragment number is Out of range", "Error message", 0);
            }
            int n = (int)f;
            if ((double)Math.abs(f - (float)n) < 1.0E-5) {
                f = n;
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.00000");
            CalculateChargePanel.this.resultText.setText(decimalFormat.format(f));
        }
    }
}

