/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Structure;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.AtomInfoTable;
import AbinitMp.Common.AtomTableElement;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.ColorData;
import AbinitMp.Common.Constants;
import AbinitMp.Common.MDLFile;
import AbinitMp.Common.ResidueData;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Common.SsData;
import AbinitMp.Common.XyzFile;
import AbinitMp.Display.ColorMap;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Structure.NodeData;
import AbinitMp.Structure.SelectionData;
import AbinitMp.Tool.Spline;
import AbinitMp.Viewer.DisplayPreference;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.InDistanceData;
import AbinitMp.Viewer.StartEnd;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickTool;
import java.awt.Font;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class MolecularStructure {
    private Switch root;
    private CoordInfo coordInfo;
    private CoordInfo fileCoordInfo;
    private int displayModel = 1;
    private int colorStyle = 1;
    private ChainData chainData;
    public FileItem fileItem;
    private ColorMap mullikenColorMap = null;
    private ColorMap interactionEnergyColorMap = null;
    public CheckPointFile cpf;
    private double[][] interactionEnergy;
    private Vector[] atomConnect;
    private Vector[] boneConnect;
    private Vector[] caConnect;
    private Vector caAtoms;
    private Vector[] dnaC3Connect;
    private Vector dnaC3Atoms;
    private Vector dnaNAtoms;
    private Vector hBondsPeptideConnect;
    private Vector hBondsHemConnect;
    private float[] caSplineCoord;
    private float[] dnaC3SplineCoord;
    private int splineDivNum = 8;
    private int[] stripCount = new int[]{this.splineDivNum / 2 + 1};
    private Vector[] hemConnect;
    private Hashtable residueNodeTable = new Hashtable();
    private Hashtable hemResidueNodeTable = new Hashtable();
    private Hashtable atomNodeTable = new Hashtable();
    private Font3D font = new Font3D(new Font("Century Gothic", 0, 1), new FontExtrusion());
    Appearance atomLabelAppearance;
    Appearance residueLabelAppearance;
    private Vector atomTable;
    private Vector hemTable;
    private Vector residueTable;
    private Vector hemResidueTable;
    private Vector ssTable;
    private int atomTableSize;
    private int hemTableSize;
    private int ssTableSize;
    private final float H_RADIUS = 0.2f;
    private BitSet rootBitSet;
    public Vector displayAtomList = new Vector();
    public int chainColorNo;
    private int fragmentColorNo;
    public int fileColorNo;
    private Vector interactionEnergyManyToOneData;
    private boolean[] displayResidueColor;

    public MolecularStructure() {
        Color3f color3f = new Color3f(0.0f, 1.0f, 0.0f);
        this.atomLabelAppearance = new Appearance();
        this.atomLabelAppearance.setMaterial(new Material(color3f, color3f, color3f, color3f, 100.0f));
        color3f = new Color3f(0.0f, 204.0f, 204.0f);
        this.residueLabelAppearance = new Appearance();
        this.residueLabelAppearance.setMaterial(new Material(color3f, color3f, color3f, color3f, 100.0f));
    }

    public MolecularStructure(FileItem fileItem, ChainData chainData, CoordInfo coordInfo, CoordInfo coordInfo2, int n, int n2, int n3, int n4, boolean[] blArray, boolean[] blArray2, Hashtable hashtable, InDistanceData inDistanceData, Vector vector, int n5, int n6, Vector vector2) {
        this.fileItem = fileItem;
        this.chainColorNo = n5 % DisplayPreference.chainColor.length;
        this.fileColorNo = n6 % DisplayPreference.fileColor.length;
        this.interactionEnergyManyToOneData = vector2;
        this.displayResidueColor = blArray2;
        if (fileItem.type == 5) {
            this.cpf = (CheckPointFile)fileItem.file;
            this.mullikenColorMap = this.cpf.colorMap;
            this.interactionEnergyColorMap = this.cpf.interactionEnergyColorMap;
            this.interactionEnergy = this.cpf.interactionEnergy;
        }
        Color3f color3f = new Color3f(0.0f, 1.0f, 0.0f);
        this.atomLabelAppearance = new Appearance();
        this.atomLabelAppearance.setMaterial(new Material(color3f, color3f, color3f, color3f, 100.0f));
        color3f = new Color3f(0.0f, 204.0f, 204.0f);
        this.residueLabelAppearance = new Appearance();
        this.residueLabelAppearance.setMaterial(new Material(color3f, color3f, color3f, color3f, 100.0f));
        this.displayModel = 1;
        this.coordInfo = coordInfo;
        this.fileCoordInfo = coordInfo2;
        this.createConnectInfo(chainData);
        this.displayAtomList.removeAllElements();
        this.fragmentColorNo = 0;
        this.createNode(n, n2, n3, n4, blArray, blArray2, hashtable, inDistanceData, vector);
    }

    private void createConnectInfo(ChainData chainData) {
        Object object;
        int n;
        this.chainData = chainData;
        this.atomTable = chainData.atomTable;
        this.hemTable = chainData.hemTable;
        this.residueTable = chainData.residueTable;
        this.hemResidueTable = chainData.hemResidueTable;
        this.ssTable = chainData.ssTable;
        this.atomTableSize = this.atomTable.size();
        this.hemTableSize = this.hemTable.size();
        this.ssTableSize = this.ssTable.size();
        for (n = 0; n < this.atomTableSize; ++n) {
            object = (AtomData)this.atomTable.get(n);
            ((AtomData)object).coordX = ((AtomData)object).x - this.fileCoordInfo.xcenter;
            ((AtomData)object).coordY = ((AtomData)object).y - this.fileCoordInfo.ycenter;
            ((AtomData)object).coordZ = ((AtomData)object).z - this.fileCoordInfo.zcenter;
        }
        for (n = 0; n < this.hemTableSize; ++n) {
            object = (AtomData)this.hemTable.get(n);
            ((AtomData)object).coordX = ((AtomData)object).x - this.fileCoordInfo.xcenter;
            ((AtomData)object).coordY = ((AtomData)object).y - this.fileCoordInfo.ycenter;
            ((AtomData)object).coordZ = ((AtomData)object).z - this.fileCoordInfo.zcenter;
        }
        if (chainData.atomConnect == null) {
            this.atomConnect = new Vector[this.atomTableSize];
            this.boneConnect = new Vector[this.atomTableSize];
            this.caConnect = this.atomTableSize > this.hemTableSize ? new Vector[this.atomTableSize] : new Vector[this.hemTableSize];
            this.hemConnect = new Vector[this.hemTableSize];
            this.caAtoms = new Vector();
            this.dnaC3Atoms = new Vector();
            this.dnaNAtoms = new Vector();
            this.hBondsPeptideConnect = new Vector();
            this.hBondsHemConnect = new Vector();
            for (n = 0; n < this.atomTableSize; ++n) {
                this.atomConnect[n] = new Vector();
            }
            for (n = 0; n < this.hemTableSize; ++n) {
                this.hemConnect[n] = new Vector();
            }
            n = 0;
            if (this.fileItem.type == 7) {
                object = (MDLFile)this.fileItem.file;
                if (((MDLFile)object).numberOfConnect > 0) {
                    for (int i = 0; i < ((MDLFile)object).numberOfConnect; ++i) {
                        this.atomConnect[((MDLFile)object).connect[0][i] - 1].add((AtomData)this.atomTable.get(((MDLFile)object).connect[1][i] - 1));
                        this.atomConnect[((MDLFile)object).connect[1][i] - 1].add((AtomData)this.atomTable.get(((MDLFile)object).connect[0][i] - 1));
                    }
                    n = 1;
                }
            }
            if (n == 0) {
                AtomData atomData;
                int n2;
                int n3;
                block5: for (n3 = 0; n3 < this.atomTableSize; ++n3) {
                    AtomData atomData2 = (AtomData)this.atomTable.get(n3);
                    if (atomData2.cutFlag) continue;
                    if (atomData2.allAtomName.equalsIgnoreCase("CA")) {
                        if (this.caAtoms.indexOf(atomData2) == -1) {
                            this.caAtoms.add(atomData2);
                        }
                        for (n2 = n3 + 1; n2 < this.atomTableSize; ++n2) {
                            atomData = (AtomData)this.atomTable.get(n2);
                            if (atomData.cutFlag || !atomData.allAtomName.equalsIgnoreCase("CA")) continue;
                            if (!(this.distance(atomData2, atomData) < 5.0)) break;
                            if (this.caConnect[n3] == null) {
                                this.caConnect[n3] = new Vector();
                            }
                            if (this.caConnect[n2] == null) {
                                this.caConnect[n2] = new Vector();
                            }
                            this.caConnect[n3].add(atomData);
                            this.caConnect[n2].add(atomData2);
                            break;
                        }
                    }
                    for (n2 = n3 + 1; n2 < this.atomTableSize; ++n2) {
                        atomData = (AtomData)this.atomTable.get(n2);
                        if (atomData.cutFlag || !this.isConnect(atomData2, atomData)) continue;
                        this.connectHCheck(this.atomConnect, this.atomTable, n3, n2, atomData2, atomData);
                        if (!(atomData2.allAtomName.equalsIgnoreCase("N") && atomData.allAtomName.equalsIgnoreCase("CA") || atomData2.allAtomName.equalsIgnoreCase("CA") && atomData.allAtomName.equalsIgnoreCase("N") || atomData2.allAtomName.equalsIgnoreCase("C") && atomData.allAtomName.equalsIgnoreCase("CA") || atomData2.allAtomName.equalsIgnoreCase("CA") && atomData.allAtomName.equalsIgnoreCase("C") || atomData2.allAtomName.equalsIgnoreCase("C") && atomData.allAtomName.equalsIgnoreCase("O")) && (!atomData2.allAtomName.equalsIgnoreCase("O") || !atomData.allAtomName.equalsIgnoreCase("C"))) continue;
                        if (this.boneConnect[n3] == null) {
                            this.boneConnect[n3] = new Vector();
                        }
                        if (this.boneConnect[n2] == null) {
                            this.boneConnect[n2] = new Vector();
                        }
                        this.boneConnect[n3].add(atomData);
                        this.boneConnect[n2].add(atomData2);
                    }
                    if (atomData2.allAtomName.equalsIgnoreCase("C")) {
                        for (n2 = n3 + 1; n2 < this.atomTableSize; ++n2) {
                            atomData = (AtomData)this.atomTable.get(n2);
                            if (atomData.cutFlag) continue;
                            if (atomData2.residueNo + 1 == atomData.residueNo || atomData2.residueNo == atomData.residueNo && atomData2.iCode != null && !atomData2.iCode.equals(atomData.iCode)) {
                                double d;
                                if (!atomData.allAtomName.equalsIgnoreCase("N") || !((d = this.distance(atomData2.coordX - atomData.coordX, atomData2.coordY - atomData.coordY, atomData2.coordZ - atomData.coordZ)) < this.CPKdistance(atomData2, atomData))) continue;
                                this.atomConnect[n3].add(atomData);
                                this.atomConnect[n2].add(atomData2);
                                if (this.boneConnect[n3] == null) {
                                    this.boneConnect[n3] = new Vector();
                                }
                                if (this.boneConnect[n2] == null) {
                                    this.boneConnect[n2] = new Vector();
                                }
                                this.boneConnect[n3].add(atomData);
                                this.boneConnect[n2].add(atomData2);
                                break;
                            }
                            if (atomData2.residueNo + 2 == atomData.residueNo) break;
                        }
                    }
                    if (atomData2.allAtomName.length() < 2 || !atomData2.allAtomName.substring(0, 2).equalsIgnoreCase("O3")) continue;
                    for (n2 = n3 + 1; n2 < this.atomTableSize; ++n2) {
                        atomData = (AtomData)this.atomTable.get(n2);
                        if (atomData.cutFlag || !atomData.allAtomName.equalsIgnoreCase("P") || !(this.distance(atomData2, atomData) < 3.0)) continue;
                        this.atomConnect[n3].add(atomData);
                        this.atomConnect[n2].add(atomData2);
                        if (this.boneConnect[n3] == null) {
                            this.boneConnect[n3] = new Vector();
                        }
                        if (this.boneConnect[n2] == null) {
                            this.boneConnect[n2] = new Vector();
                        }
                        this.boneConnect[n3].add(atomData);
                        this.boneConnect[n2].add(atomData2);
                        continue block5;
                    }
                }
                for (n3 = 0; n3 < this.hemTableSize; ++n3) {
                    AtomData atomData3 = (AtomData)this.hemTable.get(n3);
                    if (atomData3.cutFlag) continue;
                    for (n2 = n3 + 1; n2 < this.hemTableSize; ++n2) {
                        atomData = (AtomData)this.hemTable.get(n2);
                        if (atomData.cutFlag || !this.isConnect(atomData3, atomData)) continue;
                        this.connectHCheck(this.hemConnect, this.hemTable, n3, n2, atomData3, atomData);
                    }
                    if (atomData3.allAtomName.length() >= 2 && atomData3.allAtomName.substring(0, 2).equalsIgnoreCase("O3")) {
                        for (n2 = n3 + 1; n2 < this.hemTableSize; ++n2) {
                            atomData = (AtomData)this.hemTable.get(n2);
                            if (atomData.cutFlag || !atomData.allAtomName.equalsIgnoreCase("P") || !(this.distance(atomData3, atomData) < 3.0)) continue;
                            this.hemConnect[n3].add(atomData);
                            this.hemConnect[n2].add(atomData3);
                            break;
                        }
                    }
                    if (atomData3.allAtomName.equalsIgnoreCase("C3'") && atomData3.isDnaAtom()) {
                        this.dnaC3Atoms.add(atomData3);
                    }
                    if (!atomData3.isDnaAtom() || (!atomData3.allAtomName.equalsIgnoreCase("N1") || !atomData3.residueData.name.equalsIgnoreCase("A") && !atomData3.residueData.name.equalsIgnoreCase("G")) && (!atomData3.allAtomName.equalsIgnoreCase("N3") || !atomData3.residueData.name.equalsIgnoreCase("T") && !atomData3.residueData.name.equalsIgnoreCase("C"))) continue;
                    this.dnaNAtoms.add(atomData3);
                }
                this.dnaC3Connect = new Vector[this.hemTable.size()];
                for (n3 = 0; n3 < this.dnaC3Atoms.size() - 1; ++n3) {
                    AtomData atomData4;
                    AtomData atomData5 = (AtomData)this.dnaC3Atoms.get(n3);
                    if (!(8.0 > this.distance(atomData5, atomData4 = (AtomData)this.dnaC3Atoms.get(n3 + 1)))) continue;
                    int n4 = this.hemTable.indexOf(atomData5);
                    int n5 = this.hemTable.indexOf(atomData4);
                    if (this.dnaC3Connect[n4] == null) {
                        this.dnaC3Connect[n4] = new Vector();
                    }
                    if (this.dnaC3Connect[n5] == null) {
                        this.dnaC3Connect[n5] = new Vector();
                    }
                    this.dnaC3Connect[n4].add(atomData4);
                    this.dnaC3Connect[n5].add(atomData5);
                }
                this.createHBondsConnect();
                chainData.atomConnect = this.atomConnect;
                chainData.boneConnect = this.boneConnect;
                chainData.caConnect = this.caConnect;
                chainData.hemConnect = this.hemConnect;
                chainData.caAtoms = this.caAtoms;
                chainData.dnaC3Atoms = this.dnaC3Atoms;
                chainData.dnaC3Connect = this.dnaC3Connect;
                chainData.dnaNAtoms = this.dnaNAtoms;
                chainData.caSplineCoord = this.caSplineCoord;
                chainData.dnaC3SplineCoord = this.dnaC3SplineCoord;
                chainData.hBondsPeptideConnect = this.hBondsPeptideConnect;
                chainData.hBondsHemConnect = this.hBondsHemConnect;
            }
        } else {
            this.atomConnect = chainData.atomConnect;
            this.boneConnect = chainData.boneConnect;
            this.caConnect = chainData.caConnect;
            this.hemConnect = chainData.hemConnect;
            this.caAtoms = chainData.caAtoms;
            this.dnaC3Atoms = chainData.dnaC3Atoms;
            this.dnaC3Connect = chainData.dnaC3Connect;
            this.dnaNAtoms = chainData.dnaNAtoms;
            this.caSplineCoord = chainData.caSplineCoord;
            this.dnaC3SplineCoord = chainData.dnaC3SplineCoord;
            this.hBondsPeptideConnect = chainData.hBondsPeptideConnect;
            this.hBondsHemConnect = chainData.hBondsHemConnect;
        }
        this.caSplineCoord = this.calcSplineCoord(this.caAtoms);
        this.dnaC3SplineCoord = this.calcSplineCoord(this.dnaC3Atoms);
    }

    private float[] calcSplineCoord(Vector vector) {
        float[] fArray = null;
        int n = vector.size();
        if (n != 0) {
            int n2;
            float[] fArray2 = new float[(n + 2) * 3];
            for (int i = 0; i < n; ++i) {
                AtomData atomData = (AtomData)vector.get(i);
                fArray2[(i + 1) * 3] = atomData.coordX;
                fArray2[(i + 1) * 3 + 1] = atomData.coordY;
                fArray2[(i + 1) * 3 + 2] = atomData.coordZ;
            }
            AtomData atomData = (AtomData)vector.get(0);
            fArray2[0] = atomData.coordX;
            fArray2[1] = atomData.coordY;
            fArray2[2] = atomData.coordZ;
            atomData = (AtomData)vector.get(vector.size() - 1);
            fArray2[(n + 1) * 3] = atomData.coordX;
            fArray2[(n + 1) * 3 + 1] = atomData.coordY;
            fArray2[(n + 1) * 3 + 2] = atomData.coordZ;
            int n3 = this.splineDivNum;
            fArray = new float[(fArray2.length - 9) * n3 + 3];
            for (n2 = 0; n2 < fArray2.length / 3 - 3; ++n2) {
                float[][] fArray3 = Spline.makeSplineMatrix(fArray2, n2);
                float[] fArray4 = Spline.makeSplineInterpolationCoord(fArray3, n3);
                for (int i = 0; i < n3 * 3; ++i) {
                    fArray[n3 * 3 * n2 + i] = fArray4[i];
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                fArray[fArray.length - 3 + n2] = fArray2[fArray2.length - 3 + n2];
            }
        }
        return fArray;
    }

    private TransformGroup createBondTfg(AtomData atomData, AtomData atomData2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = atomData2.coordX - atomData.coordX;
        float f6 = atomData2.coordY - atomData.coordY;
        float f7 = atomData2.coordZ - atomData.coordZ;
        float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
        float f9 = (float)Math.sqrt(f6 * f6 + f5 * f5);
        float f10 = (float)Math.sqrt(f9 * f9 + f7 * f7);
        if ((double)f9 != 0.0) {
            f4 = f6 / f9;
            f3 = -f5 / f9;
        } else {
            f4 = 1.0f;
            f3 = 0.0f;
        }
        if ((double)f10 != 0.0) {
            f2 = f9 / f10;
            f = f7 / f10;
        } else {
            f2 = 1.0f;
            f = 0.0f;
        }
        Matrix4d matrix4d = new Matrix4d((double)f4, (double)f3, 0.0, 0.0, (double)(-f3) * (double)f2, (double)f4 * (double)f2, (double)f, 0.0, (double)f3 * (double)f, (double)(-f4) * (double)f, (double)f2, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D transform3D = new Transform3D(matrix4d);
        transform3D.invert();
        transform3D.setScale(new Vector3d(1.0, (double)f8 / 2.0, 1.0));
        transform3D.setTranslation(new Vector3d((double)f5 / 4.0 + (double)atomData.coordX, (double)f6 / 4.0 + (double)atomData.coordY, (double)f7 / 4.0 + (double)atomData.coordZ));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        return transformGroup;
    }

    public static TransformGroup createBondTfg(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11 = f4 - f;
        float f12 = f5 - f2;
        float f13 = f6 - f3;
        float f14 = (float)Math.sqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = (float)Math.sqrt(f12 * f12 + f11 * f11);
        float f16 = (float)Math.sqrt(f15 * f15 + f13 * f13);
        if ((double)f15 != 0.0) {
            f10 = f12 / f15;
            f9 = -f11 / f15;
        } else {
            f10 = 1.0f;
            f9 = 0.0f;
        }
        if ((double)f16 != 0.0) {
            f8 = f15 / f16;
            f7 = f13 / f16;
        } else {
            f8 = 1.0f;
            f7 = 0.0f;
        }
        Matrix4d matrix4d = new Matrix4d((double)f10, (double)f9, 0.0, 0.0, (double)(-f9) * (double)f8, (double)f10 * (double)f8, (double)f7, 0.0, (double)f9 * (double)f7, (double)(-f10) * (double)f7, (double)f8, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D transform3D = new Transform3D(matrix4d);
        transform3D.invert();
        transform3D.setScale(new Vector3d(1.0, (double)f14, 1.0));
        transform3D.setTranslation(new Vector3d((double)f11 / 2.0 + (double)f, (double)f12 / 2.0 + (double)f2, (double)f13 / 2.0 + (double)f3));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        return transformGroup;
    }

    private BranchGroup createResidueNode(ResidueData residueData, boolean bl, int n, int n2, int n3, int n4, Vector vector, Hashtable hashtable, InDistanceData inDistanceData, int n5) {
        Object object;
        NodeData nodeData;
        int n6;
        Object object2;
        BranchGroup branchGroup = new BranchGroup();
        if (residueData.cutFlag || !residueData.inDisplayFlag) {
            return branchGroup;
        }
        TransformGroup transformGroup = new TransformGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(13);
        branchGroup.setUserData((Object)new NodeData(this, null, residueData, this.chainData, this.fileItem, 2));
        Appearance appearance = null;
        Color3f color3f = null;
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        if (bl) {
            object2 = this.hemResidueNodeTable.get(residueData);
            if (object2 != null) {
                this.hemResidueNodeTable.remove(residueData);
            }
            this.hemResidueNodeTable.put(residueData, branchGroup);
        } else {
            object2 = this.residueNodeTable.get(residueData);
            if (object2 != null) {
                this.residueNodeTable.remove(residueData);
            }
            this.residueNodeTable.put(residueData, branchGroup);
        }
        object2 = (NodeData)hashtable.get(residueData);
        if (object2 != null) {
            if (!((NodeData)object2).visible) {
                return branchGroup;
            }
            if (((NodeData)object2).color != 0 && n2 != 16) {
                n2 = ((NodeData)object2).color;
            }
            if (((NodeData)object2).model != 0) {
                n = ((NodeData)object2).model;
            }
        }
        if (n2 != 1) {
            ColorData colorData;
            if (n2 == 2) {
                colorData = (ColorData)ResidueInfoTable.get(residueData.name);
                if (colorData == null) {
                    colorData = (ColorData)ResidueInfoTable.get("OTHER");
                }
                appearance = colorData.appearance;
                color3f = colorData.color;
            } else if (n2 == 3) {
                if (residueData.charge < 0.0f) {
                    appearance = ((ColorData)ResidueInfoTable.get((String)"E--")).appearance;
                    color3f = ((ColorData)ResidueInfoTable.get((String)"E--")).color;
                } else if ((double)residueData.charge == 0.0) {
                    appearance = ((ColorData)ResidueInfoTable.get((String)"E+-")).appearance;
                    color3f = ((ColorData)ResidueInfoTable.get((String)"E+-")).color;
                } else {
                    appearance = ((ColorData)ResidueInfoTable.get((String)"E++")).appearance;
                    color3f = ((ColorData)ResidueInfoTable.get((String)"E++")).color;
                }
            } else if (n2 == 4) {
                colorData = (ColorData)ResidueInfoTable.get("OTHER");
                appearance = colorData.appearance;
                color3f = colorData.color;
            } else if (n2 == 12 || n2 == 13 || n2 == 14) {
                colorData = (ColorData)ResidueInfoTable.get("OTHER");
                appearance = colorData.appearance;
                color3f = colorData.color;
            } else if (n2 == 16) {
                appearance = ((ColorData)ResidueInfoTable.get((String)"SELECT")).appearance;
                color3f = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
            } else if (n2 == 6) {
                appearance = DisplayPreference.chainColor[this.chainColorNo].appearance;
                color3f = DisplayPreference.chainColor[this.chainColorNo].color;
            } else if (n2 == 7) {
                appearance = DisplayPreference.fileColor[this.fileColorNo].appearance;
                color3f = DisplayPreference.fileColor[this.fileColorNo].color;
            } else if (n2 == 8) {
                appearance = ((ColorData)ResidueInfoTable.getHydro((String)residueData.name)).appearance;
                color3f = ((ColorData)ResidueInfoTable.getHydro((String)residueData.name)).color;
            } else if (n2 == 9) {
                if (residueData.isMolecularSurface) {
                    appearance = ((ColorData)ResidueInfoTable.getHydro((String)"SURFACE")).appearance;
                    color3f = ((ColorData)ResidueInfoTable.getHydro((String)"SURFACE")).color;
                } else {
                    appearance = ((ColorData)ResidueInfoTable.getHydro((String)residueData.name)).appearance;
                    color3f = ((ColorData)ResidueInfoTable.getHydro((String)residueData.name)).color;
                }
            } else if (n2 == 10) {
                appearance = ((ColorData)ResidueInfoTable.getFunction((String)residueData.name)).appearance;
                color3f = ((ColorData)ResidueInfoTable.getFunction((String)residueData.name)).color;
            } else if (n2 == 15) {
                color3f = ((NodeData)object2).colorValue;
                colorData = new Material();
                colorData.setDiffuseColor(color3f);
                appearance = new Appearance();
                appearance.setMaterial((Material)colorData);
            } else if (n2 == 11) {
                if (n5 == -1 || n5 >= this.displayResidueColor.length || !this.displayResidueColor[n5]) {
                    appearance = ((ColorData)ResidueInfoTable.getHydro((String)"SURFACE")).appearance;
                    color3f = ((ColorData)ResidueInfoTable.getHydro((String)"SURFACE")).color;
                } else {
                    colorData = (ColorData)ResidueInfoTable.get(residueData.name);
                    if (colorData == null) {
                        colorData = (ColorData)ResidueInfoTable.get("OTHER");
                    }
                    appearance = colorData.appearance;
                    color3f = colorData.color;
                }
            }
        }
        boolean bl2 = false;
        SelectionData selectionData = null;
        if ((n2 == 12 || n2 == 13) && this.interactionEnergy != null && vector != null && vector.size() > 0) {
            selectionData = (SelectionData)vector.get(0);
        }
        for (int i = residueData.startNo; i <= residueData.endNo; ++i) {
            Object object3;
            boolean bl3;
            int n7;
            SelectionData selectionData2;
            Shape3D shape3D;
            Object object4;
            Object object5;
            int n8;
            TransformGroup transformGroup2;
            Object object6;
            double d;
            AtomData atomData = null;
            atomData = bl ? (AtomData)this.hemTable.get(i) : (AtomData)this.atomTable.get(i);
            if (atomData.cutFlag || inDistanceData != null && inDistanceData.displayAtom && !inDistanceData.isInDistance(atomData) || (n2 == 12 || n2 == 13) && selectionData != null && selectionData.atomData.fragmentNo != atomData.fragmentNo && Math.abs(d = this.interactionEnergy[selectionData.atomData.fragmentNo - 1][atomData.fragmentNo - 1]) < this.cpf.displayInteractionEnergyThreshold || n2 == 14 && Math.abs(d = this.calcInteractionEnergyManyToOneEnergy(atomData)) < this.cpf.displayInteractionEnergyManyThreshold) continue;
            Appearance appearance2 = appearance;
            Appearance appearance3 = appearance;
            Color3f color3f2 = color3f;
            n6 = n;
            int n9 = n2;
            nodeData = (NodeData)hashtable.get(atomData);
            if (nodeData != null) {
                if (!nodeData.visible) continue;
                if (nodeData.color != 0) {
                    n9 = nodeData.color;
                    if (n9 == 2) {
                        object = (ColorData)ResidueInfoTable.get(residueData.name);
                        if (object == null) {
                            object = (ColorData)ResidueInfoTable.get("OTHER");
                        }
                        appearance3 = object.appearance;
                        color3f2 = object.color;
                    } else if (n9 == 3) {
                        if (residueData.charge < 0.0f) {
                            appearance3 = ((ColorData)ResidueInfoTable.get((String)"E--")).appearance;
                            color3f2 = ((ColorData)ResidueInfoTable.get((String)"E--")).color;
                        } else if ((double)residueData.charge == 0.0) {
                            appearance3 = ((ColorData)ResidueInfoTable.get((String)"E+-")).appearance;
                            color3f2 = ((ColorData)ResidueInfoTable.get((String)"E+-")).color;
                        } else {
                            appearance3 = ((ColorData)ResidueInfoTable.get((String)"E++")).appearance;
                            color3f2 = ((ColorData)ResidueInfoTable.get((String)"E++")).color;
                        }
                    } else if (n9 == 6) {
                        appearance3 = DisplayPreference.chainColor[this.chainColorNo].appearance;
                        color3f2 = DisplayPreference.chainColor[this.chainColorNo].color;
                    } else if (n9 == 7) {
                        appearance3 = DisplayPreference.fileColor[this.fileColorNo].appearance;
                        color3f2 = DisplayPreference.fileColor[this.fileColorNo].color;
                    } else if (n9 == 15) {
                        color3f2 = nodeData.colorValue;
                        object = new Material();
                        object.setDiffuseColor(color3f2);
                        appearance3 = new Appearance();
                        appearance3.setMaterial((Material)object);
                    }
                    appearance2 = appearance3;
                }
            }
            if (n4 != 0 && nodeData == null || nodeData != null && nodeData.label != 0 || object2 != null && ((NodeData)object2).label == 3) {
                object = new Transform3D();
                float f = 0.5f;
                object.setScale((double)f);
                object6 = new Point3f(atomData.coordX / f, atomData.coordY / f, atomData.coordZ / f);
                transformGroup2 = new TransformGroup(object);
                n8 = n4;
                if (nodeData != null && nodeData.label != 0) {
                    n8 = nodeData.label;
                }
                String string = n8 == 1 ? atomData.atomName : Integer.toString(atomData.no);
                object5 = new Text3D(this.font, string, object6);
                object4 = new OrientedShape3D((Geometry)object5, this.atomLabelAppearance, 1, object6);
                object4.setBounds((Bounds)new BoundingSphere(new Point3d(object6), 0.001));
                object4.setPickable(false);
                transformGroup2.addChild((Node)object4);
                transformGroup.addChild((Node)transformGroup2);
            }
            if (color3f == color3f2) {
                if (n6 == 3 && n9 == 1) {
                    appearance3 = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).appearance;
                    color3f2 = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).color;
                    appearance2 = ((AtomTableElement)AtomInfoTable.getElement((String)"H", (int)0)).appearance;
                } else if (n9 == 1) {
                    appearance2 = appearance3 = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).appearance;
                    color3f2 = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).color;
                } else if (n9 == 4) {
                    if (this.mullikenColorMap != null) {
                        object = this.mullikenColorMap.getRgb(atomData.mulliken);
                        color3f2 = new Color3f((float[])object);
                        Material material = new Material();
                        material.setDiffuseColor(color3f2);
                        appearance3 = new Appearance();
                        appearance3.setMaterial(material);
                        appearance2 = appearance3;
                    } else {
                        appearance2 = appearance3 = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).appearance;
                        color3f2 = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).color;
                    }
                } else if (n9 == 5) {
                    if (atomData.fragmentNo != 0) {
                        appearance2 = appearance3 = DisplayPreference.fragmentColor[(atomData.fragmentNo - 1) % DisplayPreference.fragmentColor.length].appearance;
                        color3f2 = DisplayPreference.fragmentColor[(atomData.fragmentNo - 1) % DisplayPreference.fragmentColor.length].color;
                    } else {
                        appearance2 = appearance3 = DisplayPreference.fragmentColor[0].appearance;
                        color3f2 = DisplayPreference.fragmentColor[0].color;
                    }
                } else if (n9 == 12 || n9 == 13) {
                    if (this.interactionEnergyColorMap != null && selectionData != null) {
                        if (selectionData.atomData.fragmentNo != atomData.fragmentNo) {
                            double d2 = this.interactionEnergy[selectionData.atomData.fragmentNo - 1][atomData.fragmentNo - 1];
                            if (d2 == 0.0 && this.cpf.isConnectFragment(selectionData.atomData.fragmentNo, atomData.fragmentNo)) {
                                appearance2 = appearance3 = ((ColorData)ResidueInfoTable.get((String)"OTHER")).appearance;
                                color3f2 = ((ColorData)ResidueInfoTable.get((String)"OTHER")).color;
                            } else {
                                object6 = this.interactionEnergyColorMap.getRgb(d2);
                                color3f2 = new Color3f((float[])object6);
                                transformGroup2 = new Material();
                                transformGroup2.setDiffuseColor(color3f2);
                                appearance3 = new Appearance();
                                appearance3.setMaterial((Material)transformGroup2);
                                appearance2 = appearance3;
                            }
                        } else {
                            appearance2 = appearance3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).appearance;
                            color3f2 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                        }
                    } else {
                        appearance3 = appearance;
                        appearance2 = appearance;
                        color3f2 = color3f;
                    }
                } else if (n2 == 14) {
                    if (this.isInBaseFragments(atomData)) {
                        appearance2 = appearance3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).appearance;
                        color3f2 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                    } else {
                        double d3 = this.calcInteractionEnergyManyToOneEnergy(atomData);
                        object6 = this.interactionEnergyColorMap.getRgb(d3);
                        color3f2 = new Color3f((float[])object6);
                        transformGroup2 = new Material();
                        transformGroup2.setDiffuseColor(color3f2);
                        appearance3 = new Appearance();
                        appearance3.setMaterial((Material)transformGroup2);
                        appearance2 = appearance3;
                    }
                }
            }
            if (vector != null && vector.size() != 0) {
                for (int j = 0; j < vector.size(); ++j) {
                    SelectionData selectionData3 = (SelectionData)vector.get(j);
                    if (selectionData3.type != 3 || selectionData3.atomData != atomData) continue;
                    appearance2 = appearance3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).appearance;
                    color3f2 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                    break;
                }
            }
            object = ((AtomTableElement)AtomInfoTable.getElement((String)"H", (int)0)).color;
            Vector vector2 = null;
            if (bl) {
                if (n == 8 || n == 9 || n == 10) {
                    vector2 = this.dnaC3Connect[i];
                    if (vector2 == null && !atomData.isDnaAtom()) {
                        vector2 = this.hemConnect[i];
                    }
                } else {
                    vector2 = this.hemConnect[i];
                }
            } else {
                vector2 = n == 7 ? this.boneConnect[i] : (n == 8 || n == 9 || n == 10 ? this.caConnect[i] : this.atomConnect[i]);
            }
            if ((vector2 == null || vector2.size() == 0) && (bl || !bl && n6 != 8 && n6 != 9 && n6 != 10 && n6 != 7)) {
                vector2 = new Vector();
                vector2.add(atomData);
            }
            boolean bl4 = true;
            if (vector2 != null) {
                float f = 0.0f;
                n8 = 8;
                if (n6 == 3) {
                    n8 = DisplayPreference.BALL_RESOLUTION;
                    f = atomData.atomName.equals("H") ? 0.2f : DisplayPreference.BALL_RADIUS;
                } else if (n6 == 4) {
                    f = DisplayPreference.STICK_RADIUS;
                    n8 = DisplayPreference.STICK_RESOLUTION;
                } else if (n6 == 5) {
                    n8 = DisplayPreference.BALL_RESOLUTION;
                    f = atomData.atomName.equals("H") ? 0.2f : DisplayPreference.BALL_RADIUS;
                } else if (n6 == 6) {
                    f = ((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).radius;
                    n8 = DisplayPreference.CPK_RESOLUTION;
                } else if (n6 == 7) {
                    f = DisplayPreference.STICK_RADIUS;
                    n8 = DisplayPreference.STICK_RESOLUTION;
                }
                object4 = new Sphere(f, 33, n8, appearance3);
                object4.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                this.atomNodeTable.put(atomData, object4);
                transformGroup2 = new Transform3D();
                transformGroup2.set(new Vector3f(atomData.coordX, atomData.coordY, atomData.coordZ));
                object5 = new TransformGroup((Transform3D)transformGroup2);
                object5.addChild((Node)object4);
                transformGroup.addChild((Node)object5);
                int n10 = 0;
                for (int j = 0; j < vector2.size(); ++j) {
                    int n11;
                    float f2;
                    double d4;
                    double d5;
                    AtomData atomData2 = (AtomData)vector2.get(j);
                    if (inDistanceData != null) {
                        ResidueData residueData2 = atomData2.residueData;
                        if (residueData2 == null) {
                            residueData2 = atomData2.residueData;
                        }
                        if (!residueData2.inDisplayFlag) {
                            boolean bl5 = inDistanceData.isInDistance(atomData2);
                            if (!bl5 && !inDistanceData.displayAtom) continue;
                            if (!bl5 && inDistanceData.displayAtom) {
                                if (++n10 != vector2.size()) continue;
                                atomData2 = atomData;
                            }
                        }
                    }
                    if ((n9 == 12 || n9 == 13) && selectionData != null && selectionData.atomData.fragmentNo != atomData.fragmentNo && Math.abs(d5 = this.interactionEnergy[selectionData.atomData.fragmentNo - 1][atomData2.fragmentNo - 1]) < this.cpf.displayInteractionEnergyThreshold || n9 == 14 && Math.abs(d4 = this.calcInteractionEnergyManyToOneEnergy(atomData)) < this.cpf.displayInteractionEnergyManyThreshold) continue;
                    bl2 = true;
                    if (j == 0) {
                        this.displayAtomList.add(atomData);
                    }
                    if (n6 == 1 || n6 == 5 || n6 == 2 || n6 == 8 || (n6 == 10 || n6 == 9) && bl && !atomData.isDnaAtom()) {
                        LineArray lineArray;
                        if (atomData == atomData2 && !atomData.isDnaAtom()) {
                            lineArray = new LineArray(6, 5);
                            lineArray.setCoordinate(0, new Point3f(atomData.coordX + 0.25f, atomData.coordY, atomData.coordZ));
                            lineArray.setCoordinate(1, new Point3f(atomData.coordX - 0.25f, atomData.coordY, atomData.coordZ));
                            lineArray.setCoordinate(2, new Point3f(atomData.coordX, atomData.coordY + 0.25f, atomData.coordZ));
                            lineArray.setCoordinate(3, new Point3f(atomData.coordX, atomData.coordY - 0.25f, atomData.coordZ));
                            lineArray.setCoordinate(4, new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ + 0.25f));
                            lineArray.setCoordinate(5, new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ - 0.25f));
                            if (n6 == 5) {
                                lineArray.setColor(0, (Color3f)object);
                                lineArray.setColor(1, (Color3f)object);
                                lineArray.setColor(2, (Color3f)object);
                                lineArray.setColor(3, (Color3f)object);
                                lineArray.setColor(4, (Color3f)object);
                                lineArray.setColor(5, (Color3f)object);
                            } else {
                                lineArray.setColor(0, color3f2);
                                lineArray.setColor(1, color3f2);
                                lineArray.setColor(2, color3f2);
                                lineArray.setColor(3, color3f2);
                                lineArray.setColor(4, color3f2);
                                lineArray.setColor(5, color3f2);
                            }
                        } else {
                            float f3 = (atomData.coordX + atomData2.coordX) / 2.0f;
                            float f4 = (atomData.coordY + atomData2.coordY) / 2.0f;
                            float f5 = (atomData.coordZ + atomData2.coordZ) / 2.0f;
                            lineArray = new LineArray(2, 5);
                            lineArray.setCoordinate(0, new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ));
                            lineArray.setCoordinate(1, new Point3f(f3, f4, f5));
                            if (n6 == 5) {
                                lineArray.setColor(0, (Color3f)object);
                                lineArray.setColor(1, (Color3f)object);
                            } else if (n6 == 8 || n6 == 10 || n6 == 9) {
                                lineArray.setColor(0, color3f2);
                                lineArray.setColor(1, color3f2);
                            } else if (n6 == 1 || n6 == 2) {
                                Color3f color3f3 = color3f2;
                                if (atomData.fragmentNo != atomData2.fragmentNo && this.isFragmentBoundaryAtom(atomData.no)) {
                                    Object object7;
                                    if (n9 == 5) {
                                        color3f3 = DisplayPreference.fragmentColor[(atomData2.fragmentNo - 1) % DisplayPreference.fragmentColor.length].color;
                                    } else if (n9 == 12 || n9 == 13) {
                                        if (this.interactionEnergyColorMap != null && selectionData != null) {
                                            if (selectionData.atomData.fragmentNo != atomData2.fragmentNo) {
                                                double d6 = this.interactionEnergy[selectionData.atomData.fragmentNo - 1][atomData2.fragmentNo - 1];
                                                if (d6 == 0.0 && this.cpf.isConnectFragment(selectionData.atomData.fragmentNo, atomData2.fragmentNo)) {
                                                    color3f3 = ((ColorData)ResidueInfoTable.get((String)"OTHER")).color;
                                                } else {
                                                    object7 = this.interactionEnergyColorMap.getRgb(d6);
                                                    color3f3 = new Color3f(object7);
                                                }
                                            } else {
                                                color3f3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                                            }
                                        } else {
                                            color3f3 = color3f;
                                        }
                                    } else if (n9 == 14) {
                                        if (this.isInBaseFragments(atomData2)) {
                                            color3f3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                                        } else {
                                            double d7 = this.calcInteractionEnergyManyToOneEnergy(atomData);
                                            object7 = this.interactionEnergyColorMap.getRgb(d7);
                                            color3f3 = new Color3f(object7);
                                        }
                                    }
                                    if (bl4 && n6 == 2) {
                                        bl4 = false;
                                        float f6 = 0.2f;
                                        shape3D = new Sphere(f6, 33, DisplayPreference.BALL_RESOLUTION, appearance3);
                                        shape3D.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                                        object7 = new Transform3D();
                                        object7.set(new Vector3f(atomData.coordX, atomData.coordY, atomData.coordZ));
                                        selectionData2 = new TransformGroup((Transform3D)object7);
                                        selectionData2.addChild((Node)shape3D);
                                        transformGroup.addChild((Node)selectionData2);
                                    }
                                }
                                lineArray.setColor(0, color3f3);
                                lineArray.setColor(1, color3f3);
                            }
                        }
                        LineAttributes lineAttributes = new LineAttributes((float)DisplayPreference.LINE_RESOLUTION, 0, true);
                        Appearance appearance4 = new Appearance();
                        appearance4.setLineAttributes(lineAttributes);
                        Shape3D shape3D2 = new Shape3D((Geometry)lineArray, appearance4);
                        shape3D2.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                        transformGroup.addChild((Node)shape3D2);
                        PickTool.setCapabilities((Node)shape3D2, (int)4100);
                        this.atomNodeTable.put(atomData, shape3D2);
                    }
                    if (n6 == 9 || n6 == 10) {
                        this.createCaSplineNode(atomData, atomData2, this.caAtoms, this.caSplineCoord, n6, residueData, this.chainData, this.fileItem, transformGroup, color3f2, appearance3);
                        if (this.dnaC3Atoms != null && this.dnaC3Atoms.indexOf(atomData) != -1) {
                            this.createCaSplineNode(atomData, atomData2, this.dnaC3Atoms, this.dnaC3SplineCoord, n6, residueData, this.chainData, this.fileItem, transformGroup, color3f2, appearance3);
                        }
                    }
                    if (n6 != 3 && n6 != 5 && n6 != 4 && n6 != 6 && n6 != 7 || n6 != 3 && n6 != 4 && n6 != 7) continue;
                    Appearance appearance5 = appearance2;
                    if (atomData.allAtomName.equalsIgnoreCase("CA") && atomData.fragmentNo != atomData2.fragmentNo && n9 == 5) {
                        appearance5 = DisplayPreference.fragmentColor[(atomData2.fragmentNo - 1) % DisplayPreference.fragmentColor.length].appearance;
                    }
                    TransformGroup transformGroup3 = this.createBondTfg(atomData, atomData2);
                    if (n6 == 3) {
                        f2 = DisplayPreference.BALL_AND_STICK_RADIUS;
                        n11 = DisplayPreference.BALL_RESOLUTION;
                    } else {
                        f2 = DisplayPreference.STICK_RADIUS;
                        n11 = DisplayPreference.STICK_RESOLUTION;
                    }
                    Cylinder cylinder = new Cylinder(f2, 1.0f, 33, n11, 2, appearance5);
                    cylinder.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                    transformGroup3.addChild((Node)cylinder);
                    transformGroup.addChild((Node)transformGroup3);
                }
            }
            if (atomData.isDnaAtom() && (n6 == 9 || n6 == 10 || n6 == 8) && (n7 = this.dnaC3Atoms.indexOf(atomData)) != -1) {
                object5 = (AtomData)this.dnaNAtoms.get(n7);
                if (n9 == 5) {
                    if (object5.fragmentNo != 0) {
                        appearance3 = DisplayPreference.fragmentColor[(object5.fragmentNo - 1) % DisplayPreference.fragmentColor.length].appearance;
                        color3f2 = DisplayPreference.fragmentColor[(object5.fragmentNo - 1) % DisplayPreference.fragmentColor.length].color;
                    }
                } else if (n9 == 12 || n9 == 13) {
                    if (this.interactionEnergyColorMap != null && selectionData != null) {
                        if (selectionData.atomData.fragmentNo != object5.fragmentNo) {
                            double d8 = this.interactionEnergy[selectionData.atomData.fragmentNo - 1][object5.fragmentNo - 1];
                            if (d8 == 0.0 && this.cpf.isConnectFragment(selectionData.atomData.fragmentNo, object5.fragmentNo)) {
                                appearance3 = ((ColorData)ResidueInfoTable.get((String)"OTHER")).appearance;
                                color3f2 = ((ColorData)ResidueInfoTable.get((String)"OTHER")).color;
                            } else {
                                object4 = this.interactionEnergyColorMap.getRgb(d8);
                                color3f2 = new Color3f((float[])object4);
                                Material material = new Material();
                                material.setDiffuseColor(color3f2);
                                appearance3 = new Appearance();
                                appearance3.setMaterial(material);
                            }
                        } else {
                            appearance3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).appearance;
                            color3f2 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                        }
                    }
                } else if (n9 == 14) {
                    if (this.isInBaseFragments((AtomData)object5)) {
                        color3f2 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                    } else {
                        double d9 = this.calcInteractionEnergyManyToOneEnergy((AtomData)object5);
                        object4 = this.interactionEnergyColorMap.getRgb(d9);
                        color3f2 = new Color3f((float[])object4);
                        Material material = new Material();
                        material.setDiffuseColor(color3f2);
                        appearance3 = new Appearance();
                        appearance3.setMaterial(material);
                    }
                }
                float f = (atomData.coordX + object5.coordX) / 2.0f;
                float f7 = (atomData.coordY + object5.coordY) / 2.0f;
                float f8 = (atomData.coordZ + object5.coordZ) / 2.0f;
                if (n6 == 8 || n6 == 9) {
                    LineArray lineArray = new LineArray(2, 5);
                    lineArray.setCoordinate(0, new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ));
                    lineArray.setCoordinate(1, new Point3f(f, f7, f8));
                    lineArray.setColor(0, color3f2);
                    lineArray.setColor(1, color3f2);
                    float f9 = n6 == 8 ? (float)DisplayPreference.LINE_RESOLUTION : (float)DisplayPreference.CA_LINE_RESOLUTION;
                    LineAttributes lineAttributes = new LineAttributes(f9, 0, true);
                    Appearance appearance6 = new Appearance();
                    appearance6.setLineAttributes(lineAttributes);
                    shape3D = new Shape3D((Geometry)lineArray, appearance6);
                    shape3D.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                    transformGroup.addChild((Node)shape3D);
                    PickTool.setCapabilities((Node)shape3D, (int)4100);
                    this.atomNodeTable.put(atomData, shape3D);
                    lineArray = new LineArray(2, 5);
                    lineArray.setCoordinate(0, new Point3f(object5.coordX, object5.coordY, object5.coordZ));
                    lineArray.setCoordinate(1, new Point3f(f, f7, f8));
                    if (n9 == 1) {
                        color3f2 = ((AtomTableElement)AtomInfoTable.getElement((String)object5.atomName, (int)atomData.atomNo)).color;
                        if (vector != null && vector.size() != 0) {
                            for (int j = 0; j < vector.size(); ++j) {
                                selectionData2 = (SelectionData)vector.get(j);
                                if (selectionData2.type != 3 || selectionData2.atomData != object5) continue;
                                color3f2 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).color;
                                break;
                            }
                        }
                    }
                    lineArray.setColor(0, color3f2);
                    lineArray.setColor(1, color3f2);
                    shape3D = new Shape3D((Geometry)lineArray, appearance6);
                    shape3D.setUserData((Object)new NodeData(this, (AtomData)object5, residueData, this.chainData, this.fileItem, 3));
                    transformGroup.addChild((Node)shape3D);
                    PickTool.setCapabilities((Node)shape3D, (int)4100);
                    this.atomNodeTable.put(object5, shape3D);
                } else {
                    TransformGroup transformGroup4 = this.createBondTfg(atomData, (AtomData)object5);
                    Cylinder cylinder = new Cylinder(DisplayPreference.CA_TUBE_RADIUS, 1.0f, 33, DisplayPreference.CA_TUBE_RESOLUTION, 2, appearance3);
                    cylinder.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                    transformGroup4.addChild((Node)cylinder);
                    transformGroup.addChild((Node)transformGroup4);
                    if (n9 == 1) {
                        appearance3 = ((AtomTableElement)AtomInfoTable.getElement((String)object5.atomName, (int)object5.atomNo)).appearance;
                        if (vector != null && vector.size() != 0) {
                            for (int j = 0; j < vector.size(); ++j) {
                                SelectionData selectionData4 = (SelectionData)vector.get(j);
                                if (selectionData4.type != 3 || selectionData4.atomData != object5) continue;
                                appearance3 = ((ColorData)ResidueInfoTable.get((String)"SELECT")).appearance;
                                break;
                            }
                        }
                    }
                    transformGroup4 = this.createBondTfg((AtomData)object5, atomData);
                    cylinder = new Cylinder(DisplayPreference.CA_TUBE_RADIUS, 1.0f, 33, DisplayPreference.CA_TUBE_RESOLUTION, 2, appearance3);
                    cylinder.setUserData((Object)new NodeData(this, (AtomData)object5, residueData, this.chainData, this.fileItem, 3));
                    transformGroup4.addChild((Node)cylinder);
                    transformGroup.addChild((Node)transformGroup4);
                }
            }
            if (!DisplayPreference.arrow.display || this.fileItem.type != 11 && this.fileItem.type != 13 || !(bl3 = this.fileItem.type == 11 ? ((XyzFile)this.fileItem.file).hasVector : ((TrajectoryFile)this.fileItem.file).hasVector)) continue;
            object5 = new Appearance();
            if (DisplayPreference.arrow.colorMode == 0) {
                object3 = new ColorMap(DisplayPreference.arrow.min, DisplayPreference.arrow.max, 0, 2);
                Material material = new Material();
                material.setDiffuseColor(new Color3f(((ColorMap)object3).getRgb(atomData.vLength)));
                object5.setMaterial(material);
            } else {
                object3 = new Material();
                object3.setDiffuseColor(new Color3f(DisplayPreference.arrow.color));
                object5.setMaterial((Material)object3);
            }
            float f = atomData.coordX;
            float f10 = atomData.coordY;
            float f11 = atomData.coordZ;
            float f12 = atomData.vx * DisplayPreference.arrow.scale;
            float f13 = atomData.vy * DisplayPreference.arrow.scale;
            float f14 = atomData.vz * DisplayPreference.arrow.scale;
            float f15 = DisplayPreference.arrow.ratio / 100.0f;
            if (DisplayPreference.arrow.mode == 0) {
                float f16 = (float)Math.sqrt(f12 * f12 + f13 * f13 + f14 * f14);
                f15 = DisplayPreference.arrow.length / f16;
            }
            float f17 = f12 * (1.0f - f15) + f;
            float f18 = f13 * (1.0f - f15) + f10;
            float f19 = f14 * (1.0f - f15) + f11;
            TransformGroup transformGroup5 = MolecularStructure.createBondTfg(f, f10, f11, f17, f18, f19);
            Cylinder cylinder = new Cylinder(DisplayPreference.arrow.bodyRadius, 1.0f, 33, DisplayPreference.CA_TUBE_RESOLUTION, 2, (Appearance)object5);
            cylinder.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
            transformGroup5.addChild((Node)cylinder);
            transformGroup.addChild((Node)transformGroup5);
            transformGroup5 = MolecularStructure.createBondTfg(f17, f18, f19, f12 + f, f13 + f10, f14 + f11);
            Cone cone = new Cone(DisplayPreference.arrow.headRadius, 1.0f, 33, (Appearance)object5);
            cone.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
            transformGroup5.addChild((Node)cone);
            transformGroup.addChild((Node)transformGroup5);
        }
        if ((n3 != 0 && object2 == null || object2 != null && ((NodeData)object2).label != 0) && bl2) {
            Transform3D transform3D = new Transform3D();
            float f = 0.5f;
            transform3D.setScale((double)f);
            float f20 = 0.0f;
            float f21 = 0.0f;
            float f22 = 0.0f;
            for (n6 = residueData.startNo; n6 <= residueData.endNo; ++n6) {
                AtomData atomData = null;
                atomData = bl ? (AtomData)this.hemTable.get(n6) : (AtomData)this.atomTable.get(n6);
                f20 += atomData.coordX;
                f21 += atomData.coordY;
                f22 += atomData.coordZ;
            }
            Point3f point3f = new Point3f((f20 /= (float)(residueData.endNo - residueData.startNo + 1)) / f, (f21 /= (float)(residueData.endNo - residueData.startNo + 1)) / f, (f22 /= (float)(residueData.endNo - residueData.startNo + 1)) / f);
            TransformGroup transformGroup6 = new TransformGroup(transform3D);
            nodeData = new Text3D(this.font, residueData.name + residueData.no, point3f);
            object = new OrientedShape3D((Geometry)nodeData, this.residueLabelAppearance, 1, point3f);
            object.setPickable(false);
            transformGroup6.addChild((Node)object);
            transformGroup.addChild((Node)transformGroup6);
        }
        branchGroup.addChild((Node)transformGroup);
        return branchGroup;
    }

    private void createCaSplineNode(AtomData atomData, AtomData atomData2, Vector vector, float[] fArray, int n, ResidueData residueData, ChainData chainData, FileItem fileItem, TransformGroup transformGroup, Color3f color3f, Appearance appearance) {
        if (n == 9 || n == 10) {
            int n2 = vector.indexOf(atomData);
            if (n2 == -1) {
                return;
            }
            int n3 = atomData.no < atomData2.no ? n2 * this.splineDivNum * 3 : (n2 - 1) * this.splineDivNum * 3 + this.splineDivNum / 2 * 3;
            if (n == 9) {
                LineStripArray lineStripArray = new LineStripArray(this.splineDivNum / 2 + 1, 5, this.stripCount);
                for (int i = 0; i < this.splineDivNum / 2 + 1; ++i) {
                    lineStripArray.setCoordinate(i, new Point3f(fArray[n3 + 3 * i], fArray[n3 + 3 * i + 1], fArray[n3 + 3 * i + 2]));
                    lineStripArray.setColor(i, color3f);
                }
                LineAttributes lineAttributes = new LineAttributes((float)DisplayPreference.CA_LINE_RESOLUTION, 0, true);
                lineAttributes.setLineAntialiasingEnable(true);
                Appearance appearance2 = new Appearance();
                appearance2.setLineAttributes(lineAttributes);
                Shape3D shape3D = new Shape3D((Geometry)lineStripArray, appearance2);
                shape3D.setUserData((Object)new NodeData(this, atomData, residueData, chainData, fileItem, 3));
                transformGroup.addChild((Node)shape3D);
                PickTool.setCapabilities((Node)shape3D, (int)4100);
                this.atomNodeTable.put(atomData, shape3D);
            } else {
                TransformGroup transformGroup2;
                Sphere sphere = null;
                for (int i = 0; i < this.splineDivNum / 2; ++i) {
                    transformGroup2 = MolecularStructure.createBondTfg(fArray[n3 + 3 * i], fArray[n3 + 3 * i + 1], fArray[n3 + 3 * i + 2], fArray[n3 + 3 * (i + 1)], fArray[n3 + 3 * (i + 1) + 1], fArray[n3 + 3 * (i + 1) + 2]);
                    Cylinder cylinder = new Cylinder(DisplayPreference.CA_TUBE_RADIUS, 1.0f, 33, DisplayPreference.CA_TUBE_RESOLUTION, 2, appearance);
                    cylinder.setUserData((Object)new NodeData(this, atomData, residueData, chainData, fileItem, 3));
                    transformGroup2.addChild((Node)cylinder);
                    transformGroup.addChild((Node)transformGroup2);
                    sphere = new Sphere(DisplayPreference.CA_TUBE_RADIUS, 33, DisplayPreference.CA_TUBE_RESOLUTION, appearance);
                    sphere.setUserData((Object)new NodeData(this, atomData, residueData, chainData, fileItem, 3));
                    Transform3D transform3D = new Transform3D();
                    transform3D.set(new Vector3f(fArray[n3 + 3 * i], fArray[n3 + 3 * i + 1], fArray[n3 + 3 * i + 2]));
                    transformGroup2 = new TransformGroup(transform3D);
                    transformGroup2.addChild((Node)sphere);
                    transformGroup.addChild((Node)transformGroup2);
                }
                this.atomNodeTable.put(atomData, sphere);
                if (n2 == vector.size() - 1) {
                    sphere = new Sphere(DisplayPreference.CA_TUBE_RADIUS, 33, DisplayPreference.CA_TUBE_RESOLUTION, appearance);
                    sphere.setUserData((Object)new NodeData(this, atomData, residueData, chainData, fileItem, 3));
                    Transform3D transform3D = new Transform3D();
                    transform3D.set(new Vector3f(atomData.coordX, atomData.coordY, atomData.coordZ));
                    transformGroup2 = new TransformGroup(transform3D);
                    transformGroup2.addChild((Node)sphere);
                    transformGroup.addChild((Node)transformGroup2);
                }
            }
        }
    }

    public boolean isFragmentBoundaryAtom(int n) {
        boolean bl = false;
        if (this.cpf == null) {
            return bl;
        }
        for (int i = 0; i < this.cpf.infoFragmentConnection.length; ++i) {
            if (this.cpf.infoFragmentConnection[i][0] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Switch createNode(int n, int n2, int n3, int n4, boolean[] blArray, boolean[] blArray2, Hashtable hashtable, InDistanceData inDistanceData, Vector vector) {
        Object object;
        int n5;
        this.displayModel = n;
        this.colorStyle = n2;
        this.root = new Switch();
        this.root.setCapability(14);
        this.root.setCapability(13);
        this.root.setCapability(18);
        this.root.setCapability(17);
        this.root.setWhichChild(-3);
        this.root.setUserData((Object)this);
        this.createDisplyaResidueTable(inDistanceData);
        this.createHBonds(inDistanceData);
        for (n5 = 0; n5 < this.residueTable.size(); ++n5) {
            int n6;
            object = (ResidueData)this.residueTable.get(n5);
            for (n6 = 0; n6 < Constants.RESIDUE_NAME.length && !((ResidueData)object).name.equalsIgnoreCase(Constants.RESIDUE_NAME[n6]); ++n6) {
            }
            if (n6 != Constants.RESIDUE_NAME.length && !blArray[n6]) continue;
            this.root.addChild((Node)this.createResidueNode((ResidueData)object, false, n, this.colorStyle, n3, n4, vector, hashtable, inDistanceData, n6));
        }
        for (n5 = 0; n5 < this.hemResidueTable.size(); ++n5) {
            object = (ResidueData)this.hemResidueTable.get(n5);
            this.root.addChild((Node)this.createResidueNode((ResidueData)object, true, n, this.colorStyle, n3, n4, vector, hashtable, inDistanceData, -1));
        }
        if (this.displayModel != 7 && this.ssTable.size() > 0) {
            BranchGroup branchGroup = new BranchGroup();
            object = this.chainData.ssTable;
            Appearance appearance = ((ColorData)ResidueInfoTable.get((String)"SS")).appearance;
            Color3f color3f = ((ColorData)ResidueInfoTable.get((String)"SS")).color;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                int n7;
                float f;
                int n8 = ((SsData)((Vector)object).get((int)i)).atomIndex1;
                int n9 = ((SsData)((Vector)object).get((int)i)).atomIndex2;
                AtomData atomData = (AtomData)this.atomTable.get(n8);
                AtomData atomData2 = (AtomData)this.atomTable.get(n9);
                if (inDistanceData != null && !inDistanceData.isInDistance(atomData) && !inDistanceData.isInDistance(atomData2)) continue;
                ResidueData residueData = atomData.residueData;
                ResidueData residueData2 = atomData2.residueData;
                if (this.displayModel == 1 || this.displayModel == 2 || this.displayModel == 5) {
                    LineArray lineArray = new LineArray(2, 5);
                    lineArray.setCoordinate(0, new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ));
                    lineArray.setCoordinate(1, new Point3f(atomData2.coordX, atomData2.coordY, atomData2.coordZ));
                    lineArray.setColor(0, color3f);
                    lineArray.setColor(1, color3f);
                    Shape3D shape3D = new Shape3D((Geometry)lineArray);
                    shape3D.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                    shape3D.setPickable(false);
                    branchGroup.addChild((Node)shape3D);
                    continue;
                }
                if (this.displayModel != 4 && this.displayModel != 3) continue;
                if (this.displayModel == 4) {
                    f = DisplayPreference.STICK_RADIUS;
                    n7 = DisplayPreference.STICK_RESOLUTION;
                } else {
                    f = DisplayPreference.BALL_AND_STICK_RADIUS;
                    n7 = DisplayPreference.BALL_RESOLUTION;
                }
                TransformGroup transformGroup = this.createBondTfg(atomData, atomData2);
                Cylinder cylinder = new Cylinder(f, 1.0f, 1, n7, 2, appearance);
                cylinder.setUserData((Object)new NodeData(this, atomData, residueData, this.chainData, this.fileItem, 3));
                cylinder.setPickable(false);
                transformGroup.addChild((Node)cylinder);
                branchGroup.addChild((Node)transformGroup);
                transformGroup = this.createBondTfg(atomData2, atomData);
                cylinder = new Cylinder(f, 1.0f, 1, n7, 2, appearance);
                cylinder.setUserData((Object)new NodeData(this, atomData2, residueData2, this.chainData, this.fileItem, 3));
                cylinder.setPickable(false);
                transformGroup.addChild((Node)cylinder);
                branchGroup.addChild((Node)transformGroup);
            }
            this.root.addChild((Node)branchGroup);
        }
        this.rootBitSet = new BitSet();
        this.rootBitSet.set(2, this.root.numChildren(), true);
        this.setHBondsEnable(false, false);
        return this.root;
    }

    public void highlightSelection(int n, int n2, int n3, int n4, Vector vector, Hashtable hashtable, InDistanceData inDistanceData) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SelectionData selectionData = (SelectionData)vector.get(i);
            boolean bl = false;
            BranchGroup branchGroup = (BranchGroup)this.residueNodeTable.get(selectionData.residueData);
            if (branchGroup == null) {
                bl = true;
                branchGroup = (BranchGroup)this.hemResidueNodeTable.get(selectionData.residueData);
            }
            if (branchGroup == null) continue;
            branchGroup.detach();
            if (selectionData.type == 2) {
                int n5;
                for (n5 = 0; n5 < Constants.RESIDUE_NAME.length && !selectionData.residueData.name.equalsIgnoreCase(Constants.RESIDUE_NAME[n5]); ++n5) {
                }
                this.root.addChild((Node)this.createResidueNode(selectionData.residueData, bl, n, 16, n3, n4, null, hashtable, inDistanceData, n5));
                continue;
            }
            this.root.addChild((Node)this.createResidueNode(selectionData.residueData, bl, n, n2, n3, n4, vector, hashtable, inDistanceData, -1));
        }
    }

    public void clearHighlightSelection(int n, int n2, int n3, int n4, Vector vector, Hashtable hashtable, InDistanceData inDistanceData) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n5;
            SelectionData selectionData = (SelectionData)vector.get(i);
            boolean bl = false;
            BranchGroup branchGroup = (BranchGroup)this.residueNodeTable.get(selectionData.residueData);
            if (branchGroup == null) {
                bl = true;
                branchGroup = (BranchGroup)this.hemResidueNodeTable.get(selectionData.residueData);
            }
            if (branchGroup == null) continue;
            branchGroup.detach();
            this.residueNodeTable.remove(selectionData.residueData);
            for (n5 = 0; n5 < Constants.RESIDUE_NAME.length && !selectionData.residueData.name.equalsIgnoreCase(Constants.RESIDUE_NAME[n5]); ++n5) {
            }
            this.root.addChild((Node)this.createResidueNode(selectionData.residueData, bl, n, n2, n3, n4, null, hashtable, inDistanceData, n5));
        }
    }

    public Node getNodeData(SelectionData selectionData) {
        Node node = null;
        if (selectionData.type == 2 || selectionData.type == 1) {
            node = (Node)this.residueNodeTable.get(selectionData.residueData);
            if (node == null) {
                node = (Node)this.hemResidueNodeTable.get(selectionData.residueData);
            }
        } else {
            node = (Node)this.atomNodeTable.get(selectionData.atomData);
        }
        return node;
    }

    public Vector getAtomTable(ResidueData residueData) {
        if (this.residueNodeTable.get(residueData) != null) {
            return this.atomTable;
        }
        if (this.hemResidueNodeTable.get(residueData) != null) {
            return this.hemTable;
        }
        return null;
    }

    private boolean isConnect(AtomData atomData, AtomData atomData2) {
        boolean bl = false;
        if (atomData.residueNo == atomData2.residueNo && atomData.iCode == null || atomData.iCode != null && atomData.iCode.equals(atomData2.iCode) && (!atomData.atomName.equalsIgnoreCase("H") || !atomData2.atomName.equalsIgnoreCase("H"))) {
            double d = this.distance(atomData.coordX - atomData2.coordX, atomData.coordY - atomData2.coordY, atomData.coordZ - atomData2.coordZ);
            if (d < this.CPKdistance(atomData, atomData2)) {
                bl = true;
                if ((atomData.atomName.equals("H") || atomData2.atomName.equals("H")) && !atomData.extention.equals("_") && !atomData2.extention.equals("_")) {
                    // empty if block
                }
            } else if (!((atomData.atomName.equalsIgnoreCase("C") || atomData.atomName.equalsIgnoreCase("H") || atomData.atomName.equalsIgnoreCase("N") || atomData.atomName.equalsIgnoreCase("O")) && (atomData2.atomName.equalsIgnoreCase("C") || atomData2.atomName.equalsIgnoreCase("H") || atomData2.atomName.equalsIgnoreCase("N") || atomData2.atomName.equalsIgnoreCase("O")) || !(d < 2.0))) {
                bl = true;
            }
        }
        return bl;
    }

    private double distance(float f, float f2, float f3) {
        return Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private double distance(AtomData atomData, AtomData atomData2) {
        double d = atomData.x - atomData2.x;
        double d2 = atomData.y - atomData2.y;
        double d3 = atomData.z - atomData2.z;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return d4;
    }

    private double CPKdistance(AtomData atomData, AtomData atomData2) {
        double d = DisplayPreference.CONNECT_ATOM_RADIUS == 0 ? (double)(((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).radius + ((AtomTableElement)AtomInfoTable.getElement((String)atomData2.atomName, (int)atomData2.atomNo)).radius) / 1.99 * (double)DisplayPreference.CONNECT_ATOM_SCALE : (double)(((AtomTableElement)AtomInfoTable.getElement((String)atomData.atomName, (int)atomData.atomNo)).covalent + ((AtomTableElement)AtomInfoTable.getElement((String)atomData2.atomName, (int)atomData2.atomNo)).covalent) * (double)DisplayPreference.CONNECT_ATOM_SCALE;
        return d;
    }

    private void connectHCheck(Vector[] vectorArray, Vector vector, int n, int n2, AtomData atomData, AtomData atomData2) {
        int n3 = -1;
        AtomData atomData3 = null;
        if (atomData.atomName.equals("H")) {
            n3 = n;
            atomData3 = atomData;
        } else if (atomData2.atomName.equals("H")) {
            n3 = n2;
            atomData3 = atomData2;
        }
        if (n3 == -1 || vectorArray[n3].size() == 0) {
            vectorArray[n].add(atomData2);
            vectorArray[n2].add(atomData);
        } else {
            AtomData atomData4 = (AtomData)vectorArray[n3].get(0);
            int n4 = vector.indexOf(atomData4);
            if (this.distance(atomData4.x - atomData3.x, atomData4.y - atomData3.y, atomData4.z - atomData3.z) - this.distance(atomData.x - atomData2.x, atomData.y - atomData2.y, atomData.z - atomData2.z) > 0.0) {
                vectorArray[n3].removeAllElements();
                vectorArray[n4].remove(atomData3);
                vectorArray[n].add(atomData2);
                vectorArray[n2].add(atomData);
            }
        }
    }

    public Switch getRootNode() {
        return this.root;
    }

    public void createHBondsConnect() {
        AtomData atomData;
        AtomData atomData2;
        int n;
        AtomData atomData3;
        int n2;
        float f = 2.7f;
        f *= f;
        float f2 = 120.0f;
        for (n2 = 0; n2 < this.atomTable.size(); ++n2) {
            atomData3 = (AtomData)this.atomTable.get(n2);
            if (!atomData3.atomName.equals("H")) continue;
            for (n = 0; n < this.atomTable.size(); ++n) {
                atomData2 = (AtomData)this.atomTable.get(n);
                if (Math.abs(atomData3.residueNo - atomData2.residueNo) <= 2 || atomData2.atomName.equals("H") || atomData2.atomName.equals("C") || !(atomData3.distance2(atomData2) < f) || this.atomConnect == null || this.atomConnect[n2].size() <= 0 || (atomData = (AtomData)this.atomConnect[n2].get(0)) == null || !(this.angle(atomData3, atomData2, atomData) > f2)) continue;
                this.hBondsPeptideConnect.add(atomData3);
                this.hBondsPeptideConnect.add(atomData2);
            }
            for (n = 0; n < this.hemTable.size(); ++n) {
                atomData2 = (AtomData)this.hemTable.get(n);
                if (!atomData2.atomName.equals("H") || atomData2.atomName.equals("C") || !(atomData3.distance2(atomData2) < f) || this.atomConnect == null || this.atomConnect[n2].size() <= 0 || (atomData = (AtomData)this.atomConnect[n2].get(0)) == null || !(this.angle(atomData3, atomData2, atomData) > f2)) continue;
                this.hBondsHemConnect.add(atomData3);
                this.hBondsHemConnect.add(atomData2);
            }
        }
        for (n2 = 0; n2 < this.hemTable.size(); ++n2) {
            atomData3 = (AtomData)this.hemTable.get(n2);
            if (!atomData3.atomName.equals("H")) continue;
            for (n = 0; n < this.hemTable.size(); ++n) {
                atomData2 = (AtomData)this.hemTable.get(n);
                if (atomData3.residueNo == atomData2.residueNo || atomData2.atomName.equals("H") || atomData2.atomName.equals("C") || !(atomData3.distance2(atomData2) < f) || (atomData = (AtomData)this.hemConnect[n2].get(0)) == null || !(this.angle(atomData3, atomData2, atomData) > f2)) continue;
                this.hBondsHemConnect.add(atomData3);
                this.hBondsHemConnect.add(atomData2);
            }
            for (n = 0; n < this.atomTable.size(); ++n) {
                atomData2 = (AtomData)this.atomTable.get(n);
                if (atomData2.cutFlag || atomData2.atomName.equals("H") || atomData2.atomName.equals("C") || !(atomData3.distance2(atomData2) < f) || this.hemConnect[n2].size() <= 0 || (atomData = (AtomData)this.hemConnect[n2].get(0)) == null || !(this.angle(atomData3, atomData2, atomData) > f2)) continue;
                this.hBondsHemConnect.add(atomData3);
                this.hBondsHemConnect.add(atomData2);
            }
        }
    }

    public void createHBonds(InDistanceData inDistanceData) {
        AtomData atomData;
        AtomData atomData2;
        int n;
        Color3f color3f = new Color3f(0.0f, 1.0f, 1.0f);
        Vector<Point3f> vector = new Vector<Point3f>();
        Vector<Point3f> vector2 = new Vector<Point3f>();
        for (n = 0; n < this.hBondsPeptideConnect.size(); n += 2) {
            atomData2 = (AtomData)this.hBondsPeptideConnect.get(n);
            atomData = (AtomData)this.hBondsPeptideConnect.get(n + 1);
            if (atomData2.cutFlag || atomData.cutFlag || Math.abs(atomData2.residueNo - atomData.residueNo) <= 2 || !(atomData2.distance2(atomData) < 7.29f) || inDistanceData != null && (inDistanceData == null || !inDistanceData.isInDistance(atomData2) || !inDistanceData.isInDistance(atomData))) continue;
            vector.add(new Point3f(atomData2.coordX, atomData2.coordY, atomData2.coordZ));
            vector.add(new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ));
        }
        for (n = 0; n < this.hBondsHemConnect.size(); n += 2) {
            atomData2 = (AtomData)this.hBondsHemConnect.get(n);
            atomData = (AtomData)this.hBondsHemConnect.get(n + 1);
            if (atomData2.cutFlag || atomData.cutFlag || Math.abs(atomData2.residueNo - atomData.residueNo) <= 2 || !(atomData2.distance2(atomData) < 7.29f) || inDistanceData != null && (inDistanceData == null || !inDistanceData.isInDistance(atomData2) || !inDistanceData.isInDistance(atomData))) continue;
            vector2.add(new Point3f(atomData2.coordX, atomData2.coordY, atomData2.coordZ));
            vector2.add(new Point3f(atomData.coordX, atomData.coordY, atomData.coordZ));
        }
        if (vector.size() != 0) {
            atomData2 = new LineAttributes((float)DisplayPreference.LINE_RESOLUTION, 1, true);
            Appearance appearance = new Appearance();
            appearance.setLineAttributes((LineAttributes)atomData2);
            atomData = new LineArray(vector.size(), 5);
            for (int i = 0; i < vector.size(); ++i) {
                atomData.setCoordinate(i, (Point3f)vector.get(i));
                atomData.setColor(i, color3f);
            }
            Shape3D shape3D = new Shape3D((Geometry)atomData, appearance);
            shape3D.setPickable(false);
            this.root.addChild((Node)shape3D);
        } else {
            this.root.addChild((Node)new TransformGroup());
        }
        if (vector2.size() != 0) {
            atomData2 = new LineAttributes((float)DisplayPreference.LINE_RESOLUTION, 1, true);
            Appearance appearance = new Appearance();
            appearance.setLineAttributes((LineAttributes)atomData2);
            atomData = new LineArray(vector2.size(), 5);
            for (int i = 0; i < vector2.size(); ++i) {
                atomData.setCoordinate(i, (Point3f)vector2.get(i));
                atomData.setColor(i, color3f);
            }
            Shape3D shape3D = new Shape3D((Geometry)atomData, appearance);
            shape3D.setPickable(false);
            this.root.addChild((Node)shape3D);
        } else {
            this.root.addChild((Node)new TransformGroup());
        }
    }

    private float angle(AtomData atomData, AtomData atomData2, AtomData atomData3) {
        Vector3f vector3f = new Vector3f(atomData.x - atomData3.x, atomData.y - atomData3.y, atomData.z - atomData3.z);
        Vector3f vector3f2 = new Vector3f(atomData.x - atomData2.x, atomData.y - atomData2.y, atomData.z - atomData2.z);
        float f = vector3f.angle(vector3f2) / (float)Math.PI * 180.0f;
        return f;
    }

    public void setHBondsEnable(boolean bl, boolean bl2) {
        this.rootBitSet.set(0, bl);
        this.rootBitSet.set(1, bl2);
        this.root.setChildMask(this.rootBitSet);
    }

    private void createDisplyaResidueTable(InDistanceData inDistanceData) {
        if (inDistanceData != null && !inDistanceData.displayAtom) {
            AtomData atomData;
            int n;
            ResidueData residueData;
            int n2;
            for (n2 = 0; n2 < this.residueTable.size(); ++n2) {
                residueData = (ResidueData)this.residueTable.get(n2);
                for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                    atomData = (AtomData)this.atomTable.get(n);
                    if (!atomData.cutFlag && inDistanceData.isInDistance(atomData)) break;
                }
                residueData.inDisplayFlag = n != residueData.endNo + 1;
            }
            for (n2 = 0; n2 < this.hemResidueTable.size(); ++n2) {
                residueData = (ResidueData)this.hemResidueTable.get(n2);
                for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                    atomData = (AtomData)this.hemTable.get(n);
                    if (!atomData.cutFlag && inDistanceData.isInDistance(atomData)) break;
                }
                residueData.inDisplayFlag = n != residueData.endNo + 1;
            }
        }
    }

    private boolean isInBaseFragments(AtomData atomData) {
        if (this.interactionEnergyManyToOneData != null && this.interactionEnergyManyToOneData.size() != 0) {
            for (int i = 0; i < this.interactionEnergyManyToOneData.size(); ++i) {
                int n = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).start;
                int n2 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).end;
                if (n > atomData.fragmentNo || atomData.fragmentNo > n2) continue;
                return true;
            }
        }
        return false;
    }

    private double calcInteractionEnergyManyToOneEnergy(AtomData atomData) {
        double d = 0.0;
        if (this.interactionEnergyManyToOneData != null && this.interactionEnergyManyToOneData.size() != 0) {
            for (int i = 0; i < this.interactionEnergyManyToOneData.size(); ++i) {
                int n = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).start;
                int n2 = ((StartEnd)this.interactionEnergyManyToOneData.get((int)i)).end;
                for (int j = n; j <= n2; ++j) {
                    d += this.cpf.interactionEnergy[j - 1][atomData.fragmentNo - 1];
                }
            }
        }
        return d;
    }
}

