/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.AbinitMpFile;

import AbinitMp.Tool.FillSpace;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AjfFile {
    public static final int HARTREE_FOCK = 0;
    public static final int MP2 = 1;
    public static final int HFO_5G = 0;
    public static final int STO_3G = 1;
    public static final int B3_21G = 2;
    public static final int B4_31G = 3;
    public static final int B5_31G = 4;
    public static final int B6_31G = 5;
    public static final int B6_31GS = 6;
    public static final int B6_31GSS = 7;
    public static final int S1 = 0;
    public static final int S2 = 1;
    public static final int S3 = 2;
    public static final int SU = 3;
    public static final int D1 = 4;
    public static final int D2 = 5;
    public static final int D3 = 6;
    public static final int DU = 7;
    public static final int T1 = 8;
    public static final int TU = 9;
    public static final int CHECK_INPUT = 0;
    public static final int DETAIL = 1;
    public static final int DUMMY_NPRINT = 3;
    public static final int STANDARD = 3;
    public static final int INITIAL_MO = 4;
    public static final int BFGS = 0;
    public static final int CG = 1;
    public static final int ALL_ATOMS = 0;
    public static final int H_ATOMS = 1;
    public static final int BASE_SUGER_PHOSPHATE = 0;
    public static final int BASE_or_SUGER_PHOSPHATE = 1;
    public static final int NONE_NONE_NONE = 0;
    public static final int ESPAOC_ESPAOC_NONE = 1;
    public static final int ESPAOC_ESPPTC_NONE = 2;
    public static final int ESPAOC_ESPPTC_USE = 3;
    public static final int NONE_NONE_USE = 4;
    public static final int NONE_ESPPTC_USE = 5;
    public static final int NONE_ESPPTC_NONE = 6;
    public static final int ESPAOC_ESPAOC_USE = 7;
    public static final int IN_CORE = 0;
    public static final int SEMI_DIRECT = 1;
    public static final int FULL_DIRECT = 2;
    public static final String[] basisSetString = new String[]{"STO-3G", "HFO-5G", "3-21G", "4-31G", "6-31G", "6-31G(d)", "6-31G(d,p)"};
    public static final String[] electronicStateString = new String[]{"S1", "S2", "S3", "SU", "D1", "D2", "D3", "DU", "T1", "TU"};
    public static final String[] methodString = new String[]{"HF"};
    public static final String[] optimizeMethodString = new String[]{"BFGS", "CG"};
    public static final String[] onOffString = new String[]{"ON", "OFF"};
    public static final String[] nucleotideString = new String[]{"+base", "/base"};
    public static final String[] directScfString = new String[]{"semi", "core", "full"};
    public String title;
    public int basisSet;
    public int electronicState;
    public int method;
    public int maxCycle;
    public float maxGrad;
    public boolean optimize;
    public int optimizeMethod;
    public int hopt;
    public int nprint;
    public boolean fmo;
    public boolean autoFrag;
    public boolean fragSizeResidueFrag;
    public int fragSizeResidue;
    public boolean fragSizeNucleotideFrag;
    public int fragSizeNucleotide;
    public int numberOfFragment;
    public float charge;
    public int maxSccCycle;
    public float maxSccEnergy;
    public int approximationLevel;
    public float laoc;
    public float lptc;
    public float ldimer;
    public int np;
    public int directScf;
    public int mo1;
    public int mo2;
    public float vshift;
    public float kshift;
    public float lshift;
    public int nAtom;
    public String ligandCharge;
    public String readGeom;
    public String writeGeom;
    public float maxScfEnergy;
    public float maxScfDensity;
    public int maxScfCycle;
    public String ghost;
    public int[] numberOfAtomsComposingFragment;
    public int[] formalCharge;
    public int[] numberOfInterfragmentBonds;
    public Vector atomicNumberComposingFragment = new Vector();
    public int[] atomicNumberOfFragmentBonds;

    public AjfFile() {
        this.setDefaults();
    }

    public AjfFile(String string) {
        this.readFile(string);
    }

    public void setDefaults() {
        this.title = "";
        this.basisSet = 1;
        this.electronicState = 0;
        this.nprint = 3;
        this.ghost = "";
        this.ligandCharge = "";
        this.directScf = 0;
        this.maxScfEnergy = 1.0E-8f;
        this.maxScfDensity = 1.0E-6f;
        this.maxScfCycle = 150;
        this.vshift = 0.0f;
        this.kshift = 0.0f;
        this.lshift = 0.0f;
        this.mo1 = 0;
        this.mo2 = 0;
        this.optimize = false;
        this.optimizeMethod = 0;
        this.hopt = 0;
        this.maxCycle = 50;
        this.maxGrad = 5.0E-4f;
        this.fmo = false;
        this.autoFrag = false;
        this.fragSizeResidueFrag = false;
        this.fragSizeNucleotideFrag = false;
        this.fragSizeResidue = 2;
        this.fragSizeNucleotide = 0;
        this.numberOfFragment = 0;
        this.charge = 0.0f;
        this.maxSccCycle = 250;
        this.maxSccEnergy = 5.0E-7f;
        this.approximationLevel = 3;
        this.laoc = 0.0f;
        this.lptc = 2.0f;
        this.ldimer = 2.0f;
        this.np = 1;
        this.nAtom = -1;
        this.readGeom = "";
        this.writeGeom = "";
    }

    public void readFile(String string) {
        File file = new File(string);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            Object object;
            String string2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedInputStream.read(byArray, 0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "= \n\r");
            this.setDefaults();
            while (!this.nextToken(stringTokenizer).equalsIgnoreCase("&OPTION")) {
                this.nextToken(stringTokenizer);
            }
            while (stringTokenizer.hasMoreTokens() && !(string2 = this.nextToken(stringTokenizer)).equals("/")) {
                String string3;
                if (string2.equalsIgnoreCase("Title")) {
                    this.title = this.nextToken(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("ReadGeom")) {
                    this.readGeom = string3 = this.nextToken(stringTokenizer);
                    System.out.println(string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("WriteGeom")) {
                    this.writeGeom = this.nextToken(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("BasisSet")) {
                    int n2;
                    string2 = this.nextToken(stringTokenizer);
                    for (n2 = 0; n2 < basisSetString.length && !string2.equalsIgnoreCase(basisSetString[n2]); ++n2) {
                    }
                    this.basisSet = n2;
                    continue;
                }
                if (string2.equalsIgnoreCase("ElecState")) {
                    int n3;
                    string2 = this.nextToken(stringTokenizer);
                    for (n3 = 0; n3 < electronicStateString.length && !string2.equalsIgnoreCase(electronicStateString[n3]); ++n3) {
                    }
                    this.electronicState = n3;
                    continue;
                }
                if (string2.equalsIgnoreCase("Nprint")) {
                    this.nprint = this.nextIntValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("Ghost")) {
                    this.ghost = this.nextToken(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("LigandCharge")) {
                    this.ligandCharge = this.nextToken(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxScfEnergy")) {
                    this.maxScfEnergy = this.nextFloatValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxScfDensity")) {
                    this.maxScfDensity = this.nextFloatValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxScfCyc")) {
                    this.maxScfCycle = Integer.parseInt(this.nextToken(stringTokenizer));
                    continue;
                }
                if (string2.equalsIgnoreCase("DirectSCF")) {
                    int n4;
                    string2 = this.nextToken(stringTokenizer);
                    for (n4 = 0; n4 < directScfString.length && !string2.equalsIgnoreCase(directScfString[n4]); ++n4) {
                    }
                    this.directScf = n4;
                    continue;
                }
                if (string2.equalsIgnoreCase("Vshift")) {
                    this.vshift = this.nextFloatValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("Kshift")) {
                    this.kshift = this.nextFloatValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("Lshift")) {
                    this.lshift = this.nextFloatValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("AlterMO")) {
                    string2 = this.nextToken(stringTokenizer);
                    string3 = string2.substring(0, string2.indexOf(44));
                    object = string2.substring(string2.indexOf(44) + 1);
                    try {
                        this.mo1 = Integer.parseInt(string3);
                        this.mo2 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        this.mo1 = 0;
                        this.mo2 = 0;
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxCyc")) {
                    this.maxCycle = Integer.parseInt(this.nextToken(stringTokenizer));
                    if (this.maxCycle <= 0) continue;
                    this.optimize = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxGrad")) {
                    this.maxGrad = this.nextFloatValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("Opt")) {
                    int n5;
                    string2 = this.nextToken(stringTokenizer);
                    for (n5 = 0; n5 < optimizeMethodString.length && !string2.equalsIgnoreCase(optimizeMethodString[n5]); ++n5) {
                    }
                    this.optimizeMethod = n5;
                    continue;
                }
                if (string2.equalsIgnoreCase("Hopt")) {
                    if (!this.nextToken(stringTokenizer).equalsIgnoreCase("ON")) continue;
                    this.hopt = 1;
                    continue;
                }
                if (string2.equalsIgnoreCase("FMO")) {
                    if (!this.nextToken(stringTokenizer).equalsIgnoreCase("ON")) continue;
                    this.fmo = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("AutoFrag")) {
                    if (!this.nextToken(stringTokenizer).equalsIgnoreCase("ON")) continue;
                    this.autoFrag = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("FragSizeResidue")) {
                    this.fragSizeResidue = Integer.parseInt(this.nextToken(stringTokenizer));
                    this.fragSizeResidueFrag = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("FragSizeNucleotide")) {
                    int n6;
                    string2 = this.nextToken(stringTokenizer);
                    for (n6 = 0; n6 < nucleotideString.length && !string2.equalsIgnoreCase(nucleotideString[n6]); ++n6) {
                    }
                    this.fragSizeNucleotide = n6;
                    this.fragSizeNucleotideFrag = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("Nf")) {
                    this.numberOfFragment = this.nextIntValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxSccCyc")) {
                    this.maxSccCycle = this.nextIntValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("MaxSccEnergy")) {
                    this.maxSccEnergy = Float.parseFloat(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equalsIgnoreCase("ApproxLevel")) {
                    this.approximationLevel = this.nextIntValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("Laoc")) {
                    this.laoc = Float.parseFloat(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equalsIgnoreCase("Lptc")) {
                    this.lptc = Float.parseFloat(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equalsIgnoreCase("Ldimer")) {
                    this.ldimer = Float.parseFloat(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equalsIgnoreCase("Np")) {
                    this.np = this.nextIntValue(stringTokenizer);
                    continue;
                }
                if (string2.equalsIgnoreCase("Natom")) {
                    this.nAtom = this.nextIntValue(stringTokenizer);
                    continue;
                }
                if (!string2.equalsIgnoreCase("Charge")) continue;
                this.charge = this.nextFloatValue(stringTokenizer);
            }
            if (this.numberOfFragment != 0 && this.readGeom != null) {
                int n7;
                this.numberOfAtomsComposingFragment = new int[this.numberOfFragment];
                this.formalCharge = new int[this.numberOfFragment];
                this.numberOfInterfragmentBonds = new int[this.numberOfFragment];
                this.atomicNumberComposingFragment = new Vector();
                this.atomicNumberOfFragmentBonds = new int[(this.numberOfFragment - 1) * 2];
                for (n7 = 0; n7 < this.numberOfFragment; ++n7) {
                    this.numberOfAtomsComposingFragment[n7] = this.nextIntValue(stringTokenizer);
                }
                for (n7 = 0; n7 < this.numberOfFragment; ++n7) {
                    this.formalCharge[n7] = this.nextIntValue(stringTokenizer);
                }
                for (n7 = 0; n7 < this.numberOfFragment; ++n7) {
                    this.numberOfInterfragmentBonds[n7] = this.nextIntValue(stringTokenizer);
                }
                for (n7 = 0; n7 < this.numberOfFragment; ++n7) {
                    object = new int[this.numberOfAtomsComposingFragment[n7]];
                    for (int i = 0; i < this.numberOfAtomsComposingFragment[n7]; ++i) {
                        object[i] = this.nextIntValue(stringTokenizer);
                    }
                    this.atomicNumberComposingFragment.add(object);
                }
                for (n7 = 0; n7 < this.numberOfFragment - 1; ++n7) {
                    this.atomicNumberOfFragmentBonds[n7 * 2] = this.nextIntValue(stringTokenizer);
                    this.atomicNumberOfFragmentBonds[n7 * 2 + 1] = this.nextIntValue(stringTokenizer);
                }
            }
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(new Frame(), "ajf File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    private String nextToken(StringTokenizer stringTokenizer) {
        return stringTokenizer.nextToken().replace('\'', ' ').trim();
    }

    private int nextIntValue(StringTokenizer stringTokenizer) {
        return Integer.parseInt(this.nextToken(stringTokenizer));
    }

    private float nextFloatValue(StringTokenizer stringTokenizer) {
        return Float.parseFloat(this.nextToken(stringTokenizer));
    }

    public void saveFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.debugPrint(printStream);
            printStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Save failed !! \n" + exception.getMessage());
            return;
        }
    }

    public void debugPrint(PrintStream printStream) {
        String string;
        Date date = new Date();
        printStream.print("&OPTION\n");
        if (this.title.length() > 0) {
            printStream.print("Title='" + this.title + "'\n");
        }
        if (this.readGeom.length() > 0) {
            string = this.readGeom.replace('\\', '/');
            printStream.print("ReadGeom='" + string + "'\n");
        }
        if (this.writeGeom.length() > 0) {
            string = this.writeGeom.replace('\\', '/');
            printStream.print("WriteGeom='" + string + "'\n");
        }
        printStream.print("BasisSet='" + basisSetString[this.basisSet] + "'\n");
        printStream.print("Method='" + methodString[this.method] + "'\n");
        printStream.print("ElecState='" + electronicStateString[this.electronicState] + "'\n");
        printStream.print("Nprint=" + this.nprint + "\n");
        if (!this.ghost.equals("")) {
            printStream.print("Ghost='" + this.ghost + "'\n");
        }
        printStream.print("LigandCharge='" + this.ligandCharge + "'\n");
        printStream.print("DirectSCF='" + directScfString[this.directScf] + "'\n");
        printStream.print("MaxScfEnergy=" + this.maxScfEnergy + "\n");
        printStream.print("MaxScfDensity=" + this.maxScfDensity + "\n");
        printStream.print("MaxScfCyc=" + this.maxScfCycle + "\n");
        printStream.print("VShift=" + this.vshift + " KShift=" + this.kshift + " LShift=" + this.lshift + "\n");
        printStream.print("AlterMO='" + this.mo1 + "," + this.mo2 + "'\n");
        if (this.optimize) {
            printStream.print("MaxCyc=" + this.maxCycle + " MaxGrad=" + this.maxGrad + "\n");
            printStream.print("Opt='" + optimizeMethodString[this.optimizeMethod] + "'\n");
            if (this.hopt == 0) {
                printStream.print("Hopt='OFF'\n");
            } else {
                printStream.print("Hopt='ON'\n");
            }
        } else {
            printStream.print("MaxCyc=-1\n");
        }
        if (this.fmo) {
            printStream.print("FMO='ON'\n");
            if (this.autoFrag) {
                printStream.print("AutoFrag='ON'\n");
                if (this.fragSizeResidueFrag) {
                    printStream.print("FragSizeResidue=" + this.fragSizeResidue + "\n");
                }
                if (this.fragSizeNucleotideFrag) {
                    printStream.print("FragSizeNucleotide='" + nucleotideString[this.fragSizeNucleotide] + "'\n");
                }
                printStream.print("Charge=" + this.charge + "\n");
            } else {
                printStream.print("AutoFrag='OFF'\n");
            }
            if (this.numberOfFragment != 0) {
                printStream.print("Nf=" + this.numberOfFragment + "\n");
            }
            printStream.print("MaxSccCyc=" + this.maxSccCycle + "\n");
            printStream.print("MaxSccEnergy=" + this.maxSccEnergy + "\n");
            printStream.print("ApproxLevel=" + this.approximationLevel + "\n");
            printStream.print("Laoc=" + this.laoc + " Lptc=" + this.lptc + " Ldimer=" + this.ldimer + "\n");
            printStream.print("Np=" + this.np + "\n");
            printStream.print("Natom=" + this.nAtom + "\n");
        }
        printStream.print("/\n");
        if (this.numberOfFragment != 0 && this.fmo) {
            int n;
            for (n = 0; n < this.numberOfFragment; ++n) {
                printStream.print("" + FillSpace.front(this.numberOfAtomsComposingFragment[n] + "", 5));
                if ((n + 1) % 16 != 0) continue;
                printStream.print("\n");
            }
            if (this.numberOfFragment % 16 != 0) {
                printStream.print("\n");
            }
            for (n = 0; n < this.numberOfFragment; ++n) {
                printStream.print("" + FillSpace.front(this.formalCharge[n] + "", 5));
                if ((n + 1) % 16 != 0) continue;
                printStream.print("\n");
            }
            if (this.numberOfFragment % 16 != 0) {
                printStream.print("\n");
            }
            for (n = 0; n < this.numberOfFragment; ++n) {
                printStream.print("" + FillSpace.front(this.numberOfInterfragmentBonds[n] + "", 5));
                if ((n + 1) % 16 != 0) continue;
                printStream.print("\n");
            }
            if (this.numberOfFragment % 16 != 0) {
                printStream.print("\n");
            }
            for (n = 0; n < this.atomicNumberComposingFragment.size(); ++n) {
                int[] nArray = (int[])this.atomicNumberComposingFragment.get(n);
                for (int i = 0; i < nArray.length; ++i) {
                    printStream.print("" + FillSpace.front(nArray[i] + "", 5));
                    if ((i + 1) % 16 != 0) continue;
                    printStream.print("\n");
                }
                if (nArray.length % 16 == 0) continue;
                printStream.print("\n");
            }
            for (n = 0; n < this.numberOfFragment - 1; ++n) {
                printStream.print("" + FillSpace.front(this.atomicNumberOfFragmentBonds[n * 2] + "", 5));
                printStream.print("" + FillSpace.front(this.atomicNumberOfFragmentBonds[n * 2 + 1] + "", 5));
                printStream.print("\n");
            }
        }
    }

    private float getFloat(StreamTokenizer streamTokenizer) throws Exception {
        float f = (float)streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -3) {
            String string = streamTokenizer.sval.substring(0, 2);
            if (string.equalsIgnoreCase("E-")) {
                f = Float.parseFloat(Float.toString(f) + streamTokenizer.sval);
            } else {
                streamTokenizer.pushBack();
            }
        } else {
            streamTokenizer.pushBack();
        }
        return f;
    }

    public static void main(String[] stringArray) {
        AjfFile ajfFile = new AjfFile(stringArray[0]);
    }
}

