/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumBuilder;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnParameterScan;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserParameterState;

class ScanBuilder
implements MinimumBuilder {
    ScanBuilder() {
    }

    public FunctionMinimum minimum(MnFcn mfcn, GradientCalculator gc, MinimumSeed seed, MnStrategy stra, int maxfcn, double toler) {
        MnAlgebraicVector x = (MnAlgebraicVector)seed.parameters().vec().clone();
        MnUserParameterState upst = new MnUserParameterState(seed.state(), mfcn.errorDef(), seed.trafo());
        MnParameterScan scan = new MnParameterScan(mfcn.fcn(), upst.parameters(), seed.fval());
        double amin = scan.fval();
        int n = seed.trafo().variableParameters();
        MnAlgebraicVector dirin = new MnAlgebraicVector(n);
        for (int i = 0; i < n; ++i) {
            int ext = seed.trafo().extOfInt(i);
            scan.scan(ext);
            if (scan.fval() < amin) {
                amin = scan.fval();
                x.set(i, seed.trafo().ext2int(ext, scan.parameters().value(ext)));
            }
            dirin.set(i, Math.sqrt(2.0 * mfcn.errorDef() * seed.error().invHessian().get(i, i)));
        }
        MinimumParameters mp = new MinimumParameters(x, dirin, amin);
        MinimumState st = new MinimumState(mp, 0.0, mfcn.numOfCalls());
        ArrayList<MinimumState> states = new ArrayList<MinimumState>(1);
        states.add(st);
        return new FunctionMinimum(seed, states, mfcn.errorDef());
    }
}

