/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import java.util.List;
import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnPrint;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.MnUserParameters;

public class FunctionMinimum {
    private MinimumSeed theSeed;
    private List theStates;
    private double theErrorDef;
    private boolean theAboveMaxEdm;
    private boolean theReachedCallLimit;
    private MnUserParameterState theUserState;

    FunctionMinimum(MinimumSeed seed, double up) {
        this.theSeed = seed;
        this.theStates = new ArrayList();
        this.theStates.add(new MinimumState(seed.parameters(), seed.error(), seed.gradient(), seed.parameters().fval(), seed.nfcn()));
        this.theErrorDef = up;
        this.theUserState = new MnUserParameterState();
    }

    FunctionMinimum(MinimumSeed seed, List states, double up) {
        this.theSeed = seed;
        this.theStates = states;
        this.theErrorDef = up;
        this.theUserState = new MnUserParameterState();
    }

    FunctionMinimum(MinimumSeed seed, List states, double up, MnReachedCallLimit x) {
        this.theSeed = seed;
        this.theStates = states;
        this.theErrorDef = up;
        this.theReachedCallLimit = true;
        this.theUserState = new MnUserParameterState();
    }

    FunctionMinimum(MinimumSeed seed, List states, double up, MnAboveMaxEdm x) {
        this.theSeed = seed;
        this.theStates = states;
        this.theErrorDef = up;
        this.theAboveMaxEdm = true;
        this.theReachedCallLimit = false;
        this.theUserState = new MnUserParameterState();
    }

    void add(MinimumState state) {
        this.theStates.add(state);
    }

    MinimumSeed seed() {
        return this.theSeed;
    }

    List states() {
        return this.theStates;
    }

    public MnUserParameterState userState() {
        if (!this.theUserState.isValid()) {
            this.theUserState = new MnUserParameterState(this.state(), this.errorDef(), this.seed().trafo());
        }
        return this.theUserState;
    }

    public MnUserParameters userParameters() {
        if (!this.theUserState.isValid()) {
            this.theUserState = new MnUserParameterState(this.state(), this.errorDef(), this.seed().trafo());
        }
        return this.theUserState.parameters();
    }

    public MnUserCovariance userCovariance() {
        if (!this.theUserState.isValid()) {
            this.theUserState = new MnUserParameterState(this.state(), this.errorDef(), this.seed().trafo());
        }
        return this.theUserState.covariance();
    }

    private MinimumState lastState() {
        return (MinimumState)this.theStates.get(this.theStates.size() - 1);
    }

    MinimumState state() {
        return this.lastState();
    }

    MinimumParameters parameters() {
        return this.lastState().parameters();
    }

    MinimumError error() {
        return this.lastState().error();
    }

    FunctionGradient grad() {
        return this.lastState().gradient();
    }

    public double fval() {
        return this.lastState().fval();
    }

    public double edm() {
        return this.lastState().edm();
    }

    public int nfcn() {
        return this.lastState().nfcn();
    }

    public double errorDef() {
        return this.theErrorDef;
    }

    public boolean isValid() {
        return this.state().isValid() && !this.isAboveMaxEdm() && !this.hasReachedCallLimit();
    }

    boolean hasValidParameters() {
        return this.state().parameters().isValid();
    }

    boolean hasValidCovariance() {
        return this.state().error().isValid();
    }

    boolean hasAccurateCovar() {
        return this.state().error().isAccurate();
    }

    boolean hasPosDefCovar() {
        return this.state().error().isPosDef();
    }

    boolean hasMadePosDefCovar() {
        return this.state().error().isMadePosDef();
    }

    boolean hesseFailed() {
        return this.state().error().hesseFailed();
    }

    boolean hasCovariance() {
        return this.state().error().isAvailable();
    }

    boolean isAboveMaxEdm() {
        return this.theAboveMaxEdm;
    }

    boolean hasReachedCallLimit() {
        return this.theReachedCallLimit;
    }

    public String toString() {
        return MnPrint.toString(this);
    }

    static class MnAboveMaxEdm {
        MnAboveMaxEdm() {
        }
    }

    static class MnReachedCallLimit {
        MnReachedCallLimit() {
        }
    }
}

