/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;

public class ShapeUtils {
    public static Shape rotateShape(Shape base, double angle, float x, float y) {
        if (base == null) {
            return null;
        }
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, x, y);
        Shape result = rotate.createTransformedShape(base);
        return result;
    }

    public static Shape clone(Shape shape) {
        Shape result = null;
        if (shape instanceof Line2D) {
            Line2D line = (Line2D)shape;
            result = (Shape)line.clone();
        } else if (shape instanceof RectangularShape) {
            RectangularShape rectangle = (RectangularShape)shape;
            result = (Shape)rectangle.clone();
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            result = (Shape)area.clone();
        } else if (shape instanceof GeneralPath) {
            GeneralPath path = (GeneralPath)shape;
            result = (Shape)path.clone();
        }
        return result;
    }

    public boolean equal(Polygon p1, Polygon p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1.npoints != p2.npoints) {
            return false;
        }
        if (!Arrays.equals(p1.xpoints, p2.xpoints)) {
            return false;
        }
        return Arrays.equals(p1.ypoints, p2.ypoints);
    }

    public static Shape translateShape(Shape shape, double transX, double transY) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(transX, transY);
        return transform.createTransformedShape(shape);
    }
}

