/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static byte[] defaultMessage = new byte[]{-1, 0};
    private int dataLength = 0;

    public MetaMessage() {
        this(defaultMessage);
    }

    protected MetaMessage(byte[] data) {
        super(data);
    }

    public void setMessage(int type, byte[] data, int length) throws InvalidMidiDataException {
        if (type >= 128) {
            throw new InvalidMidiDataException("Invalid meta event with type " + type);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(255);
            dos.writeByte(type);
            this.writeVarInt(length, dos);
            dos.write(data, 0, length);
            this.data = bos.toByteArray();
            this.length = this.data.length;
            this.dataLength = length;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public int getType() {
        int type = 0;
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream das = new DataInputStream(bas);
            das.skip(1L);
            type = das.readUnsignedByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return type;
    }

    public byte[] getData() {
        byte[] returnedArray = new byte[this.dataLength];
        System.arraycopy(this.data, this.length - this.dataLength, returnedArray, 0, this.dataLength);
        return returnedArray;
    }

    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        MetaMessage event = new MetaMessage(newData);
        return event;
    }

    private void writeVarInt(int value, DataOutputStream dos) throws InvalidMidiDataException, IOException {
        int MAX_LENGTH = 6;
        byte[] bytes = new byte[MAX_LENGTH];
        int length = 0;
        boolean currentByte = false;
        int i = 0;
        while (i < MAX_LENGTH) {
            bytes[i] = 0;
            ++i;
        }
        int i2 = MAX_LENGTH - 1;
        while (i2 >= 0) {
            bytes[i2] = (byte)(value & 0x7F);
            value >>>= 7;
            if (++length > 1) {
                int n = i2;
                bytes[n] = (byte)(bytes[n] | 0x80);
            }
            if (value == 0) break;
            --i2;
        }
        if ((bytes[MAX_LENGTH - 1] & 0x80) != 0) {
            throw new InvalidMidiDataException("Unable to create variable-length integer");
        }
        dos.write(bytes, MAX_LENGTH - length, length);
    }
}

