/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.OvrHmdContext;
import com.jogamp.oculusvr.ovrFovPort;
import com.jogamp.oculusvr.ovrSizei;
import com.jogamp.oculusvr.ovrVector2i;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrHmdDesc {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrHmdDesc_size = new int[]{172, 172, 172, 172, 172, 172, 200, 200};
    private static final int[] Handle_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] Type_offset = new int[]{4, 4, 4, 4, 4, 4, 8, 8};
    private static final int[] ProductName_offset = new int[]{8, 8, 8, 8, 8, 8, 16, 16};
    private static final int[] Manufacturer_offset = new int[]{12, 12, 12, 12, 12, 12, 24, 24};
    private static final int[] VendorId_offset = new int[]{16, 16, 16, 16, 16, 16, 32, 32};
    private static final int[] ProductId_offset = new int[]{18, 18, 18, 18, 18, 18, 34, 34};
    private static final int[] SerialNumber_offset = new int[]{20, 20, 20, 20, 20, 20, 36, 36};
    private static final int[] SerialNumber_size = new int[]{24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] FirmwareMajor_offset = new int[]{44, 44, 44, 44, 44, 44, 60, 60};
    private static final int[] FirmwareMinor_offset = new int[]{46, 46, 46, 46, 46, 46, 62, 62};
    private static final int[] CameraFrustumHFovInRadians_offset = new int[]{48, 48, 48, 48, 48, 48, 64, 64};
    private static final int[] CameraFrustumVFovInRadians_offset = new int[]{52, 52, 52, 52, 52, 52, 68, 68};
    private static final int[] CameraFrustumNearZInMeters_offset = new int[]{56, 56, 56, 56, 56, 56, 72, 72};
    private static final int[] CameraFrustumFarZInMeters_offset = new int[]{60, 60, 60, 60, 60, 60, 76, 76};
    private static final int[] HmdCaps_offset = new int[]{64, 64, 64, 64, 64, 64, 80, 80};
    private static final int[] TrackingCaps_offset = new int[]{68, 68, 68, 68, 68, 68, 84, 84};
    private static final int[] DistortionCaps_offset = new int[]{72, 72, 72, 72, 72, 72, 88, 88};
    private static final int[] DefaultEyeFov_offset = new int[]{76, 76, 76, 76, 76, 76, 92, 92};
    private static final int[] DefaultEyeFov_size = new int[]{32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] MaxEyeFov_offset = new int[]{108, 108, 108, 108, 108, 108, 124, 124};
    private static final int[] MaxEyeFov_size = new int[]{32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] EyeRenderOrder_offset = new int[]{140, 140, 140, 140, 140, 140, 156, 156};
    private static final int[] EyeRenderOrder_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] Resolution_offset = new int[]{148, 148, 148, 148, 148, 148, 164, 164};
    private static final int[] Resolution_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] WindowsPos_offset = new int[]{156, 156, 156, 156, 156, 156, 172, 172};
    private static final int[] WindowsPos_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] DisplayDeviceName_offset = new int[]{164, 164, 164, 164, 164, 164, 184, 184};
    private static final int[] DisplayId_offset = new int[]{168, 168, 168, 168, 168, 168, 192, 192};

    public static int size() {
        return ovrHmdDesc_size[mdIdx];
    }

    public static ovrHmdDesc create() {
        return ovrHmdDesc.create(Buffers.newDirectByteBuffer(ovrHmdDesc.size()));
    }

    public static ovrHmdDesc create(ByteBuffer byteBuffer) {
        return new ovrHmdDesc(byteBuffer);
    }

    ovrHmdDesc(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrHmdDesc.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    private native ByteBuffer getHandle0(ByteBuffer var1, int var2);

    public OvrHmdContext getHandle() {
        ByteBuffer byteBuffer = this.getBuffer();
        ByteBuffer byteBuffer2 = this.getHandle0(byteBuffer, 0);
        if (byteBuffer2 == null) {
            return null;
        }
        return OvrHmdContext.create(byteBuffer2);
    }

    public ovrHmdDesc setType(int n) {
        this.accessor.setIntAt(Type_offset[mdIdx], n);
        return this;
    }

    public int getType() {
        return this.accessor.getIntAt(Type_offset[mdIdx]);
    }

    private native ByteBuffer getProductName0(ByteBuffer var1, int var2);

    public ByteBuffer getProductName() {
        int n = this.getProductNameArrayLength();
        ByteBuffer byteBuffer = this.getProductName0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer);
    }

    public String getProductNameAsString() {
        int n = this.getProductNameArrayLength();
        ByteBuffer byteBuffer = this.getProductName0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = -1;
        while (++n2 < n) {
            byArray[n2] = byteBuffer.get(n2);
            if (0 != byArray[n2]) continue;
        }
        return new String(byArray, 0, n2);
    }

    public final int getProductNameArrayLength() {
        long l = PointerBuffer.wrap(this.accessor.slice(ProductName_offset[mdIdx], PointerBuffer.ELEMENT_SIZE)).get(0);
        return ovrHmdDesc.getCStringLengthImpl(l) + 1;
    }

    private native ByteBuffer getManufacturer0(ByteBuffer var1, int var2);

    public ByteBuffer getManufacturer() {
        int n = this.getManufacturerArrayLength();
        ByteBuffer byteBuffer = this.getManufacturer0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer);
    }

    public String getManufacturerAsString() {
        int n = this.getManufacturerArrayLength();
        ByteBuffer byteBuffer = this.getManufacturer0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = -1;
        while (++n2 < n) {
            byArray[n2] = byteBuffer.get(n2);
            if (0 != byArray[n2]) continue;
        }
        return new String(byArray, 0, n2);
    }

    public final int getManufacturerArrayLength() {
        long l = PointerBuffer.wrap(this.accessor.slice(Manufacturer_offset[mdIdx], PointerBuffer.ELEMENT_SIZE)).get(0);
        return ovrHmdDesc.getCStringLengthImpl(l) + 1;
    }

    public ovrHmdDesc setVendorId(short s) {
        this.accessor.setShortAt(VendorId_offset[mdIdx], s);
        return this;
    }

    public short getVendorId() {
        return this.accessor.getShortAt(VendorId_offset[mdIdx]);
    }

    public ovrHmdDesc setProductId(short s) {
        this.accessor.setShortAt(ProductId_offset[mdIdx], s);
        return this;
    }

    public short getProductId() {
        return this.accessor.getShortAt(ProductId_offset[mdIdx]);
    }

    public static final int getSerialNumberArrayLength() {
        return 24;
    }

    public ovrHmdDesc setSerialNumber(int n, byte[] byArray) {
        if (n + byArray.length > 24) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + byArray.length + " > array-length " + 24);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (24 > SerialNumber_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 24 > size " + SerialNumber_size[mdIdx] + ", elemSize " + 1 + " * " + 24);
        }
        int n2 = SerialNumber_offset[mdIdx];
        int n3 = n2 + 24;
        if (n3 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n3 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n2 + ", elemSize " + 1 + " * " + 24);
        }
        this.accessor.setBytesAt(n2 += 1 * n, byArray);
        return this;
    }

    public ByteBuffer getSerialNumber() {
        return this.accessor.slice(SerialNumber_offset[mdIdx], 24);
    }

    public String getSerialNumberAsString() {
        int n = SerialNumber_offset[mdIdx];
        ByteBuffer byteBuffer = this.getBuffer();
        byte[] byArray = new byte[24];
        int n2 = -1;
        while (++n2 < 24) {
            byArray[n2] = byteBuffer.get(n + n2);
            if (0 != byArray[n2]) continue;
        }
        return new String(byArray, 0, n2);
    }

    public ovrHmdDesc setFirmwareMajor(short s) {
        this.accessor.setShortAt(FirmwareMajor_offset[mdIdx], s);
        return this;
    }

    public short getFirmwareMajor() {
        return this.accessor.getShortAt(FirmwareMajor_offset[mdIdx]);
    }

    public ovrHmdDesc setFirmwareMinor(short s) {
        this.accessor.setShortAt(FirmwareMinor_offset[mdIdx], s);
        return this;
    }

    public short getFirmwareMinor() {
        return this.accessor.getShortAt(FirmwareMinor_offset[mdIdx]);
    }

    public ovrHmdDesc setCameraFrustumHFovInRadians(float f) {
        this.accessor.setFloatAt(CameraFrustumHFovInRadians_offset[mdIdx], f);
        return this;
    }

    public float getCameraFrustumHFovInRadians() {
        return this.accessor.getFloatAt(CameraFrustumHFovInRadians_offset[mdIdx]);
    }

    public ovrHmdDesc setCameraFrustumVFovInRadians(float f) {
        this.accessor.setFloatAt(CameraFrustumVFovInRadians_offset[mdIdx], f);
        return this;
    }

    public float getCameraFrustumVFovInRadians() {
        return this.accessor.getFloatAt(CameraFrustumVFovInRadians_offset[mdIdx]);
    }

    public ovrHmdDesc setCameraFrustumNearZInMeters(float f) {
        this.accessor.setFloatAt(CameraFrustumNearZInMeters_offset[mdIdx], f);
        return this;
    }

    public float getCameraFrustumNearZInMeters() {
        return this.accessor.getFloatAt(CameraFrustumNearZInMeters_offset[mdIdx]);
    }

    public ovrHmdDesc setCameraFrustumFarZInMeters(float f) {
        this.accessor.setFloatAt(CameraFrustumFarZInMeters_offset[mdIdx], f);
        return this;
    }

    public float getCameraFrustumFarZInMeters() {
        return this.accessor.getFloatAt(CameraFrustumFarZInMeters_offset[mdIdx]);
    }

    public ovrHmdDesc setHmdCaps(int n) {
        this.accessor.setIntAt(HmdCaps_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getHmdCaps() {
        return this.accessor.getIntAt(HmdCaps_offset[mdIdx], this.md.intSizeInBytes());
    }

    public ovrHmdDesc setTrackingCaps(int n) {
        this.accessor.setIntAt(TrackingCaps_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getTrackingCaps() {
        return this.accessor.getIntAt(TrackingCaps_offset[mdIdx], this.md.intSizeInBytes());
    }

    public ovrHmdDesc setDistortionCaps(int n) {
        this.accessor.setIntAt(DistortionCaps_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getDistortionCaps() {
        return this.accessor.getIntAt(DistortionCaps_offset[mdIdx], this.md.intSizeInBytes());
    }

    public static final int getDefaultEyeFovArrayLength() {
        return 2;
    }

    public ovrHmdDesc setDefaultEyeFov(int n, ovrFovPort[] ovrFovPortArray) {
        if (n + ovrFovPortArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + ovrFovPortArray.length + " > array-length " + 2);
        }
        int n2 = ovrFovPort.size();
        ByteBuffer byteBuffer = this.getBuffer();
        int n3 = 2 * n2;
        if (n3 > DefaultEyeFov_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal " + n3 + " > size " + DefaultEyeFov_size[mdIdx] + ", elemSize " + n2 + " * " + 2);
        }
        int n4 = DefaultEyeFov_offset[mdIdx];
        int n5 = n4 + n3;
        if (n5 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n5 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n4 + ", elemSize " + n2 + " * " + 2);
        }
        n4 += n2 * n;
        for (int i = 0; i < ovrFovPortArray.length; ++i) {
            ByteBuffer byteBuffer2 = ovrFovPortArray[i].getBuffer();
            for (int j = 0; j < n2; ++j) {
                if (n4 >= n5) {
                    throw new IndexOutOfBoundsException("elem-byte[" + (n + i) + "][" + j + "]: bOffset " + n4 + " >= bLimes " + n5 + ", elemSize " + n2 + " * " + 2);
                }
                byteBuffer.put(n4++, byteBuffer2.get(j));
            }
        }
        return this;
    }

    public ovrHmdDesc setDefaultEyeFov(int n, ovrFovPort ovrFovPort2) {
        int n2 = ovrFovPort.size();
        ByteBuffer byteBuffer = this.getBuffer();
        int n3 = 2 * n2;
        if (n3 > DefaultEyeFov_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal " + n3 + " > size " + DefaultEyeFov_size[mdIdx] + ", elemSize " + n2 + " * " + 2);
        }
        int n4 = DefaultEyeFov_offset[mdIdx];
        int n5 = n4 + n3;
        if (n5 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n5 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n4 + ", elemSize " + n2 + " * " + 2);
        }
        n4 += n2 * n;
        ByteBuffer byteBuffer2 = ovrFovPort2.getBuffer();
        for (int i = 0; i < n2; ++i) {
            if (n4 >= n5) {
                throw new IndexOutOfBoundsException("elem-byte[" + n + "][" + i + "]: bOffset " + n4 + " >= bLimes " + n5 + ", elemSize " + n2 + " * " + 2);
            }
            byteBuffer.put(n4++, byteBuffer2.get(i));
        }
        return this;
    }

    public ovrFovPort[] getDefaultEyeFov(int n, ovrFovPort[] ovrFovPortArray) {
        if (n + ovrFovPortArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + ovrFovPortArray.length + " > array-length " + 2);
        }
        int n2 = ovrFovPort.size();
        int n3 = DefaultEyeFov_offset[mdIdx] + n2 * n;
        for (int i = 0; i < ovrFovPortArray.length; ++i) {
            ovrFovPortArray[i] = ovrFovPort.create(this.accessor.slice(n3, n2));
            n3 += n2;
        }
        return ovrFovPortArray;
    }

    public static final int getMaxEyeFovArrayLength() {
        return 2;
    }

    public ovrHmdDesc setMaxEyeFov(int n, ovrFovPort[] ovrFovPortArray) {
        if (n + ovrFovPortArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + ovrFovPortArray.length + " > array-length " + 2);
        }
        int n2 = ovrFovPort.size();
        ByteBuffer byteBuffer = this.getBuffer();
        int n3 = 2 * n2;
        if (n3 > MaxEyeFov_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal " + n3 + " > size " + MaxEyeFov_size[mdIdx] + ", elemSize " + n2 + " * " + 2);
        }
        int n4 = MaxEyeFov_offset[mdIdx];
        int n5 = n4 + n3;
        if (n5 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n5 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n4 + ", elemSize " + n2 + " * " + 2);
        }
        n4 += n2 * n;
        for (int i = 0; i < ovrFovPortArray.length; ++i) {
            ByteBuffer byteBuffer2 = ovrFovPortArray[i].getBuffer();
            for (int j = 0; j < n2; ++j) {
                if (n4 >= n5) {
                    throw new IndexOutOfBoundsException("elem-byte[" + (n + i) + "][" + j + "]: bOffset " + n4 + " >= bLimes " + n5 + ", elemSize " + n2 + " * " + 2);
                }
                byteBuffer.put(n4++, byteBuffer2.get(j));
            }
        }
        return this;
    }

    public ovrHmdDesc setMaxEyeFov(int n, ovrFovPort ovrFovPort2) {
        int n2 = ovrFovPort.size();
        ByteBuffer byteBuffer = this.getBuffer();
        int n3 = 2 * n2;
        if (n3 > MaxEyeFov_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal " + n3 + " > size " + MaxEyeFov_size[mdIdx] + ", elemSize " + n2 + " * " + 2);
        }
        int n4 = MaxEyeFov_offset[mdIdx];
        int n5 = n4 + n3;
        if (n5 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n5 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n4 + ", elemSize " + n2 + " * " + 2);
        }
        n4 += n2 * n;
        ByteBuffer byteBuffer2 = ovrFovPort2.getBuffer();
        for (int i = 0; i < n2; ++i) {
            if (n4 >= n5) {
                throw new IndexOutOfBoundsException("elem-byte[" + n + "][" + i + "]: bOffset " + n4 + " >= bLimes " + n5 + ", elemSize " + n2 + " * " + 2);
            }
            byteBuffer.put(n4++, byteBuffer2.get(i));
        }
        return this;
    }

    public ovrFovPort[] getMaxEyeFov(int n, ovrFovPort[] ovrFovPortArray) {
        if (n + ovrFovPortArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + ovrFovPortArray.length + " > array-length " + 2);
        }
        int n2 = ovrFovPort.size();
        int n3 = MaxEyeFov_offset[mdIdx] + n2 * n;
        for (int i = 0; i < ovrFovPortArray.length; ++i) {
            ovrFovPortArray[i] = ovrFovPort.create(this.accessor.slice(n3, n2));
            n3 += n2;
        }
        return ovrFovPortArray;
    }

    public static final int getEyeRenderOrderArrayLength() {
        return 2;
    }

    public ovrHmdDesc setEyeRenderOrder(int n, int[] nArray) {
        if (n + nArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + nArray.length + " > array-length " + 2);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (8 > EyeRenderOrder_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 8 > size " + EyeRenderOrder_size[mdIdx] + ", elemSize " + 4 + " * " + 2);
        }
        int n2 = EyeRenderOrder_offset[mdIdx];
        int n3 = n2 + 8;
        if (n3 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n3 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n2 + ", elemSize " + 4 + " * " + 2);
        }
        this.accessor.setIntsAt(n2 += 4 * n, nArray);
        return this;
    }

    public IntBuffer getEyeRenderOrder() {
        return this.accessor.slice(EyeRenderOrder_offset[mdIdx], 8).asIntBuffer();
    }

    public int[] getEyeRenderOrder(int n, int[] nArray) {
        if (n + nArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + nArray.length + " > array-length " + 2);
        }
        return this.accessor.getIntsAt(EyeRenderOrder_offset[mdIdx] + 4 * n, nArray);
    }

    public ovrSizei getResolution() {
        return ovrSizei.create(this.accessor.slice(Resolution_offset[mdIdx], Resolution_size[mdIdx]));
    }

    public ovrVector2i getWindowsPos() {
        return ovrVector2i.create(this.accessor.slice(WindowsPos_offset[mdIdx], WindowsPos_size[mdIdx]));
    }

    private native ByteBuffer getDisplayDeviceName0(ByteBuffer var1, int var2);

    public ByteBuffer getDisplayDeviceName() {
        int n = this.getDisplayDeviceNameArrayLength();
        ByteBuffer byteBuffer = this.getDisplayDeviceName0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer);
    }

    public String getDisplayDeviceNameAsString() {
        int n = this.getDisplayDeviceNameArrayLength();
        ByteBuffer byteBuffer = this.getDisplayDeviceName0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = -1;
        while (++n2 < n) {
            byArray[n2] = byteBuffer.get(n2);
            if (0 != byArray[n2]) continue;
        }
        return new String(byArray, 0, n2);
    }

    public final int getDisplayDeviceNameArrayLength() {
        long l = PointerBuffer.wrap(this.accessor.slice(DisplayDeviceName_offset[mdIdx], PointerBuffer.ELEMENT_SIZE)).get(0);
        return ovrHmdDesc.getCStringLengthImpl(l) + 1;
    }

    public ovrHmdDesc setDisplayId(int n) {
        this.accessor.setIntAt(DisplayId_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getDisplayId() {
        return this.accessor.getIntAt(DisplayId_offset[mdIdx], this.md.intSizeInBytes());
    }

    private static native boolean initializeImpl();

    private static native int getCStringLengthImpl(long var0);

    static {
        if (!ovrHmdDesc.initializeImpl()) {
            throw new RuntimeException("Initialization failure");
        }
    }
}

