/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.threadpool;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.orbutil.threadpool.WorkQueue;
import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolImpl
implements ThreadPool {
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.transport");
    private WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private int minWorkerThreads = 0;
    private int maxWorkerThreads = 0;
    private long inactivityTimeout;
    private boolean boundedThreadPool = false;
    private AtomicLong processedCount = new AtomicLong(1L);
    private AtomicLong totalTimeTaken = new AtomicLong(0L);
    private String name;
    private MonitoredObject threadpoolMonitoredObject;
    private ThreadGroup threadGroup;
    Object workersLock = new Object();
    List<WorkerThread> workers = new ArrayList<WorkerThread>();

    public ThreadPoolImpl(ThreadGroup threadGroup, String string) {
        this.inactivityTimeout = 120000L;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = threadGroup;
        this.name = string;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadPoolImpl(int n, int n2, long l, String string) {
        this.minWorkerThreads = n;
        this.maxWorkerThreads = n2;
        this.inactivityTimeout = l;
        this.boundedThreadPool = true;
        this.workQueue = new WorkQueueImpl(this);
        this.name = string;
        for (int i = 0; i < this.minWorkerThreads; ++i) {
            this.createWorkerThread();
        }
        this.initializeMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ArrayList<WorkerThread> arrayList = null;
        Iterator iterator = this.workersLock;
        synchronized (iterator) {
            arrayList = new ArrayList<WorkerThread>(this.workers);
        }
        for (WorkerThread workerThread : arrayList) {
            workerThread.close();
            while (workerThread.getState() != Thread.State.TERMINATED) {
                try {
                    workerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    wrapper.interruptedJoinCallWhileClosingThreadPool(interruptedException, (Object)workerThread, (Object)this);
                }
            }
        }
        this.threadGroup = null;
    }

    private void initializeMonitoring() {
        MonitoredObject monitoredObject = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject monitoredObject2 = monitoredObject.getChild("threadpool");
        if (monitoredObject2 == null) {
            monitoredObject2 = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            monitoredObject.addChild(monitoredObject2);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        monitoredObject2.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase longMonitoredAttributeBase = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentNumberOfThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase);
        LongMonitoredAttributeBase longMonitoredAttributeBase2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfAvailableThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase2);
        LongMonitoredAttributeBase longMonitoredAttributeBase3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfBusyThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase3);
        LongMonitoredAttributeBase longMonitoredAttributeBase4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.averageWorkCompletionTime());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase4);
        LongMonitoredAttributeBase longMonitoredAttributeBase5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentProcessedCount());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(longMonitoredAttributeBase5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    public WorkQueue getWorkQueue(int n) throws NoSuchWorkQueueException {
        if (n != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyForAvailableWork(WorkQueue workQueue) {
        WorkQueue workQueue2 = workQueue;
        synchronized (workQueue2) {
            if (this.availableWorkerThreads < workQueue.workItemsInQueue()) {
                this.createWorkerThread();
            } else {
                workQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread createWorkerThreadHelper(String string) {
        WorkerThread workerThread = new WorkerThread(this.threadGroup, string);
        Object object = this.workersLock;
        synchronized (object) {
            this.workers.add(workerThread);
        }
        workerThread.setDaemon(true);
        wrapper.workerThreadCreated(workerThread, workerThread.getContextClassLoader());
        workerThread.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWorkerThread() {
        final String string = this.getName();
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            try {
                if (System.getSecurityManager() == null) {
                    this.createWorkerThreadHelper(string);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ThreadPoolImpl.this.createWorkerThreadHelper(string);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                this.decrementCurrentNumberOfThreads();
                wrapper.workerThreadCreationFailure(throwable);
            }
            finally {
                this.incrementCurrentNumberOfThreads();
            }
        }
    }

    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int currentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfBusyThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentThreadCount - this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long averageWorkCompletionTime() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.totalTimeTaken.get() / this.processedCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long currentProcessedCount() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.processedCount.get();
        }
    }

    public String getName() {
        return this.name;
    }

    public int numberOfWorkQueues() {
        return 1;
    }

    private static synchronized int getUniqueThreadId() {
        return threadCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.availableWorkerThreads;
        }
    }

    private class WorkerThread
    extends Thread
    implements Closeable {
        private Work currentWork;
        private int threadId;
        private volatile boolean closeCalled;
        private String threadPoolName;
        private StringBuffer workerThreadName;

        WorkerThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, "Idle");
            this.threadId = 0;
            this.closeCalled = false;
            this.workerThreadName = new StringBuffer();
            this.threadId = ThreadPoolImpl.getUniqueThreadId();
            this.threadPoolName = string;
            this.setName(this.composeWorkerThreadName(string, "Idle"));
        }

        public synchronized void close() {
            this.closeCalled = true;
            this.interrupt();
        }

        private void resetClassLoader() {
        }

        private void performWork() {
            long l = System.currentTimeMillis();
            try {
                this.currentWork.doWork();
            }
            catch (Throwable throwable) {
                wrapper.workerThreadDoWorkThrowable(this, throwable);
            }
            long l2 = System.currentTimeMillis() - l;
            ThreadPoolImpl.this.totalTimeTaken.addAndGet(l2);
            ThreadPoolImpl.this.processedCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.closeCalled) {
                    block19: {
                        try {
                            this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                            if (this.currentWork == null) {
                            }
                            break block19;
                        }
                        catch (InterruptedException interruptedException) {
                            wrapper.workQueueThreadInterrupted(interruptedException, (Object)this.getName(), (Object)this.closeCalled);
                        }
                        catch (Throwable throwable) {
                            wrapper.workerThreadThrowableFromRequestWork(this, throwable, ThreadPoolImpl.this.workQueue.getName());
                        }
                        continue;
                    }
                    this.performWork();
                    this.currentWork = null;
                    this.resetClassLoader();
                }
            }
            catch (Throwable throwable) {
                wrapper.workerThreadCaughtUnexpectedThrowable(this, throwable);
            }
            finally {
                Object object = ThreadPoolImpl.this.workersLock;
                synchronized (object) {
                    ThreadPoolImpl.this.workers.remove(this);
                }
            }
        }

        private String composeWorkerThreadName(String string, String string2) {
            this.workerThreadName.setLength(0);
            this.workerThreadName.append("p: ").append(string);
            this.workerThreadName.append("; w: ").append(string2);
            return this.workerThreadName.toString();
        }
    }
}

