/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/11, 13:25
!  AUTHOR(S): KOGA, Junichiro
!  File : BottomAction.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.view;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;

/**
 * x܂-90x]
 * 
 * @author
 */
public class BottomAction extends ACVAction {
    private Logger logger = Logger.getLogger(TopAction.class.getName());
    private TransformGroup[] transformGroups;
    private Transform3D rot;

    /** Creates a new instance of TopAction */
    public BottomAction(BaseJ3DPanel panel) {
        super(panel);
        transformGroups = panel.getRotatingTransform();
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        transformGroups = parent.getRotatingTransform();
        if (transformGroups != null) {
            for (int i = 0; i < transformGroups.length; i++) {
                Transform3D currTrans = new Transform3D();
                TransformGroup transformGroup = transformGroups[i];
                transformGroup.getTransform(currTrans);
                Matrix4d mat = new Matrix4d();
                // Remember old matrix
                currTrans.get(mat);

                // Translate to origin
                currTrans.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                currTrans.rotX(-Math.PI / 2);

                // Set old translation back
                Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                currTrans.setTranslation(translation);
                transformGroup.setTransform(currTrans);
            }
        }
    }

}
