/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/10, 18:12
!  AUTHOR(S): KOGA, Junichiro
!  File : UnitCellOperationsPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.prefs;

import javax.swing.JPanel;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * 
 * @author KOGA, Junichiro
 */
// public class UnitCellOperationsPanel extends javax.swing.JInternalFrame {
public class UnitCellOperationsPanel extends JPanel {
    private String defaultEps = "0.00001";
    private CoordsViewerInterface parent;

    /** Creates new form UnitCellOperationsPanel */
    public UnitCellOperationsPanel(CoordsViewerInterface parent) {
        this.parent = parent;
        initComponents();
        setInitialValues();
        setVisible(true);
    }

    private void setInitialValues() {
        GlobalProperties gp = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);
        boolean ab = new Boolean(gp.getProperty("add_boundary_atoms_ab"))
                .booleanValue();
        boolean ac = new Boolean(gp.getProperty("add_boundary_atoms_ac"))
                .booleanValue();
        boolean bc = new Boolean(gp.getProperty("add_boundary_atoms_bc"))
                .booleanValue();
        boolean pack = new Boolean(gp.getProperty("pack_atoms_into_unit_cell"))
                .booleanValue();

        abplane.setSelected(ab);
        acplane.setSelected(ac);
        bcplane.setSelected(bc);
        packatom.setSelected(pack);

        String seps = gp.getProperty("pack_atoms_into_unit_cell_eps");
        if (seps != null) {
            eps.setText(seps);
        } else {
            eps.setText(defaultEps);
        }
        eps.setEnabled(packatom.isSelected());

        String sshift = gp.getProperty("atom_shift_policy");
        int shift = 0;
        if (sshift != null && sshift.length() != 0) {
            try {
                shift = Integer.parseInt(sshift);
            } catch (Exception ex) {
                shift = 0;
            }
            if (shift > 1) {
                shift = 0;
            }
        }
        shiftPolicyCombo.setSelectedIndex(shift);

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed"
    // desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        abplane = new javax.swing.JCheckBox();
        acplane = new javax.swing.JCheckBox();
        bcplane = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        apply = new javax.swing.JButton();
        cancel = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        packatom = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        eps = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        shiftPolicyCombo = new javax.swing.JComboBox();

        setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "add boundary atoms",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 0, 12), new java.awt.Color(0,
                        51, 153)));
        jPanel1.setForeground(new java.awt.Color(0, 51, 153));
        abplane.setText("a-b plane");
        abplane.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                abplaneActionPerformed(evt);
            }
        });

        jPanel1.add(abplane, new org.netbeans.lib.awtextra.AbsoluteConstraints(
                20, 20, 80, -1));

        acplane.setText("a-c plane");
        acplane.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                acplaneActionPerformed(evt);
            }
        });

        jPanel1.add(acplane, new org.netbeans.lib.awtextra.AbsoluteConstraints(
                20, 40, -1, -1));

        bcplane.setText("b-c plane");
        bcplane.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bcplaneActionPerformed(evt);
            }
        });

        jPanel1.add(bcplane, new org.netbeans.lib.awtextra.AbsoluteConstraints(
                20, 60, -1, -1));

        add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 30,
                170, 100));

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2,
                javax.swing.BoxLayout.X_AXIS));

        apply.setText("apply");
        apply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyActionPerformed(evt);
            }
        });

        jPanel2.add(apply);

        cancel.setText("cancel");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });

        // jPanel2.add(cancel);

        add(jPanel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(130,
                220, 170, 40));

        jPanel3.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
                "pack atoms",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS UI Gothic", 0, 12), new java.awt.Color(0,
                        51, 153)));
        packatom.setText("pack atoms into unit cell");
        packatom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                packatomActionPerformed(evt);
            }
        });

        jPanel3.add(packatom,
                new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 20, -1,
                        -1));

        jPanel4.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("eps"));
        eps.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                epsActionPerformed(evt);
            }
        });

        jPanel4.add(eps, new org.netbeans.lib.awtextra.AbsoluteConstraints(20,
                20, 120, 20));

        jPanel3.add(jPanel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(
                10, 40, 160, 50));

        add(jPanel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(180, 30,
                190, 100));

        jLabel1.setText("*note: some changes will take effect only after reboot of the viewer");
        add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 10,
                -1, -1));

        // jPanel5.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        // jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
        // "shift policy",
        // javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
        // javax.swing.border.TitledBorder.DEFAULT_POSITION, new
        // java.awt.Font("MS UI Gothic", 0, 12), new java.awt.Color(0, 51,
        // 153)));
        shiftPolicyCombo.setModel(new javax.swing.DefaultComboBoxModel(
                new String[] { "shift atoms to edge of cell",
                        "shift atoms to center of cell" }));
        // jPanel5.add(shiftPolicyCombo, new
        // org.netbeans.lib.awtextra.AbsoluteConstraints(10, 20, 180, 20));

        // add(jPanel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(10,
        // 130, 200, 60));

        revalidate();
    }

    // </editor-fold>//GEN-END:initComponents

    private void packatomActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_packatomActionPerformed
        // TODO add your handling code here:
        eps.setEnabled(packatom.isSelected());
    }// GEN-LAST:event_packatomActionPerformed

    private void epsActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_epsActionPerformed
        // TODO add your handling code here:
    }// GEN-LAST:event_epsActionPerformed

    private void cancelActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_cancelActionPerformed
        // TODO add your handling code here:
        // dispose();
    }// GEN-LAST:event_cancelActionPerformed

    private void applyActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_applyActionPerformed
        // TODO add your handling code here:
        GlobalProperties gp = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);
        gp.setProperty("add_boundary_atoms_ab",
                String.valueOf(abplane.isSelected()));
        gp.setProperty("add_boundary_atoms_ac",
                String.valueOf(acplane.isSelected()));
        gp.setProperty("add_boundary_atoms_bc",
                String.valueOf(bcplane.isSelected()));
        gp.setProperty("pack_atoms_into_unit_cell",
                String.valueOf(packatom.isSelected()));
        String seps = eps.getText();
        if (seps != null) {
            try {
                Double.parseDouble(seps);
                gp.setProperty("pack_atoms_into_unit_cell_eps", seps);
            } catch (NumberFormatException nfe) {
                gp.setProperty("pack_atoms_into_unit_cell_eps", defaultEps);
            }
        } else {
            gp.setProperty("pack_atoms_into_unit_cell_eps", defaultEps);
        }

        gp.setProperty("atom_shift_policy",
                new Integer(shiftPolicyCombo.getSelectedIndex()).toString());

        gp.storeProperty();
        parent.doUnitCell(true);
    }// GEN-LAST:event_applyActionPerformed

    private void bcplaneActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_bcplaneActionPerformed
        // TODO add your handling code here:
    }// GEN-LAST:event_bcplaneActionPerformed

    private void acplaneActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_acplaneActionPerformed
        // TODO add your handling code here:
    }// GEN-LAST:event_acplaneActionPerformed

    private void abplaneActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_abplaneActionPerformed
        // TODO add your handling code here:
    }// GEN-LAST:event_abplaneActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox abplane;
    private javax.swing.JCheckBox acplane;
    private javax.swing.JButton apply;
    private javax.swing.JCheckBox bcplane;
    private javax.swing.JButton cancel;
    private javax.swing.JTextField eps;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JCheckBox packatom;
    private javax.swing.JComboBox shiftPolicyCombo;
    // End of variables declaration//GEN-END:variables

}
