/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/08, 21:15
!  AUTHOR(S): KOGA, Junichiro
!  File : NfDynmParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * 
 * @author
 */
public class NfDynmParser extends OutputParser {
    private Logger logger = Logger.getLogger(NfDynmParser.class.getName());
    // private OutputData outputData;

    /** sharp */
    private String SHARP = "#";

    /** store unusual identifiers */
    private String iter_ion_str = new String();
    private String iter_total_str = new String();

    private String[] ident = { "iter_ion", "iter_total", "atom_label",
            "pos(x)", "pos(y)", "pos(z)", "forc(x)", "forc(y)", "forc(z)" };

    private String header = "";
    private String LS = System.getProperty("line.separator");

    private Vector dataVector = new Vector();

    /** Creates a new instance of NfDynmParser */
    public NfDynmParser(String fileName) {
        super(fileName);
    }

    protected boolean parse() {
        // logger.info("at dynmparse");
        String line;
        if (readers != null) {
            for (int i = 0; i < readers.length; i++) {
                readHeader = false;
                header = "";
                dataVector = new Vector();
                try {
                    while ((line = readers[i].readLine()) != null) {
                        parseLine(line.trim());
                    }
                } catch (IOException ioe) {
                } finally {
                    try {
                        readers[i].close();
                    } catch (IOException io) {
                    }
                }
                String[][] data2d = null;
                if (dataVector.size() != 0) {
                    data2d = new String[dataVector.size()][ident.length];
                    dataVector.copyInto(data2d);
                }
                String[] id = fileNames.get(i).toString().split("\\.");
                OutputData outputData = new OutputData(id[id.length - 1],
                        "ionic position & force", ident, data2d, header);
                outputData.setFileName(fileName);
                super.addOutputData(outputData);
            }
            if (readers.length != 0)
                isDone = true;
        }
        if (reader == null) {
            return false;
        }
        dataVector = new Vector();
        header = "";
        try {
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        } finally {
            isDone = true;
            try {
                reader.close();
            } catch (IOException ioe) {
                logger.error("failed to close " + fileName);
            }
        }
        String[][] data2d = null;
        if (dataVector.size() != 0) {
            data2d = new String[dataVector.size()][ident.length];
            dataVector.copyInto(data2d);
        }
        if (dataVector.size() == 0)
            return false;
        OutputData outputData = new OutputData("F_DYNM",
                "ionic position & force", ident, data2d, header);
        outputData.setFileName(fileName);
        super.addOutputData(outputData);
        return true;
    }

    private boolean readHeader = false;

    private void parseLine(String line) {
        if (line.startsWith(SHARP) && readHeader)
            return;

        if (line.startsWith(SHARP) && !readHeader) {
            header += line + LS;
        } else if (line.startsWith("cps")) {
            String[] arcps = line.split("\\s+");
            if (arcps != null && arcps.length >= 9) {
                iter_ion_str = arcps[7];
                iter_total_str = arcps[8];
            } else {
                iter_ion_str = "N/A";
                iter_total_str = "N/A";
            }
        } else {
            readHeader = true;
            String[] data = line.split("\\s+");
            if (data == null) {
                return;
            }
            String[] row = new String[data.length + 2];
            row[0] = iter_ion_str;
            row[1] = iter_total_str;
            for (int i = 0; i < data.length; i++) {
                row[i + 2] = data[i];
            }
            dataVector.addElement(row);
        }
    }

    public String getCurrentMessage() {
        return null;
    }

}
