/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/09, 13:21
!  AUTHOR(S): KOGA, Junichiro
!  File : BMParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * F_ENFt@Cparse.
 * 
 * @author
 */
public class BMParser extends OutputParser {
    private Logger logger = Logger.getLogger(BMParser.class.getName());
    private final String START = "#";
    private String[] idents;
    private Vector dataVector = new Vector();

    /** Creates a new instance of NfEnfParser */
    public BMParser(String fileName) {
        super(fileName);
    }

    protected boolean parse() {
        String line = "";
        if (readers != null) {
            for (int i = 0; i < readers.length; i++) {
                dataVector = new Vector();
                try {
                    logger.debug("at file:" + fileNames.get(i).toString());
                    while ((line = readers[i].readLine()) != null) {
                        if (line.trim().length() == 0)
                            continue;
                        logger.debug(line);
                        parseLine(line.trim());
                    }
                } catch (IOException e) {
                }
                try {
                    readers[i].close();
                } catch (IOException io) {
                }
                if (dataVector.size() == 0)
                    continue;
                idents = new String[((String[]) dataVector.get(0)).length];
                String[][] d2d = new String[dataVector.size()][((String[]) dataVector
                        .get(0)).length];
                try {
                    dataVector.copyInto(d2d);
                } catch (ArrayIndexOutOfBoundsException aiob) {
                    logger.error("corrupted F_ENF file: "
                            + fileNames.get(i).toString());
                    return false;
                }
                String[] id = fileNames.get(i).toString().split("\\.");
                String nam = id[id.length - 1];
                if (new File(fileNames.get(i).toString()).getName().startsWith(
                        "potential_of_mean")) {
                    nam = "PMF";
                    if (idents.length >= 9) {
                        idents[0] = "value";
                        idents[1] = "Hartree";
                        idents[2] = "err";
                        idents[3] = "eV";
                        idents[4] = "err";
                        idents[5] = "kcal/mol";
                        idents[6] = "err";
                        idents[7] = "kJ/mol";
                        idents[8] = "err";
                    } else if (idents.length >= 5) {
                        idents[0] = "value";
                        idents[1] = "Hartree";
                        idents[2] = "eV";
                        idents[3] = "kcal/mol";
                        idents[4] = "kJ/mol";
                    }
                } else if (new File(fileNames.get(i).toString()).getName()
                        .startsWith("mean_force")) {
                    if (idents.length >= 3) {
                        nam = "MF";
                        idents[0] = "value";
                        idents[1] = "force";
                        idents[2] = "err";
                    } else if (idents.length >= 2) {
                        nam = "MF(smoothed)";
                        idents[0] = "value";
                        idents[1] = "force";
                    }
                } else {
                    int nreac = (idents.length - 1) / 2;
                    idents[0] = "md step";
                    for (int j = 0; j < nreac; j++) {
                        String val = "value" + String.valueOf(j + 1);
                        String lam = "lambda" + String.valueOf(j + 1);
                        idents[j + 1] = val;
                        idents[1 + nreac + j] = lam;
                    }
                    idents[idents.length - 1] = "det. met.";
                }
                OutputData outputData = new OutputData(nam,
                        "lambda at each step", idents, d2d, "");
                outputData.setFileName(fileNames.get(i).toString());
                addOutputData(outputData);
                idents = null;
            }
            if (readers.length != 0)
                isDone = true;
        }

        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith(START)) {
            return;
        }
        String[] data = line.split("\\s+");
        dataVector.addElement(data);
    }

    public String getCurrentMessage() {
        return null;
    }

}
