/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/09, 13:53
!  AUTHOR(S): KOGA, Junichiro
!  File : FileStateChangeEvent.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.inputinterface.filestate;

import java.util.EventListener;

import org.apache.log4j.Logger;

/**
 * t@CԂNX.
 * 
 * @author
 */
public class FileStateChangeEvent implements EventListener {
    private Logger logger = Logger.getLogger(FileStateChangeEvent.class
            .getName());
    private FileState[] files;

    /**
     * ԕύX̂t@CɂƂ(ۂɂ̓t@C̔z).
     * 
     * @param file
     *            ԕύX̂t@C
     */
    public FileStateChangeEvent(FileState file) {
        this.files = new FileState[] { file };
    }

    /**
     * ԕύX̂t@C̔zɂƂ.
     * 
     * @param files
     *            ԕύX̂t@C̔z
     */
    public FileStateChangeEvent(FileState[] files) {
        this.files = files;
    }

    /**
     * ̃NXĂt@C̔z擾
     * 
     * @return t@C̔z
     */
    public FileState[] getFileStates() {
        return this.files;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < files.length; i++) {
            ret += files[i].toString() + System.getProperty("line.separator");
        }
        return ret;
    }
}
