/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/15, 15:14
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectDirBrowserTree.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import java.awt.event.MouseEvent;

import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

/**
 * ProjectDirBrowserpJTree.
 * 
 * @author
 */
public class ProjectDirBrowserTree extends JTree {
    private Logger logger = Logger.getLogger(ProjectDirBrowserTree.class
            .getName());

    /** Creates a new instance of ProjectDirBrowserTree */
    public ProjectDirBrowserTree() {
        super();
        ToolTipManager.sharedInstance().registerComponent(this);
        setDragEnabled(true);
        setToggleClickCount(40);
        setRowHeight(-1);
    }

    public String getToolTipText(MouseEvent e) {
        Object tip = null;
        TreePath path = getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            tip = path.getLastPathComponent();
        }
        return tip == null ? null : tip.toString();
    }

    public JToolTip createToolTip() {
        return new ciss.phase_viewer.pub.primitivegui.JMultiLineToolTip();
    }

}
