/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/12, 19:34
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectInfo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser;

import java.awt.Dimension;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.DefaultScriptCreator;
import ciss.phase_viewer.outputinterface.OutputInterface;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;

/**
 * vWFNgێ, \̂̂悤ȃNX.
 * 
 * "ProjectInfo" , L.
 * 
 * 1. $HOME/.phase-viewer/my_projects.xmlɋLqĂ: name: vWFNg date: 쐬ꂽt
 * projectType: uvWFNgv, : phase projdir: vWFNgfBNg[ hasSubs: ʍ\ۂ
 * infoType: BASESUB, BASEƂ͉ʍ\vWFNg, SUB͎ȂvWFNg comment:
 * vWFNgɕtRg.
 * 
 * 2. vWFNg[hɍ쐬CX^Xւ̎Q: parent: ̃NX̏,
 * ̑uProjectBrowservIuWFNgɂĒ`, ܂p. ̑厖ȑ厖ȃIuWFNgւ̎Q.
 * inputInterface: InputInterfaceIuWFNg. phase̓t@C`̓ǂ/\ dm:
 * inputInterfaceێ, DataManagerNX̃IuWFNg. fBXÑt@C͂̃NX.
 * outputInterface: o̓f[^𓝈IɈ߂, OutputInterfaceIuWFNg.
 * defaultScriptCreator: Wup̃ftHgXNvg쐬IuWFNg. projectdescriptionURL :
 * vWFNgɓZeLqĂHTMLt@CւURL (nullȂ炻͂ł悢)
 * 
 * 3. IɕύX: subprojects: ʂProjectInfoIuWFNgi[邽߂VectorIuWFNg. ̑,
 * parents. targetDir: zXg񂪕ύX邽тɕς.
 * 
 * @author KOGA, Junichiro
 */
public class ProjectInfo implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 6020378635554945716L;
    public static final int BASE = 1;
    public static final int SUB = 2;

    private static Logger logger = Logger
            .getLogger(ProjectInfo.class.getName());

    private URL projectdescriptionURL = null;

    private String projdir;
    private String projectType;
    private int infoType = BASE;
    private String name;
    private String date;
    private Vector subprojects = new Vector();

    private Element element;

    private ChaseFileManager chaseFileManager; // new style

    private ProjectBrowser parent;
    private Document doc;

    private InputInterface inputInterface;
    private OutputInterface outputInterface;

    private DataManager dm;

    private DefaultScriptCreator defaultScriptCreator;

    private String targetDir;
    private String parentDir = null;

    private String comment;
    private boolean readProjectPropertyDoc = false;

    private String rootDir = System.getProperty("user.home");
    private HostInfo hostInfo;

    private boolean editable = true;

    private Dimension initBrowserSize = new Dimension(680, 500);

    private Class[] stdoutGUIs;

    private HashMap guiComponents = new HashMap();

    /**
     * Creates a new instance of ProjectInfo
     * 
     * @param element
     *            fBXNǂݍ񂾃vWFNgElementIuWFNg.
     */
    public ProjectInfo(Element element) {
        this.element = element;
        init();
    }

    /**
     * vWFNgfBNg[phase-viewer.xmlt@Cǂݍނǂwł
     * 
     * @param element
     *            myproject.xmlǂݍ񂾃vWFNgElement
     * @param readProjectPropertyDoc
     *            vWFNg[fBNg[phase-viewer.xmlǂݍނǂw
     */
    public ProjectInfo(Element element, boolean readProjectPropertyDoc) {
        this.element = element;
        this.readProjectPropertyDoc = readProjectPropertyDoc;
        init();
    }

    /**
     * subprojectProjectInfo𑫂.
     * 
     * @param info
     *            ݂ProjectInfoIuWFNg
     */
    public void addSubProjectInfo(ProjectInfo info) {
        if (this.infoType == BASE) {
            subprojects.addElement(info);
        }
    }

    /**
     * vZvOpo̓t@CɊւێ, ChaseFileManagerIuWFNgւ QƂ擾.
     * 
     * @return ̃vWFNgɊ֘AtꂽChaseFileManagerIuWFNg.
     */
    public ChaseFileManager getChaseFileManager() {
        logger.debug("at getChaseFileManager:");
        if (this.chaseFileManager == null) {
            logger.debug("chasefilemanager is null...");
        }
        return this.chaseFileManager;
    }

    /**
     * vWFNgɕtRgQbg. 0̏ꍇnullԂ.
     * 
     * @return Rg
     */
    public String getComment() {
        if (comment == null || comment.trim().length() == 0) {
            return null;
        }
        return this.comment;
    }

    /**
     * ̃vWFNg̍쐬Ԃ.
     * 
     * @param \L̍쐬
     *            .
     */
    public String getDate() {
        return date;
    }

    /**
     * Wup, ftHgXNvg쐬IuWFNgQbg.
     * 
     * @return ftHg̃XNvg쐬IuWFNg.
     */
    public DefaultScriptCreator getDefaultScriptCreator() {
        return this.defaultScriptCreator;
    }

    /**
     * o^ĂGUĨCX^X擾. JComponent̃TuNXŖꍇnullԂ.
     * 
     * @param clazz
     *            o^ĂGUĨNX
     * @return o^ĂGUI
     */
    public Object getGUI(Class clazz) {
        Object obj = guiComponents.get(clazz.getName());
        return obj;
    }

    /**
     * ݂̃vWFNg֘AtĂzXgQbg
     * 
     * @return ݂̃vWFNg̃^[QbgzXg
     */
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    /**
     * uvWFNgvԂ. ŁuvWFNgvBASESUB̂ꂩ, BASȄꍇ͂ɉʂ̃vWFNg.
     * 
     * @return vWFNg.
     */
    public int getInfoType() {
        return infoType;
    }

    /**
     * vWFNguEU[̏TCY擾; ftHg800x600
     * 
     * @return vWFNguEU[̏TCY ([U[ɂ郊TCYsꂽꍇ, ̃TCYۑėD悳)
     */
    public Dimension getInitialBrowserSize() {
        return initBrowserSize;
    }

    /**
     * InputInterfaceIuWFNgi[, DataManagerIuWFNgւ̎QƂ擾.
     * InputInterfaceIuWFNgꂩ蒼Kvꍇ (: ev[gt@CRs[)Ȃǂ̏ꍇɎg.
     * 
     * @return ̃vWFNgɊ֘At瓾ꂽDataManagerIuWFNg.
     */
    public DataManager getInputDataManager() {
        return this.dm;
    }

    /**
     * ̃NXɊ֘Atꂽ, ̓t@CNXł, InputInterfaceIuWFNg 郁\bh.
     * ̓t@CҏWpGUI, ̃\bhē̓̓t@CɃANZX邱Ƃ ł.
     * 
     * @return ̃vWFNgɊ֘AtꂽInputInterfaceIuWFNgւ̎Q.
     */
    public InputInterface getInputInterface() {
        return this.inputInterface;
    }

    /**
     * o̓f[^𓝈IɈ߂OutputInterfaceIuWFNgւ̎QƂ擾.
     * 
     * @return ̃vWFNgɊ֘AtĂOutputInterfaceIuWFNgւ̎Q.
     */
    public OutputInterface getOutputInterface() {
        return outputInterface;
    }

    /**
     * ProjectBrowserւ̎QƂ擾. ̃IuWFNg̃NX̃CX^X 擾,
     * lXȕ\ANV肳悤ɂȂĂ.
     * 
     * @return ̃vWFNgɊ֘AtꂽProjectBrowserւ̎Q
     */
    public ProjectBrowser getParent() {
        return this.parent;
    }

    /**
     * ̃vWFNǵuefBNg[vԂ. efBNg[ekcaluvsorȂǂ ꍇSCFvZsfBNg[w.
     * PHASȄꍇnullԂ.
     * 
     * @return efBNg[ւ̃pX(΃pX)
     */
    public String getParentDir() {
        return parentDir;
    }

    private String getPathFromElement(String delimiter) {
        Element parent = element;
        String dir = "";
        Vector vector = new Vector();
        // vector.addElement(MyElement.decode(element.getChildTextTrim("name")));
        vector.addElement(getProjectName());
        while ((parent = parent.getParentElement()) != null
                && !parent.getChildTextTrim("type").equals("root")) {
            vector.addElement(MyElement.decode(parent.getChildTextTrim("name")));
        }
        for (int i = vector.size() - 1; i >= 0; i--) {
            dir += (String) vector.get(i) + delimiter;
        }
        return dir;
    }

    /**
     * vWFNg̐ȂǂLqĂHTMLt@CւURL擾.
     * 
     * @return vWFNgɓZ񂪋LqĂHTMLt@C
     */
    public URL getProjectDescriptionURL() {
        return this.projectdescriptionURL;
    }

    /**
     * ̃vWFNg̃x[XƂȂfBNg[ւ̃pXԂ. vWFNg̃c[\Ǝۂ̃fBXÑt@C̈ʒu͓ɂȂ悤ɂĂ
     * 
     * @return vWFNgfBNg[ւ̃pX.
     */
    public String getProjectDirectory() {
        // return this.projdir;
        if (isRoot()) {
            return rootDir;
        }
        String dir = getPathFromElement(System.getProperty("file.separator"));
        logger.debug("ProjectDirectory: " + dir);
        return rootDir + System.getProperty("file.separator") + dir;
    }

    /**
     * my_projects.xmlɋLڂ̂, ProjectInfoElement擾
     * 
     * @return ̃vWFNg̏񂪋LڂꂽElement.
     */
    public Element getProjectElement() {
        return this.element;
    }

    /**
     * vWFNgԂ.
     * 
     * @return vWFNg
     */
    public String getProjectName() {
        return name;
    }

    /**
     * Ot@CɃvWFNgoۂɕKvDocumentIuWFNgւ̎QƂ擾.
     * 
     * @return ̃NXɊ֘AtꂽDocumentIuWFNg.
     */
    public Document getProjectPropertyDocument() {
        return this.doc;
    }

    /**
     * uvWFNg^CvvԂ. vWFNg^CvƂ, ƂphaseȂ "phase" Ƃ.
     * ̓Iɂ̓vOCł̒`ɂ.
     * 
     * @return uvWFNg^Cvv
     */
    public String getProjectType() {
        return projectType;
    }

    /**
     * Wo͂\GUIClass擾. nullԂ.
     * 
     * @return L̒ʂ
     */
    public Class[] getStdoutGUIs() {
        return this.stdoutGUIs;
    }

    /**
     * TuvWFNgProjectInfoIuWFNgi[java.util.VectorIuWFNgԂ.
     * 
     * @return TuvWFNgProjectInfoIuWFNgi[Vector.
     */
    public Vector getSubProjects() {
        return subprojects;
    }

    /**
     * ^[QbgfBNg[Ԃ. ProjectDirectory̓[JzXg̃fBNg[ł̂ɑ΂,
     * TargetDirectory̓[gzXg̎sfBNg[.
     */
    public String getTargetDirectory() {
        return this.targetDir;
    }

    /**
     * ܂, ƂɂfBXN̏ǂݍ.
     */
    private void init() {
        hostInfo = HostList.getHostList().getHostInfo("localhost");
        String bdir = hostInfo.getProperty("basedir");
        if (bdir != null && bdir.trim().length() != 0
                && new File(bdir).exists() && new File(bdir).isDirectory()) {
            rootDir = bdir;
        }

        String elemName = element.getName();
        if (elemName.equals("project")) {
            infoType = BASE;
        } else if (elemName.equals("subproject")) {
            infoType = SUB;
        }
        name = MyElement.decode(element.getChildTextTrim("name"));
        date = MyElement.decode(element.getChildTextTrim("date"));
        projectType = MyElement.decode(element.getChildTextTrim("type"));
        projdir = MyElement.decode(element.getChildTextTrim("directory"));
        comment = MyElement.decode(element.getChildTextTrim("comment"));

        Element edi = element.getChild("editable");
        if (edi != null) {
            editable = new Boolean(edi.getTextTrim()).booleanValue();
        }

        if (isRoot()) { // root͏weRȏKv
            name = new File(rootDir).getName();
            Element en = element.getChild("name");
            if (en == null) {
                en = new Element("name");
            }
            en.setText(MyElement.encode((name)));
            logger.debug("root name: " + name);

            projdir = rootDir;
            Element dir = element.getChild("directory");
            if (dir == null) {
                dir = new Element("directory");
                element.addContent(dir);
            }
            dir.setText(MyElement.encode(projdir));
            if (date == null || date.trim().length() == 0) {
                date = Calendar.getInstance().getTime().toString();
                Element de = element.getChild("date");
                if (de == null) {
                    de = new Element("date");
                    element.addContent(de);
                }
                de.setText(MyElement.encode(date));
            }
        }

        Element associated = element.getChild("associated_directory");
        if (associated != null) {
            Attribute attr = associated.getAttribute("type");
            if (attr != null && attr.getValue().trim().equals("parent")) {
                parentDir = MyElement.decode(associated.getTextTrim());
            }
        }
        String hasSubs = element.getAttributeValue("hassub");

        boolean bhasSubs = false;
        if (hasSubs != null) {
            bhasSubs = new Boolean(hasSubs).booleanValue();
        }
        if (bhasSubs) {
            String subident = element.getAttributeValue("subident");
            if (subident == null) {
                logger.error("invalid `subident' attribute");
            }
            List list = element.getChildren(subident);
            if (list != null) {
                for (int i = 0; i < list.size(); i++) {
                    subprojects.addElement(new ProjectInfo((Element) list
                            .get(i), readProjectPropertyDoc));
                }
            }
        }

        if (infoType == SUB && readProjectPropertyDoc) {
            // String chaseXML = getProjectDirectory() +
            // System.getProperty("file.separator") + "phase-viewer.xml";
            // File filechaseXML = new File(chaseXML);
            // Document doc = null;
            // if ( filechaseXML.exists() ) {
            // doc =
            // ciss.phase_viewer.jdom.XMLUtils.getDocumentFromFile(filechaseXML);
            // }
            // if ( doc == null ) {
            // java.net.URL defchaseXML =
            // getClass().getResource("/ciss/phase_viewer/projectbrowser/phase-viewer.xml");
            // doc =
            // ciss.phase_viewer.jdom.XMLUtils.getDocumentFromURL(defchaseXML);
            // String projchaseXML =
            // getProjectDirectory()+System.getProperty("file.separator")+"phase-viewer.xml";
            // ciss.phase_viewer.jdom.XMLUtils.saveDocumentTo(doc,new
            // File(projchaseXML));
            // }
            // setProjectPropertyDocument(doc);
        }
    }

    /**
     * ̃vWFNǵuҏWsvȏꍇfalseԂ. Ƃ΋[|eVfBNg[̉ɑ̃vWFNg͋Ȃ.
     */
    public boolean isEditable() {
        return editable;
    }

    public boolean isRoot() {
        return projectType.equals("root");
    }

    /**
     * GUĨCX^XĂƂɎgƗǂ. , NXo^łdg;
     * vWFNg݂̒̂ŒʗpVOĝ悤Ȉ.
     * 
     * @param component
     *            ĂR|[lg
     */
    public void registerGUI(Object component) {
        guiComponents.put(component.getClass().getName(), component);
    }

    private HashMap objMap = new HashMap();

    /**
     * L[ɃIuWFNgo^; HashMap̃bp[
     * 
     * @param key
     *            L[
     * @param obj
     *            o^IuWFNg
     */
    public void put(Object key, Object obj) {
        objMap.put(key, obj);
    }

    /**
     * L[ɃIuWFNgQbg; HashMap̃bp[
     * 
     * @param key
     *            L[
     */
    public Object get(Object key) {
        return objMap.get(key);
    }

    /**
     * ێsubproject폜.
     * 
     * @param info
     *            폜subproject.
     */
    public void removeSubProjectInfo(ProjectInfo info) {
        if (this.infoType == BASE) {
            subprojects.remove(info);
        }
    }

    /**
     * Ot@C, ۑł͕ۑ. ̃pX, projdir/phase-viewer.xmlł.
     */
    public void saveProjectPropertyDocument() {
        String chaseXML = getProjectDirectory()
                + System.getProperty("file.separator") + "phase-viewer.xml";
        ciss.phase_viewer.jdom.XMLUtils.saveDocumentTo(doc, chaseXML);
        setProjectPropertyDocument(doc);
    }

    /**
     * vZvOpo̓t@CɊւێ, ChaseFileManagerIuWFNg Zbg.
     */
    public void setChaseFileManager(ChaseFileManager chaseFileManager) {
        this.chaseFileManager = chaseFileManager;
        if (chaseFileManager == null) {
            logger.error("ChaseFileManager for this project seems to be null...");
        } else {
            chaseFileManager.setProjectInfo(this);
        }
        changed();
    }

    /**
     * vWFNgɕtRgZbg.
     * 
     * @param comment
     *            Rg
     */
    public void setComment(String comment) {
        this.comment = comment;
        changed();
    }

    /**
     * Wup, ftHgXNvg쐬IuWFNgZbg.
     * 
     * @param defaultScriptCreator
     *            ftHg̃XNvg쐬IuWFNg.
     */
    public void setDefaultScriptCreator(
            DefaultScriptCreator defaultScriptCreator) {
        this.defaultScriptCreator = defaultScriptCreator;
        changed();
    }

    /**
     * ݂̃vWFNg֘AtĂzXgZbg
     * 
     * @param hostInfo
     *            ݂̃vWFNg̃^[QbgzXg
     */
    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
        setTargetDirectory(hostInfo);
        changed();
    }

    /**
     * vWFNguEU[̏TCYZbg.
     * 
     * @param vWFNguEU[̏TCY
     */
    public void setInitialBrowserSize(Dimension dim) {
        this.initBrowserSize = dim;
        changed();
    }

    /**
     * InputInterfaceIuWFNgi[, DataManagerIuWFNgւ̎QƂZbg.
     * DataManagerIuWFNg, ɃfBXÑt@C̓ǂݍ/oȂǂs.
     * InputInterfacȅȂǂɂĂ͕KvȂ̂, ̃NXł̎QƂ`.
     * 
     * @param dm
     *            ̃NXɊ֘AtDataManagerIuWFNgւ̎Q.
     */
    public void setInputDataManager(DataManager dm) {
        this.dm = dm;
        changed();
    }

    /**
     * ̓t@CNXł, InputInterfaceIuWFNg̃NXɊ֘At郁\bh.
     * ŃZbgꂽJē̓t@C̏lXȃIuWFNg擾.
     * 
     * @param inputInterface
     *            ̃NXɊ֘AtꂽInputInterfaceIuWFNg.
     */
    public void setInputInterface(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
        changed();
    }

    /**
     * o̓f[^𓝈IɈ߂OutputInterfaceIuWFNgւ̎QƂZbg.
     * 
     * @param outputInterface
     *            ̃vWFNgɊ֘AtĂOutputInterfaceIuWFNgւ̎Q.
     */
    public void setOutputInterface(OutputInterface outputInterface) {
        this.outputInterface = outputInterface;
        outputInterface.setProjectInfo(this);
        changed();
    }

    /**
     * ProjectBrowserւ̎QƂZbg. ̃IuWFNg̃NX̃CX^X 擾,
     * lXȕ\ANV肳悤ɂȂĂ.
     * 
     * @param parent
     *            ZbgProjectBrowserIuWFNgւ̎Q.
     */
    public void setParent(ProjectBrowser parent) {
        this.parent = parent;
        changed();
    }

    /**
     * ̃vWFNǵuefBNg[vZbgBłɃZbgς݂ȏꍇȂB
     * 
     * @param parentDir
     *            ̃vWFNǵuefBNg[v
     */
    public void setParentDir(String parentDir) {
        if (this.parentDir != null) {
            return;
        }
        this.parentDir = parentDir;
        changed();
    }

    /**
     * vWFNg̐ȂǂLqĂHTMLt@CւURLZbg.
     * 
     * @param projectdescriptionURL
     *            vWFNgɓZ񂪋LqĂHTMLt@C
     */
    public void setProjectDescriptionURL(URL projectdescriptionURL) {
        this.projectdescriptionURL = projectdescriptionURL;
        changed();
    }

    /**
     * ̃vWFNg̃x[XƂȂfBNg[ւ̃pXZbg. gpɂ͒ӂ𕥂.
     * 
     * @param projdir
     *            vWFNg̃x[XƂȂfBNg[
     */
    public void setProjectDirectory(String projdir) {
        this.projdir = projdir;
        this.name = new File(projdir).getName();
        setTargetDirectory(hostInfo);
        Element nam = element.getChild("name");
        if (nam != null) {
            nam.setText(MyElement.encode(name));
        } else {
            Element ele = new Element("name").setText(MyElement.encode(name));
            element.addContent(ele);
        }
        changed();
    }

    /**
     * vWFNg𖾎IɃZbg. gpɂ͒ӂ𕥂.
     * 
     * @param name
     *            vWFNg̖O
     */
    public void setProjectName(String name) {
        this.name = name;
        changed();
    }

    /**
     * Ot@CɃvWFNgoۂɕKvDocumentIuWFNgւ̎QƂZbg.
     * 
     * @param doc
     *            ̃NXɊ֘AtDocumentIuWFNg. ProjectInfõfBXNւ̏o
     *            s肷̂ɕKv.
     */
    public void setProjectPropertyDocument(Document doc) {
        this.doc = doc;
        // if ( doc != null ) {
        // Element element = doc.getRootElement();
        // String comm = MyElement.decode(element.getChildTextTrim("comment"));
        // if ( comm != null && comm.length() != 0 ) {
        // setComment(comm);
        // }
        // }
        changed();
    }

    /**
     * Wo͂\GUIClassݒ肷.
     * 
     * @param clazz
     *            L̒ʂ
     */
    public void setStdoutGUIs(Class[] clazz) {
        this.stdoutGUIs = clazz;
        changed();
    }

    /**
     * ŗ^ꂽzXg񂩂烊[g̃^[QbgfBNg[쐬. localzXg̏ꍇProjectDirectoryƓ.
     * 
     * @param hostInfo
     *            zXg
     */
    public void setTargetDirectory(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
        String baseDir = hostInfo.getProperty("basedir");
        if (baseDir == null || baseDir.trim().length() == 0) {
            baseDir = "$HOME";
        }
        if (hostInfo.getName().equals("localhost")) {
            targetDir = new String(getProjectDirectory());
        } else {
            String dir = getPathFromElement("/");
            targetDir = baseDir + "/" + dir; // we assume that a remote target
                                             // directory's file separator is
                                             // '/'
        }
        logger.debug("set targetdir: " + targetDir);
        changed();
    }

    public String toString() {
        String ls = System.getProperty("line.separator");
        String retValue = "project info: " + ls;
        if (infoType == BASE) {
            retValue += " project info type: base" + ls;
        } else if (infoType == SUB) {
            retValue += " project info type: sub" + ls;
        }
        retValue += "name: " + name + " date: " + date + " type: "
                + projectType + " dir: " + projdir;
        return retValue;
    }

    /**
     * ElementɕύXĂ𔽉fꍇɌĂ.
     */
    public void update() {
        init();
        changed();
    }

    private Vector listeners;

    /**
     * ProjectInfo̕ύXʒmĂقListenero^.
     * 
     * @param o^Xi[
     */
    public void addProjectInfoListener(ProjectInfoListener listener) {
        if (listeners == null)
            listeners = new Vector();
        listeners.add(listener);
    }

    /**
     * o^ꂽXi[̓o^.
     * 
     * @param listener
     *            Xi[
     */
    public void removeProjectInfoListener(ProjectInfoListener listener) {
        if (listeners == null)
            return;
        listeners.remove(listener);
    }

    private boolean callingListener = false;

    private void changed() {
        if (listeners == null || callingListener)
            return;
        callingListener = true;
        ProjectInfoChangeEvent ev = new ProjectInfoChangeEvent(this);
        for (int i = 0; i < listeners.size(); i++)
            ((ProjectInfoListener) listeners.get(i)).projectInfoChanged(ev);
        callingListener = false;
    }

}
