/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/21, 19:54
!  AUTHOR(S): KOGA, Junichiro
!  File : ResultsViewerPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import ciss.phase_viewer.outputinterface.OutputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.TabbedProjectManipulator;

/**
 * ʕ\pGUI.
 * 
 * @author
 */
public class ResultsViewerPanel extends ProjectManipulator {
    private OutputInterface outputInterface;
    private TabbedProjectManipulator tpane;

    /** Creates new form ResultsViewerPanel */
    public ResultsViewerPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        initComponents();
    }

    public void init() {
        outputInterface = new OutputInterface(projectInfo.getChaseFileManager());
        projectInfo.setOutputInterface(outputInterface);
        java.net.URL url = getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/uvsorepsilon/tabbed_manipulator_result.xml");

        JPanel pa = new JPanel();
        pa.setLayout(new BoxLayout(pa, BoxLayout.Y_AXIS));
        tpane = new TabbedProjectManipulator(url, projectInfo);
        pa.add(tpane);
        JButton reload = new JButton("reload");
        pa.add(reload);

        add(pa);
        reload.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tpane.reload();
            }
        });

    }

    public void initializeProject() {
    }

    private void initComponents() {
        setLayout(new java.awt.BorderLayout());
        setBorder(new javax.swing.border.TitledBorder(null,
                "Results viewer panel",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS Sans Serif", 0, 11), new java.awt.Color(
                        0, 51, 153)));
    }

}
