/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/23, 17:27
!  AUTHOR(S): KOGA, Junichiro
!  File : PhotonPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.preparationpanel;

import java.awt.BorderLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author
 */
public class PhotonPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(GeneralPanel.class.getName());

    /** Creates a new instance of GeneralPanel */
    public PhotonPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new SubPanel(projectInfo.getInputInterface()), BorderLayout.NORTH);
    }

    class SubPanel extends PhaseInputItems {
        SubPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            JPanel polar = new JPanel();
            polar.setLayout(new BoxLayout(polar, BoxLayout.X_AXIS));
            polar.setBorder(new TitledBorder("polor"));

            String[] specux = new String[] { "epsilon.photon.polar.ux" };
            InputPanelPhase ux = new InputPanelPhase(specux, inputInterface,
                    "ux", InputPanelPhase.NONE, 15, this);
            String[] specuy = new String[] { "epsilon.photon.polar.uy" };
            InputPanelPhase uy = new InputPanelPhase(specuy, inputInterface,
                    "uy", InputPanelPhase.NONE, 15, this);
            String[] specuz = new String[] { "epsilon.photon.polar.uz" };
            InputPanelPhase uz = new InputPanelPhase(specuz, inputInterface,
                    "uz", InputPanelPhase.NONE, 15, this);
            polar.add(ux);
            polar.add(uy);
            polar.add(uz);

            JPanel pointing = new JPanel();
            pointing.setLayout(new BoxLayout(pointing, BoxLayout.X_AXIS));
            pointing.setBorder(new TitledBorder("pointing"));
            String[] specpx = new String[] { "epsilon.photon.pointing.px" };
            InputPanelPhase px = new InputPanelPhase(specpx, inputInterface,
                    "px", InputPanelPhase.NONE, 15, this);
            String[] specpy = new String[] { "epsilon.photon.pointing.py" };
            InputPanelPhase py = new InputPanelPhase(specpy, inputInterface,
                    "py", InputPanelPhase.NONE, 15, this);
            String[] specpz = new String[] { "epsilon.photon.pointing.pz" };
            InputPanelPhase pz = new InputPanelPhase(specpz, inputInterface,
                    "pz", InputPanelPhase.NONE, 15, this);
            pointing.add(px);
            pointing.add(py);
            pointing.add(pz);

            JPanel energy = new JPanel();
            energy.setLayout(new BoxLayout(energy, BoxLayout.X_AXIS));
            energy.setBorder(new TitledBorder("energy"));
            String[] speclow = new String[] { "epsilon.photon.energy.low" };
            InputPanelPhase low = new InputPanelPhase(speclow, inputInterface,
                    "low", InputPanelPhase.NONE, 15, this);
            String[] spechigh = new String[] { "epsilon.photon.energy.high" };
            InputPanelPhase high = new InputPanelPhase(spechigh,
                    inputInterface, "high", InputPanelPhase.NONE, 15, this);
            String[] specstep = new String[] { "epsilon.photon.energy.step" };
            InputPanelPhase step = new InputPanelPhase(specstep,
                    inputInterface, "step", InputPanelPhase.NONE, 15, this);
            energy.add(low);
            energy.add(high);
            energy.add(step);

            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
            p.add(polar);
            p.add(pointing);
            p.add(energy);

            add(p);
        }

    }
}
