/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/22, 16:40
!  AUTHOR(S): KOGA, Junichiro
!  File : PlotProperties.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.dataset;

import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * Combined chart`̂ɕKvȑێNX. CombinedłȂƂg?
 * 
 * @author
 */
public class PlotProperties {
    private Logger logger = Logger.getLogger(PlotProperties.class.getName());
    public static final int XYPLOT = 0;
    public static final int PIEPLOT = 1;

    public static final int DOMAIN = 0;
    public static final int RANGE = 1;

    private int plottype = XYPLOT;

    private int plot_orientation = DOMAIN;
    private boolean draw_redundant_axis = false;
    private double gap = 10.0d;
    private String title = "";

    private Vector subplots = new Vector();

    /**
     * Creates a new instance of CombinedPlotProperties
     */
    public PlotProperties() {
    }

    /**
     * @param plot_orientation
     *            domainLꍇDOMAIN, rangeLꍇRANGEw, ftHgDOMAIN
     * @param gap
     *            multiplevbgɂ, vbgԂ̃Mbvw.
     * @param draw_redundant_axis
     *            d鎲`ۂw, ftHgfalse.
     */
    public PlotProperties(String title, int plot_orientation, double gap,
            boolean draw_redundant_axis) {
        this.title = title;
        this.plot_orientation = plot_orientation;
        this.gap = gap;
        this.draw_redundant_axis = draw_redundant_axis;
    }

    public void setPlotType(int plottype) {
        this.plottype = plottype;
    }

    public int getPlotType() {
        return this.plottype;
    }

    public void addSubPlotProperties(SubPlotProperties sp) {
        subplots.addElement(sp);
    }

    public void removeSubPlotProperty(SubPlotProperties rem) {
        subplots.remove(rem);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    public void setPlotOrientation(int plot_orientation) {
        this.plot_orientation = plot_orientation;
    }

    public void drawRedundantAxis(boolean draw_redundant_axis) {
        this.draw_redundant_axis = draw_redundant_axis;
    }

    public double getGap() {
        return this.gap;
    }

    public int getPlotOrientation() {
        return plot_orientation;
    }

    public boolean drawRedundantAxis() {
        return draw_redundant_axis;
    }

    public String getTitle() {
        return this.title;
    }

    public SubPlotProperties getSubPlotPropertiesAt(int i) {
        if (subplots == null || subplots.size() <= i) {
            return null;
        }
        return (SubPlotProperties) subplots.get(i);
    }

    public SubPlotProperties[] getSubPlotProperties() {
        if (subplots == null || subplots.size() == 0) {
            return null;
        }

        SubPlotProperties[] ret = new SubPlotProperties[subplots.size()];
        subplots.copyInto(ret);

        return ret;
    }

    public int getSubPlotCount() {
        return subplots.size();
    }

}
