/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/04, 18:58
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomState.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord;

import org.apache.log4j.Logger;

/**
 * q̏ԂێĂbp[
 * 
 * @author
 */
public class AtomState implements Comparable {
    private Logger logger = Logger.getLogger(AtomState.class.getName());

    public static int UNCHANGED = 0;
    public static int MODIFIED = 1;
    public static int REMOVED = 2;
    public static int ADDED = 3;

    public int origIndex;
    public int index;
    public int mode = UNCHANGED;

    /**
     * ǂ̂悤ȏԂEX̍Wf[^ɂCfbNX͂Ȃ񂾂
     * 
     * @param mode
     *            ǂȏԂ
     * @param oindex
     *            X̃CfbNX
     */
    public AtomState(int mode, int oindex) {
        this.mode = mode;
        this.origIndex = oindex;
        this.index = origIndex;
    }

    public int compareTo(Object o) {
        if (!(o instanceof AtomState))
            throw new ClassCastException();
        AtomState comp = (AtomState) o;
        if (comp.index > index)
            return -1;
        if (comp.index == index)
            return 0;
        return 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AtomState))
            return false;
        return ((AtomState) o).index == index;
    }

}
