/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/05/25, 15:40
!  AUTHOR(S): KOGA, Junichiro
!  File : ChannelSftpWrapper.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.ssh.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;

/**
 * @author KOGA, Junichiro
 */

public class ChannelSftpWrapper extends ChannelSftp {
    private ChannelSftp c;

    private Sftp sftp;

    /** Creates a new instance of ChannelSftpWrapper */
    public ChannelSftpWrapper(ChannelSftp c, Sftp sftp) {
        this.c = c;
        this.sftp = sftp;
    }

    public Sftp getSftp() {
        return this.sftp;
    }

    public void cd(String str) throws SftpException {
        c.cd(str);
    }

    public void chgrp(int param, String str) throws SftpException {
        c.chgrp(param, str);
    }

    public void chmod(int param, String str) throws SftpException {
        c.chmod(param, str);
    }

    public void chown(int param, String str) throws SftpException {
        c.chown(param, str);
    }

    public void connect() throws JSchException {
        c.connect();
    }

    public void disconnect() {
        c.disconnect();
    }

    public void init() {
        // c.init();
    }

    public void lcd(String str) throws SftpException {
        c.lcd(str);
    }

    public String lpwd() {
        String retValue;

        retValue = c.lpwd();
        return retValue;
    }

    public boolean isConnected() {
        boolean retValue;

        retValue = c.isConnected();
        return retValue;
    }

    public java.util.Vector ls(String str) throws SftpException {
        java.util.Vector retValue;

        retValue = c.ls(str);
        return retValue;
    }

    public SftpATTRS lstat(String str) throws SftpException {
        SftpATTRS retValue;

        retValue = c.lstat(str);
        return retValue;
    }

    public void mkdir(String str) throws SftpException {
        c.mkdir(str);
    }

    public java.io.OutputStream put(String str) throws SftpException {
        java.io.OutputStream retValue;

        retValue = c.put(str);
        return retValue;
    }

    public void put(java.io.InputStream inputStream, String str)
            throws SftpException {
        c.put(inputStream, str);
    }

    public java.io.OutputStream put(String str, int param) throws SftpException {
        java.io.OutputStream retValue;

        retValue = c.put(str, param);
        return retValue;
    }

    public void put(String str, String str1) throws SftpException {
        c.put(str, str1);
    }

    public void put(java.io.InputStream inputStream, String str,
            SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        c.put(inputStream, str, sftpProgressMonitor);
    }

    public void put(java.io.InputStream inputStream, String str, int param)
            throws SftpException {
        c.put(inputStream, str, param);
    }

    public java.io.OutputStream put(String str,
            SftpProgressMonitor sftpProgressMonitor, int param)
            throws SftpException {
        java.io.OutputStream retValue;

        retValue = c.put(str, sftpProgressMonitor, param);
        return retValue;
    }

    public void put(String str, String str1,
            SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        c.put(str, str1, sftpProgressMonitor);
    }

    public void put(String str, String str1, int param) throws SftpException {
        c.put(str, str1, param);
    }

    public void put(java.io.InputStream inputStream, String str,
            SftpProgressMonitor sftpProgressMonitor, int param)
            throws SftpException {
        c.put(inputStream, str, sftpProgressMonitor, param);
    }

    public void put(String str, String str1,
            SftpProgressMonitor sftpProgressMonitor, int param)
            throws SftpException {
        c.put(str, str1, sftpProgressMonitor, param);
    }

    public String pwd() {
        String retValue = null;

        try {
            retValue = c.pwd();
        } catch (SftpException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public boolean isEOF() {
        boolean retValue;

        retValue = c.isEOF();
        return retValue;
    }

    public void rename(String str, String str1) throws SftpException {
        c.rename(str, str1);
    }

    public void quit() {
        c.quit();
    }

    public void rm(String str) throws SftpException {

        c.rm(str);
    }

    public void rmdir(String str) throws SftpException {
        c.rmdir(str);
    }

    public void run() {
        c.run();
    }

    public void sendSignal(String str) throws Exception {
        c.sendSignal(str);
    }

    public void setExtOutputStream(java.io.OutputStream outputStream) {
        c.setExtOutputStream(outputStream);
    }

    public void setInputStream(java.io.InputStream inputStream) {

        c.setInputStream(inputStream);
    }

    public void setMtime(String str, int param) throws SftpException {
        c.setMtime(str, param);
    }

    public void setOutputStream(java.io.OutputStream outputStream) {

        c.setOutputStream(outputStream);
    }

    public void setStat(String str, SftpATTRS sftpATTRS) throws SftpException {

        c.setStat(str, sftpATTRS);
    }

    public void symlink(String str, String str1) throws SftpException {
        c.symlink(str, str1);
    }

    public String toString() {

        String retValue;

        retValue = c.toString();
        return retValue;
    }

    public SftpATTRS stat(String str) throws SftpException {
        SftpATTRS retValue;

        retValue = c.stat(str);
        return retValue;
    }

    public String version() {

        String retValue;

        retValue = c.version();
        return retValue;
    }

    public void exit() {
        c.exit();
    }

    public boolean equals(Object obj) {

        boolean retValue;

        retValue = c.equals(obj);
        return retValue;
    }

    public java.io.InputStream get(String str) throws SftpException {
        java.io.InputStream retValue;

        retValue = c.get(str);
        return retValue;
    }

    public java.io.InputStream get(String str, int param) throws SftpException {
        java.io.InputStream retValue;

        retValue = c.get(str, param);
        return retValue;
    }

    public void get(String str, java.io.OutputStream outputStream)
            throws SftpException {
        c.get(str, outputStream);
    }

    public void get(String str, String str1) throws SftpException {
        c.get(str, str1);
    }

    public java.io.InputStream get(String str,
            SftpProgressMonitor sftpProgressMonitor, int param)
            throws SftpException {
        java.io.InputStream retValue;

        retValue = c.get(str, sftpProgressMonitor, param);
        return retValue;
    }

    public void get(String str, java.io.OutputStream outputStream,
            SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        c.get(str, outputStream, sftpProgressMonitor);
    }

    public void get(String str, String str1,
            SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        c.get(str, str1, sftpProgressMonitor);
    }

    public void get(String str, String str1,
            SftpProgressMonitor sftpProgressMonitor, int param)
            throws SftpException {

        c.get(str, str1, sftpProgressMonitor, param);
    }

    public int getExitStatus() {
        int retValue;

        retValue = c.getExitStatus();
        return retValue;
    }

    public java.io.InputStream getExtInputStream() throws java.io.IOException {
        java.io.InputStream retValue;

        retValue = c.getExtInputStream();
        return retValue;
    }

    public java.io.InputStream getInputStream() throws java.io.IOException {
        java.io.InputStream retValue;

        retValue = c.getInputStream();
        return retValue;
    }

    public java.io.OutputStream getOutputStream() throws java.io.IOException {
        java.io.OutputStream retValue;

        retValue = c.getOutputStream();
        return retValue;
    }

    public void setXForwarding(boolean param) {
        c.setXForwarding(param);
    }

    public int hashCode() {
        int retValue;

        retValue = c.hashCode();
        return retValue;
    }

    public void start() throws JSchException {
        c.start();
    }

}
