/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/30, 16:07
!  AUTHOR(S): KOGA, Junichiro
!  File : ColorConfigGUI.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.settings;

import java.awt.Color;

import javax.vecmath.Color3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.primitiveguis.ColorButton;

/**
 * "F"GUI; "ColorButton"ȂNX𗘗p.
 * 
 * @author
 */
public class ColorConfigGUI extends ColorButton implements PropConfigGUI {
    private Logger logger = Logger.getLogger(ColorConfigGUI.class.getName());
    private GlobalProperties properties;
    private String key;

    /** Creates a new instance of ColorConfigGUI */
    public ColorConfigGUI(String text, String key, GlobalProperties properties) {
        super(text);
        this.key = key;
        this.properties = properties;
        init();
    }

    private void init() {
        load();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        save();
    }

    public void save() {
        if (properties == null)
            return;
        Color3f c3f = getColor3f();
        String val = String.valueOf(c3f.x) + "," + String.valueOf(c3f.y) + ","
                + String.valueOf(c3f.z);
        properties.setProperty(key, val);
    }

    public void load() {
        String foo = properties.getProperty(key);
        try {
            String[] col = foo.split(",");
            setColorf(Float.parseFloat(col[0].trim()),
                    Float.parseFloat(col[1].trim()),
                    Float.parseFloat(col[2].trim()));
        } catch (Exception exc) {
        }
    }

}
