/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/19, 13:46
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptEditorGUI.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting.scripteditor;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.scripting.ScriptDescriptionPanel;
import ciss.phase_viewer.scripting.ScriptUtils;

/**
 * ̌`beanshellXNvg, GUIʂĕҏWł.
 * 
 * @author
 */
public class ScriptEditorGUI extends InternalFrameChase {
    private Logger logger = Logger.getLogger(ScriptEditor.class.getName());

    private ScriptEditorCaller parentFrame;

    private String script;

    private InputInterface inputInterface;

    private ScriptDescriptionPanel descriptionPanel;

    /**
     * scriptҏWpGUI쐬
     * 
     * @param ScriptEditorCaller
     *            parentFrame GUǏĂяo.
     */
    public ScriptEditorGUI(ScriptEditorCaller parentFrame) {
        super(new File(parentFrame.getScriptPath()).getName(), true, true,
                true, true, new Dimension(550, 550));
        this.script = parentFrame.getScriptPath();
        this.parentFrame = parentFrame;
        init();
    }

    private void init() {
        inputInterface = ScriptUtils.getInputInterfaceFrom(script);
        if (inputInterface == null) {
            return;
        }
        createGUI();
        revalidate();
    }

    private JTabbedPane tabbedPane;

    private ScriptEditorPanel editorPanel;

    private void createGUI() {
        Container container = getContentPane();
        tabbedPane = new JTabbedPane();
        tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
        container.setLayout(new BoxLayout(container, BoxLayout.Y_AXIS));
        container.add(createButtons());
        editorPanel = new ScriptEditorPanel(parentFrame);
        container.add(editorPanel);
    }

    private JPanel createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel panelsub = new JPanel();
        panelsub.setLayout(new BoxLayout(panelsub, BoxLayout.X_AXIS));
        JButton save = new JButton(Resources.getIcon(Resources.SAVE16));
        save.setToolTipText("save to " + inputInterface.getFileName());
        JButton close = new JButton(Resources.getIcon(Resources.EXIT16));
        close.setToolTipText("close");

        save.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                editorPanel.save();
            }
        });

        close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        panelsub.add(save);
        panelsub.add(close);

        panel.add(panelsub, BorderLayout.WEST);
        return panel;
    }
}
