/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : TeXTokenMarker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.pub.jeditsyntax;

import javax.swing.text.Segment;

/**
 * TeX token marker.
 * 
 * @author Slava Pestov
 * @version $Id: TeXTokenMarker.java,v 1.16 1999/12/13 03:40:30 sp Exp $
 */
public class TeXTokenMarker extends TokenMarker {
    // public members
    public static final byte BDFORMULA = Token.INTERNAL_FIRST;
    public static final byte EDFORMULA = (byte) (Token.INTERNAL_FIRST + 1);

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;
        int lastOffset = offset;
        int length = line.count + offset;
        boolean backslash = false;
        loop: for (int i = offset; i < length; i++) {
            int i1 = (i + 1);

            char c = array[i];
            // if a backslash is followed immediately
            // by a non-alpha character, the command at
            // the non-alpha char. If we have a backslash,
            // some text, and then a non-alpha char,
            // the command ends before the non-alpha char.
            if (Character.isLetter(c)) {
                backslash = false;
            } else {
                if (backslash) {
                    // \<non alpha>
                    // we skip over this character,
                    // hence the `continue'
                    backslash = false;
                    if (token == Token.KEYWORD2 || token == EDFORMULA)
                        token = Token.KEYWORD2;
                    addToken(i1 - lastOffset, token);
                    lastOffset = i1;
                    if (token == Token.KEYWORD1)
                        token = Token.NULL;
                    continue;
                } else {
                    // \blah<non alpha>
                    // we leave the character in
                    // the stream, and it's not
                    // part of the command token
                    if (token == BDFORMULA || token == EDFORMULA)
                        token = Token.KEYWORD2;
                    addToken(i - lastOffset, token);
                    if (token == Token.KEYWORD1)
                        token = Token.NULL;
                    lastOffset = i;
                }
            }
            switch (c) {
            case '%':
                if (backslash) {
                    backslash = false;
                    break;
                }
                addToken(i - lastOffset, token);
                addToken(length - i, Token.COMMENT1);
                lastOffset = length;
                break loop;
            case '\\':
                backslash = true;
                if (token == Token.NULL) {
                    token = Token.KEYWORD1;
                    addToken(i - lastOffset, Token.NULL);
                    lastOffset = i;
                }
                break;
            case '$':
                backslash = false;
                if (token == Token.NULL) // singe $
                {
                    token = Token.KEYWORD2;
                    addToken(i - lastOffset, Token.NULL);
                    lastOffset = i;
                } else if (token == Token.KEYWORD1) // \...$
                {
                    token = Token.KEYWORD2;
                    addToken(i - lastOffset, Token.KEYWORD1);
                    lastOffset = i;
                } else if (token == Token.KEYWORD2) // $$aaa
                {
                    if (i - lastOffset == 1 && array[i - 1] == '$') {
                        token = BDFORMULA;
                        break;
                    }
                    token = Token.NULL;
                    addToken(i1 - lastOffset, Token.KEYWORD2);
                    lastOffset = i1;
                } else if (token == BDFORMULA) // $$aaa$
                {
                    token = EDFORMULA;
                } else if (token == EDFORMULA) // $$aaa$$
                {
                    token = Token.NULL;
                    addToken(i1 - lastOffset, Token.KEYWORD2);
                    lastOffset = i1;
                }
                break;
            }
        }
        if (lastOffset != length)
            addToken(length - lastOffset, token == BDFORMULA
                    || token == EDFORMULA ? Token.KEYWORD2 : token);
        return (token != Token.KEYWORD1 ? token : Token.NULL);
    }
}
