/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : DistanceMeasure.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.measure;

import javax.media.j3d.BranchGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.VectorOperations;

public class DistanceMeasure extends Measure {
    private static Logger logger = Logger.getLogger(DistanceMeasure.class
            .getName());

    public DistanceMeasure(Measurable measurable) {
        super(measurable);
    }

    public int getNumberOfNecessaryAtoms() {
        return 2;
    }

    private MeasureObject mobj;

    public void draw() {
        if (!validData)
            return;
        mobj = (MeasureObject) getElem();
        mobj.setAtomVector(atomVectorNow);
        bg.addMeasureObject(mobj);
    }

    private BranchGroup getElem() {
        SceneGraphElementCreator creator = measurable.getCreator();
        return creator.getSceneGraphElement(xyz[0], xyz[1], result, id);
    }

    public void calculate() {
        double distance = VectorOperations.calDist(pos_moto[0], pos_moto[1]);
        result = distance;
        if (!updating) {
            logger.info("distance between atom " + id[1] + " and " + id[0]
                    + " : " + ConstParameters.formater.format(distance) + "");
        }
    }

    protected void initUpdate() {
        updating = true;
        // bg.removeAllChildren();
    }

    public void redraw(int measureIndex, boolean valid) {
        if (!validData)
            return;
        mobj = (MeasureObject) bg.getChild(measureIndex);
        if (!valid) {
            mobj.detach();
            return;
        }
        mobj.setAtoms(new double[][] { xyz[0], xyz[1] });
        mobj.setResult(result);
        mobj.recreate();
        // bg.addMeasureObject((MeasureObject)getElem());
    }

    protected void finalizeUpdate() {
        updating = false;
    }

    public String toString() {
        return "distance";
    }

}
