/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MovieMaker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.frame;

import java.awt.Image;
import java.io.File;
import java.util.Vector;

import javax.media.MediaLocator;
import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.acviewer.ImageReciver;
import ciss.phase_viewer.acviewer.vrml.VRMLExporter;
import ciss.phase_viewer.movie.JpegImagesToMovie;
import ciss.phase_viewer.movie.MovieUtils;

public class MovieMaker implements ImageReciver {
    private static Logger logger = Logger.getLogger(MovieMaker.class.getName());
    private Animater animater;

    protected boolean jpegs = false;
    protected boolean movs = true;

    private Vector images;
    private String baseDir = System.getProperty("user.dir");

    private String movieFileName = "frame.mov";

    private int fr = 10;

    protected MovieMaker(Animater animater) {
        this.animater = animater;
        this.animater.setImageReciever(this);
    }

    protected Animater getAssociatedAnimater() {
        return this.animater;
    }

    protected void setFrameRate(int fr) {
        this.fr = fr;
    }

    protected void setAnimMode(int animMode) {
        animater.setBatchImageMode(animMode);
    }

    protected void setImagePrefix(String prefix) {
        animater.setPrefix(prefix);
    }

    protected void setMovieFileName(String movieFileName) {
        this.movieFileName = movieFileName;
    }

    protected void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        animater.setBaseDir(baseDir);
    }

    protected void createMovie() {
        new Thread(animater).start();
    }

    public void setImages(Vector images) {
        if (!movs) {
            return;
        }
        this.images = images;
        if (animater.getBatchImageMode() == Animater.JPEG) {
            runJMF();
            if (jpegs) {
                String imageFileDir = baseDir
                        + System.getProperty("file.separator") + "imagefiles";
                ciss.phase_viewer.common.Utils
                        .deleteDir(new File(imageFileDir));
            }
        } else if (animater.getBatchImageMode() == Animater.VRML) {
            concatVRMLs();
        }

    }

    private void concatVRMLs() {
        String dir = baseDir + System.getProperty("file.separator")
                + "imagefiles";
        VRMLExporter exp = new VRMLExporter();
        exp.setGzip(true);
        exp.concatVRMLFiles(new File(dir),
                new File(baseDir + System.getProperty("file.separator")
                        + movieFileName), fr);
        ciss.phase_viewer.common.Utils.deleteDir(new File(dir));
    }

    protected String getMovieFileName() {
        return baseDir + System.getProperty("file.separator") + movieFileName;
    }

    private void runJMF() {
        String image0 = (String) images.get(0);
        Image im = (new ImageIcon(image0)).getImage();
        int height = im.getHeight(null);
        int width = im.getWidth(null);
        String outputURL = "file:" + baseDir
                + System.getProperty("file.separator") + movieFileName;
        MediaLocator oml;
        if ((oml = MovieUtils.createMediaLocator(outputURL)) == null) {
            logger.error("failed to create media locator from:" + outputURL);
            return;
        }
        JpegImagesToMovie moviemaker = new JpegImagesToMovie();
        moviemaker.doIt(width, height, fr, images, oml);
    }

    protected String getBaseDir() {
        return baseDir;
    }

}
