/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/03/28 11:04:32
!  AUTHOR(S): KOGA, Junichiro
!  File : PHDOSParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

public class PHDOSParser extends OutputParser implements ProgressInfo {
    private Logger logger = Logger.getLogger(PHDOSParser.class.getName());

    private OutputData outData;

    private Vector dosVector = new Vector();

    public PHDOSParser(String fileName) {
        super(fileName);
        outData = new OutputData();
        outData.setFileName(fileName);
    }

    protected boolean parse() {
        // TODO Auto-generated method stub
        if (reader == null)
            return false;
        dosVector = new Vector();
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
        } catch (IOException ioe) {
        } finally {
            try {
                reader.close();
            } catch (IOException ioe) {
            }
        }

        String[][] d2d = new String[dosVector.size()][];
        dosVector.copyInto(d2d);
        outData.setData2D(d2d);
        addOutputData(outData);

        return true;
    }

    private void parseLine(String line) {
        String[] ar = line.split("\\s+");
        if (line.startsWith("#")) {
            String[] idents = new String[ar.length - 2];
            for (int i = 2; i < ar.length; i++)
                idents[i - 2] = ar[i].toString();
            outData.setIdentifier(idents);
        } else {
            String[] tmp = new String[ar.length - 1];
            for (int i = 1; i < ar.length; i++)
                tmp[i - 1] = ar[i];
            dosVector.add(tmp);
        }
    }

    public String getCurrentMessage() {
        // TODO Auto-generated method stub
        return null;
    }
}
