/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 13:29
!  AUTHOR(S): KOGA, Junichiro
!  File : PrintoutLevelPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class PrintoutLevelPanel extends ProjectManipulator {
    private Logger logger = Logger
            .getLogger(PrintoutLevelPanel.class.getName());

    /** Creates a new instance of PrintoutLevelPanel */
    public PrintoutLevelPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new PrintoutLevelPanelPanel(projectInfo.getInputInterface()),
                BorderLayout.NORTH);
        // setLayout(new GridBagLayout());
        // GridBagConstraints constraints = new GridBagConstraints();
        // constraints.fill = GridBagConstraints.HORIZONTAL;
        // constraints.gridx = 0;
        // constraints.gridy = 0;
        // constraints.weightx = 1.0;
        // constraints.weighty = 1.0;
        // constraints.anchor = GridBagConstraints.NORTH;
        //
        // JScrollPane scr = new JScrollPane();
        // scr.getViewport().setView(new
        // PrintoutLevelPanelPanel(projectInfo.getInputInterface()));
        // add(scr,constraints);
    }

    public void initializeProject() {
    }

}

class PrintoutLevelPanelPanel extends PhaseInputItems {
    protected PrintoutLevelPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        JPanel p_ipri = this;
        p_ipri.setLayout(new GridLayout(6, 3, 1, 1));

        String[] choices = { NO_SELECTION, "0", "1", "2" };

        String[] ipribase = { "printoutlevel.base", "printlevel.base" };
        String[] ipripulay = { "printoutlevel.pulay", "printlevel.pulay" };
        String[] ipritiming = { "printoutlevel.timing", "printlevel.timing" };
        String[] iprisolver = { "printoutlevel.solver", "printlevel.solver" };
        String[] iprievdff = { "printoutlevel.evdff", "printlevel.evdff" };
        String[] iprirmm = { "printoutlevel.rmm", "printlevel.rmm" };
        String[] iprisnl = { "printoutlevel.snl", "printlevel.snl" };
        String[] iprigdiis = { "printoutlevel.gdiis", "printlevel.gdiis" };
        String[] iprieigenvalue = { "printoutlevel.eigenvalue",
                "printlevel.eigenvalue" };
        String[] iprispg = { "printoutlevel.spg", "printlevel.spg" };
        String[] iprikp = { "printoutlevel.kp", "printlevel.kp" };
        String[] iprimatdiagon = { "printoutlevel.matdiagon",
                "printlevel.matdiagon" };
        String[] iprivlhxcq = { "printoutlevel.vlhxcq", "printlevel.vlhxcq" };
        String[] ipritotalcharge = { "printoutlevel.totalcharge",
                "printlevel.totalcharge" };
        String[] iprisubmat = { "printoutlevel.submat", "printlevel.submat" };
        String[] ipristrcfctr = { "printoutlevel.strcfctr",
                "printlevel.strcfctr" };
        String[] ipriparallel = { "printoutlevel.parallel",
                "printlevel.parallel" };
        String[] ipriinput_file = { "printoutlevel.input_file",
                "printlevel.input_file" };

        ChoicePanelPhase p_ipri_base = new ChoicePanelPhase(ipribase,
                inputInterface, "base", choices, this);
        ChoicePanelPhase p_ipri_pulay = new ChoicePanelPhase(ipripulay,
                inputInterface, "pulay", choices, this);
        ChoicePanelPhase p_ipri_timing = new ChoicePanelPhase(ipritiming,
                inputInterface, "timing", choices, this);
        ChoicePanelPhase p_ipri_solver = new ChoicePanelPhase(iprisolver,
                inputInterface, "solver", choices, this);
        ChoicePanelPhase p_ipri_evdff = new ChoicePanelPhase(iprievdff,
                inputInterface, "evdff", choices, this);
        ChoicePanelPhase p_ipri_rmm = new ChoicePanelPhase(iprirmm,
                inputInterface, "rmm", choices, this);
        ChoicePanelPhase p_ipri_snl = new ChoicePanelPhase(iprisnl,
                inputInterface, "snl", choices, this);
        ChoicePanelPhase p_ipri_gdiis = new ChoicePanelPhase(iprigdiis,
                inputInterface, "gdiis", choices, this);
        ChoicePanelPhase p_ipri_eigenvalue = new ChoicePanelPhase(
                iprieigenvalue, inputInterface, "eigenvalue", choices, this);
        ChoicePanelPhase p_ipri_spg = new ChoicePanelPhase(iprispg,
                inputInterface, "spg", choices, this);
        ChoicePanelPhase p_ipri_kp = new ChoicePanelPhase(iprikp,
                inputInterface, "kp", choices, this);
        ChoicePanelPhase p_ipri_matdiagon = new ChoicePanelPhase(iprimatdiagon,
                inputInterface, "matdiagon", choices, this);
        ChoicePanelPhase p_ipri_vlhxcq = new ChoicePanelPhase(iprivlhxcq,
                inputInterface, "vlhxcq", choices, this);
        ChoicePanelPhase p_ipri_totalcharge = new ChoicePanelPhase(
                ipritotalcharge, inputInterface, "totalcharge", choices, this);
        ChoicePanelPhase p_ipri_submat = new ChoicePanelPhase(iprisubmat,
                inputInterface, "submat", choices, this);
        ChoicePanelPhase p_ipri_strcfctr = new ChoicePanelPhase(ipristrcfctr,
                inputInterface, "strcfctr", choices, this);
        ChoicePanelPhase p_ipri_parallel = new ChoicePanelPhase(ipriparallel,
                inputInterface, "parallel", choices, this);
        ChoicePanelPhase p_ipri_input_file = new ChoicePanelPhase(
                ipriinput_file, inputInterface, "input_file", choices, this);

        p_ipri.add(p_ipri_base);
        p_ipri.add(p_ipri_pulay);
        p_ipri.add(p_ipri_timing);
        p_ipri.add(p_ipri_solver);
        p_ipri.add(p_ipri_evdff);
        p_ipri.add(p_ipri_rmm);
        p_ipri.add(p_ipri_snl);
        p_ipri.add(p_ipri_gdiis);
        p_ipri.add(p_ipri_eigenvalue);
        p_ipri.add(p_ipri_spg);
        p_ipri.add(p_ipri_kp);
        p_ipri.add(p_ipri_matdiagon);
        p_ipri.add(p_ipri_vlhxcq);
        p_ipri.add(p_ipri_totalcharge);
        p_ipri.add(p_ipri_submat);
        p_ipri.add(p_ipri_strcfctr);
        p_ipri.add(p_ipri_parallel);
        p_ipri.add(p_ipri_input_file);

    }

}
