/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/18, 17:19
!  AUTHOR(S): KOGA, Junichiro
!  File : BGColorAttributes.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.graph.plotattributes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;
import org.jfree.chart.plot.Plot;

import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;

/**
 * Ot̔wiF𑀍삷.
 * 
 * @author
 */
public class BGColorAttributes extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger(BGColorAttributes.class.getName());
    private JPanel thispanel;
    private Plot plot;

    /** Creates a new instance of BGColorAttributes */
    public BGColorAttributes(PlotAttributesEditor parent) {
        super(parent);
        thispanel = this;
    }

    protected void init() {
        if (parent == null) {
            logger.debug("'parent' is null.");
            return;
        }
        plot = parent.getSelectedPlot();
        logger.debug("plot here: " + plot);
        if (plot == null) {
            logger.debug("'plot' is null.");
            return;
        }

    }

    private JButton btnchartcolor;
    private JButton btnplotcolor;

    protected void initGUI() {
        removeAll();
        setLayout(new BorderLayout());

        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1;
        constraints.weighty = 0;

        Color chartColor = (Color) getEditor().getGraphPanel().getChart()
                .getBackgroundPaint();
        JPanel pbtncolor = new JPanel();
        if (plot == null) {
            logger.debug("plot is null.");
            return;
        }
        Color plotColor = (Color) plot.getBackgroundPaint();
        pbtncolor.setBorder(new TitledBorder("back ground color"));

        btnchartcolor = new JButton("select chart color");
        btnchartcolor.setBackground(chartColor);

        btnplotcolor = new JButton("select plot color");
        btnplotcolor.setBackground(plotColor);

        pbtncolor.add(btnchartcolor);
        pbtncolor.add(btnplotcolor);

        p.add(pbtncolor, constraints);

        add(p, BorderLayout.NORTH);

        btnchartcolor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(thispanel, "Choose",
                        btnchartcolor.getBackground());
                if (color != null) {
                    btnchartcolor.setBackground(color);
                    btnchartcolor.revalidate();
                }
            }
        });

        btnplotcolor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(thispanel, "Choose",
                        btnplotcolor.getBackground());
                if (color != null) {
                    btnplotcolor.setBackground(color);
                    btnplotcolor.revalidate();
                }
            }
        });

    }

    public boolean updateChart() {
        getEditor().getGraphPanel().getChart()
                .setBackgroundPaint(btnchartcolor.getBackground());
        plot.setBackgroundPaint(btnplotcolor.getBackground());
        return true;
    }

    public void plotChanged(Plot plot) {
        updateChart();
        init();
        initGUI();
        revalidate();
    }
}
