/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/15, 20:51
!  AUTHOR(S): KOGA, Junichiro
!  File : GlobalHotkeyManager.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.mainpanel;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

import org.apache.log4j.Logger;

public class GlobalHotkeyManager extends EventQueue {
    private Logger logger = Logger.getLogger(GlobalHotkeyManager.class
            .getName());
    private static final boolean DEBUG = false; // BUG? what's that? ;-))
    private static final GlobalHotkeyManager instance = new GlobalHotkeyManager();
    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();
    static {
        // here we register ourselves as a new link in the chain of
        // responsibility
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(instance);
    }

    private GlobalHotkeyManager() {
    } // One is enough - singleton

    public static GlobalHotkeyManager getInstance() {
        return instance;
    }

    public InputMap getInputMap() {
        return keyStrokes;
    }

    public ActionMap getActionMap() {
        return actions;
    }

    protected void dispatchEvent(AWTEvent event) {
        if (event instanceof KeyEvent) {
            // KeyStroke.getKeyStrokeForEvent converts an ordinary KeyEvent
            // to a keystroke, as stored in the InputMap. Keep in mind that
            // Numpad keystrokes are different to ordinary keys, i.e. if you
            // are listening to
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent((KeyEvent) event);
            if (DEBUG)
                System.out.println("KeyStroke=" + ks);
            String actionKey = (String) keyStrokes.get(ks);
            if (actionKey != null) {
                if (DEBUG)
                    System.out.println("ActionKey=" + actionKey);
                Action action = actions.get(actionKey);
                if (action != null && action.isEnabled()) {
                    // I'm not sure about the parameters
                    action.actionPerformed(new ActionEvent(event.getSource(),
                            event.getID(), actionKey, ((KeyEvent) event)
                                    .getModifiers()));
                    return; // consume event
                }
            }
        }
        try {
            super.dispatchEvent(event); // let the next in chain handle event
        } catch (Exception exc) {
            logger.debug("'dispatchEvent' failed");
            Chase.updateUI();
            // exc.printStackTrace();
        }
    }
}
