/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/27, 14:16
!  AUTHOR(S): KOGA, Junichiro
!  File : UndoRedoEvent.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.inputinterface;

/**
 * Undo/RedoɊւCxg.
 * 
 * @author
 */
public class UndoRedoEvent {
    public static int UNDO = 0;
    public static int REDO = 1;
    public static int STACK_UPDATE = 2;

    private int state = UNDO;
    private InputInterface inputInterface;
    private int undoStackCount;
    private int redoStackCount;
    private InputInterfaceEntry entry;

    /**
     * Creates a new instance of UndoRedoEvent
     * 
     * @param state
     *            ̃Cxg̏Ԃw肷. UNDO, REDO, STACK_UPDATÊꂩw肷邱.
     * @param inputInterface
     *            Undo/RedoɊ֘AtꂽInputInterfaceIuWFNg
     * @param undoStackCount
     *            UndoX^bN̗vf.
     * @param redoStackCount
     *            RedoX^bN̗vf.
     */
    public UndoRedoEvent(int state, InputInterface inputInterface,
            int undoStackCount, int redoStackCount) {
        this.state = state;
        this.inputInterface = inputInterface;
        this.undoStackCount = undoStackCount;
        this.redoStackCount = redoStackCount;
    }

    /**
     * Creates a new instance of UndoRedoEvent
     * 
     * @param state
     *            ̃Cxg̏Ԃw肷. UNDO, REDO, STACK_UPDATÊꂩw肷邱.
     * @param inputInterface
     *            Undo/RedoɊ֘AtꂽInputInterfaceIuWFNg
     * @param undoStackCount
     *            UndoX^bN̗vf.
     * @param redoStackCount
     *            RedoX^bN̗vf.
     * @param entry
     *            ĂяoInputInterfaceEntryIuWFNg.
     */
    public UndoRedoEvent(int state, InputInterface inputInterface,
            int undoStackCount, int redoStackCount, InputInterfaceEntry entry) {
        this.state = state;
        this.inputInterface = inputInterface;
        this.undoStackCount = undoStackCount;
        this.redoStackCount = redoStackCount;
        this.entry = entry;
    }

    /**
     * ̃Cxg𔭐InputInterfaceEntryIuWFNgւ̎QƂԂ.
     * 
     * @return ̃Cxǧ.
     */
    public InputInterfaceEntry getSource() {
        return this.entry;
    }

    /**
     * ̃CxgUndôRedô, 邢͒PɃX^bNXV̂Ԃ.
     * 
     * @return UNDOȂundo, REDOȂredo, STACK_UPDATEȂX^bN̍XV.
     */
    public int getState() {
        return state;
    }

    /**
     * Undo/RedoɂĕύX{ꂽInputInterfaceIuWFNgԂ.
     * 
     * @return ύX{ꂽInputInterfaceIuWFNg
     */
    public InputInterface getInputInterface() {
        return this.inputInterface;
    }

    /**
     * UndoX^bN̗vfԂ.
     * 
     * @return undoX^bN̗vf.
     */
    public int getUndoStackCount() {
        return this.undoStackCount;
    }

    /**
     * RedoX^bN̗vfԂ.
     * 
     * @return redoX^bN̗vf.
     */
    public int getRedoStackCount() {
        return this.redoStackCount;
    }

}
