/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/16, 18:50
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceEntryChangeEvent.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.inputinterface;

/**
 * InputInterfacereplace\bhsCxgIuWFNg.
 * 
 * @author
 */
public class InputInterfaceEntryChangeEvent {

    private InputInterfaceEntry entry;
    private InputInterfaceBlock block;

    private String tag;
    private InputInterfaceEntryChangeListener source;
    private InputInterface inputInterface;

    /**
     * Creates a new instance of InputInterfaceEntryChangeEvent
     * 
     * @param tag
     *            ǂ̃Gg[ύXꂽw肷鎯ʎq.
     * @param entry
     *            InputInterfaceEntryIuWFNg
     * @param source
     *            ĂяoInputInterfaceEntryChangeListener
     * @param inputInterface
     *            entry܂InputInterfaceIuWFNg.
     */
    public InputInterfaceEntryChangeEvent(String tag,
            InputInterfaceEntry entry,
            InputInterfaceEntryChangeListener source,
            InputInterface inputInterface) {
        this.entry = entry;
        this.tag = tag;
        this.source = source;
        this.inputInterface = inputInterface;
    }

    /**
     * Creates a new instance of InputInterfaceEntryChangeEvent
     * 
     * @param tag
     *            ǂ̃Gg[ύXꂽw肷鎯ʎq.
     * @param entry
     *            InputInterfaceEntryIuWFNg
     * @param source
     *            ĂяoInputInterfaceEntryChangeListener
     * @param inputInterface
     *            entry܂InputInterfaceIuWFNg.
     */
    public InputInterfaceEntryChangeEvent(String tag,
            InputInterfaceBlock block,
            InputInterfaceEntryChangeListener source,
            InputInterface inputInterface) {
        this.block = block;
        this.tag = tag;
        this.source = source;
        this.inputInterface = inputInterface;
    }

    public InputInterfaceEntry getEntry() {
        return this.entry;
    }

    public InputInterfaceBlock getBlock() {
        return this.block;
    }

    public InputInterfaceEntryChangeListener getSource() {
        return this.source;
    }

    public String getTag() {
        return this.tag;
    }

    public InputInterface getInputInterface() {
        return this.inputInterface;
    }

}
