/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/30 17:32:35
!  AUTHOR(S): KOGA, Junichiro
!  File : InputWizardScript.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.input;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;

import javax.swing.JPanel;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorPanel;

/**
 * BSHScriptpInputWizard... KɃI[o[Chėp.
 * 
 * @author KOGA, Junichiro
 * 
 */
public abstract class InputWizardScript implements InputWizard,
        ScriptEditorCaller {
    private Logger logger = Logger.getLogger(InputWizardScript.class.getName());

    private ScriptEditorPanel panel;

    protected String FS = System.getProperty("file.separator");

    protected String phaseJobControl = System.getProperty("user.home") + FS
            + ".phase-viewer" + FS + "scripts" + FS + "jobcontrol" + FS
            + "phase";

    public JPanel getGUI() {
        panel = new ScriptEditorPanel(this, false, false);
        return panel;
    }

    /**
     * pXNvg̖OԂ. ꍇ\̂Ŕz. BSHXNvgł ꉞ.
     * 
     * @return pXNvg̖O
     */
    protected abstract String[] getScripts();

    /**
     * pXNvg̃\[X̂fBNg[. pXNvg, ׂēʓfBNg[ɂȂƂȂƂɂ.
     * 
     * @return pXNvg̃\[X̂fBNg[.
     */
    protected abstract String getScriptDir();

    public String process() {
        String[] scrs = getScripts();
        for (int i = 0; i < scrs.length; i++)
            ScriptUtils.copyNecessaryFiles(
                    projDir + System.getProperty("file.separator") + scrs[i],
                    projDir);

        panel.save();
        doChaseXML();
        return "done initialization of " + getScriptPath();
    }

    public String getName() {
        return "script input";
    }

    public String getDescription() {
        return "configure script input";
    }

    protected String projDir;

    protected String chaseXML;

    protected Input input;

    public void setInput(Input input) {
        this.input = input;
        projDir = new File(input.getFileName()).getParent();
        this.chaseXML = projDir + FS + "phase-viewer.xml";
        String[] scripts = getScripts();
        String scriptDir = getScriptDir();
        try {
            for (int i = 0; i < scripts.length; i++) {
                ExternalProgramExecuter.copyBinary(scriptDir + FS + scripts[i],
                        projDir + FS + scripts[i]);
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected InputWizardController parent;
    protected ProjectInfo projectInfo;

    public void setParent(InputWizardController parent) {
        this.parent = parent;
        this.projectInfo = parent.getProjectInfo();
    }

    public void setProperties(HashMap properties) {
    }

    protected void doChaseXML() {
        Document document = this.projectInfo.getProjectPropertyDocument();
        Element rootElement = document.getRootElement();
        Element jobcontrol = rootElement.getChild("jobcontrol");
        if (jobcontrol == null) {
            jobcontrol = new Element("jobcontrol");
            rootElement.addContent(jobcontrol);
        }
        Element script = jobcontrol.getChild("script");
        if (script == null) {
            script = new Element("script");
            jobcontrol.addContent(script);
        }
        Element scrtype = new Element("script_type");
        scrtype.setText("bsh");
        Element exec = new Element("exec");
        script.addContent(scrtype);
        script.addContent(exec);
        String execpath = MyElement.encode(projDir + FS + "script_exec.bsh");
        exec.addContent(new Element("bsh").addContent(new Element(
                "script_exec_script").setText(execpath)));

        String[] scripts = getScripts();
        for (int i = 0; i < scripts.length; i++) {
            Element exec_script = new Element("exec_script")
                    .addContent(new Element("script_type").setText("bsh"));
            exec_script.addContent(new Element("script_path")
                    .setText(scripts[i]));
            exec.addContent(exec_script);
        }

        parent.getProjectInfo().saveProjectPropertyDocument();
    }

    public boolean hasFinished() {
        return true;
    }

    public boolean hasNext() {
        return true;
    }

    public boolean hasPrevious() {
        return true;
    }

    public HashMap getObjects() {
        return null;
    }
}
