/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : FixedImageViewer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.imageviewer;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import ciss.phase_viewer.mainpanel.InternalFrameChase;

public class FixedImageViewer extends InternalFrameChase {

    private String fileName = new String();

    private int geta = 80;

    private final class MyListener extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            dispose();
        }
    }

    /**
     * t@CZbg, 摜t@Czpl𐶐.
     * 
     * @param fileName
     *            \摜t@C̃t@C.
     */
    public FixedImageViewer(String fileName) {
        this.fileName = fileName;
        this.createMainPanel();
    }

    /**
     * t@CZbg, 摜t@Czpl𐶐. ^Cg݂̃pl쐬.
     * 
     * @param fileName
     *            \摜t@C̃t@C.
     * @param title
     *            plɕ\^Cg.
     */
    public FixedImageViewer(String fileName, String title) {
        super(title);
        this.fileName = fileName;
        this.createMainPanel();
    }

    private void createMainPanel() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));
        JPanel panel;
        if ((panel = createImagePanel()) != null) {
            cont.add(panel);
        } else {
            System.out.println("unsupported image");
        }
        cont.add(createButtonPanel());
    }

    private JPanel createImagePanel() {
        JPanel pimage = new JPanel();
        pimage.setLayout(new FlowLayout(FlowLayout.CENTER));
        BufferedImage bi;

        try {
            int width, height;
            bi = ImageIO.read(new File(fileName));
            width = (int) (bi.getWidth());
            height = (int) (bi.getHeight()) + geta;
            GraphicsPanel graphics = new GraphicsPanel(bi);
            this.setSize(width, height);
            this.setResizable(false);
            pimage.add(graphics);
        } catch (Exception exc) {
            System.out.println(fileName + " : unsupported");
        }

        return pimage;
    }

    private JPanel createButtonPanel() {
        JPanel pbtn = new JPanel();

        JButton btnclose = new JButton("close");
        pbtn.add(btnclose);

        btnclose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        return pbtn;
    }

}
