/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/22, 20:16
!  AUTHOR(S): KOGA, Junichiro
!  File : SubPlotProperties.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.dataset;

import org.apache.log4j.Logger;

/**
 * 
 * @author
 */
public class SubPlotProperties {
    private Logger logger = Logger.getLogger(SubPlotProperties.class.getName());
    private DataSetCollection collection;
    private int weight = 1;

    public static int NO_MULTIPLE_AXIS = 0;
    public static int MULTIPLE_AXIS_Y = 1;
    public static int MULTIPLE_AXIS_X = 2;

    private int multipleplot = NO_MULTIPLE_AXIS;

    /**
     * the default constructor
     */
    public SubPlotProperties() {
    }

    /**
     * Creates a new instance of SubPlotProperties
     * 
     * @param collection
     *            collection of data for the subplot.
     */
    public SubPlotProperties(DataSetCollection collection) {
        this.collection = collection;
    }

    /**
     * @param collection
     *            collection of data for the subplot.
     * @param weight
     *            the 'weight' parameter for this subplot
     */
    public SubPlotProperties(DataSetCollection collection, int weight) {
        this.collection = collection;
        this.weight = weight;
    }

    public void setMultipleAxisType(int multipleplot) {
        this.multipleplot = multipleplot;
    }

    public void setDataSetCollection(DataSetCollection collection) {
        this.collection = collection;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public DataSetCollection getDataSetCollection() {
        return collection;
    }

    public int getWeight() {
        return weight;
    }

    public int getMultipleAxisType() {
        return multipleplot;
    }

}
