/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : OldOutputParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;

public abstract class OldOutputParser {

    public final static String CR = System.getProperty("line.separator") /*
                                                                          * !<
                                                                          * sR[h
                                                                          */;

    /** number of columns for data */
    private int numColumns;

    /** number of rows for data */
    private int numRows;

    /** string for header info */
    private String header = new String();

    /** vector for column name */
    private Vector columnName = new Vector();

    /** vector for column data */
    private Vector dataColumn = new Vector();

    /** vector for row data (referance to dataColumn) */
    private Vector dataRow = new Vector();

    /** output filename to be parsed */
    private String filename;

    /** default constructor */
    public OldOutputParser() {
    }

    /**
     * @param filename
     *            p[Xׂt@C̃t@C.
     */
    public OldOutputParser(String filename) {
        this.filename = filename;
    }

    /**
     * p[Xt@C̃t@CZbg.
     * 
     * @param filename
     *            p[Xׂt@C̃t@C.
     */
    public void setFileName(String filename) {
        this.filename = filename;
    }

    /**
     * J̐ݒs.
     * 
     * @param numColumns
     *            J.
     */
    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    /**
     * J̎擾.
     * 
     * @return J.
     */
    public int getNumColumns() {
        return this.numColumns;
    }

    /**
     * f[^̍sݒ肷.
     * 
     * @param numRows
     *            f[^̍s.
     */
    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    /**
     * f[^̍s擾.
     * 
     * @return f[^̍s.
     */
    public int getNumRows() {
        return this.numRows;
    }

    /**
     * wb_[擾.
     * 
     * @return wb_[.
     */
    public String getHeader() {
        return this.header;
    }

    /**
     * wb_[ݒ肷. wb_[XgO, ܂邾 sR[ht킯ł͂Ȃ_ɒ.
     * 
     * @param header_str
     *            wb_[
     */
    public void addHeader(String header_str) {
        this.header = this.header + header_str;
    }

    /**
     * J̖OێVectorIuWFNg擾.
     * 
     * @return JVector
     */
    public Vector getColumnName() {
        return this.columnName;
    }

    /**
     * JxNg, VȃJ𑫂.
     * 
     * @param columnname
     *            VJ.
     */
    public void addColumnName(String columnname) {
        columnName.addElement(columnname.toString());
    }

    /**
     * sێVectorIuWFNg擾.
     * 
     * @return sxNg.
     */
    public Vector getDataRow() {
        return this.dataRow;
    }

    /**
     * ʎq̐擾.
     * 
     * @return ʎq.
     */
    public int getNumIdent() {
        return columnName.size();
    }

    /**
     * Vf[^̈ɃJ𑫂.
     * 
     * @param data_str
     *            ݂.
     */
    public void addDataColumn(String data_str) {
        this.dataColumn.addElement(data_str.toString());
    }

    /**
     * JxNgԂ. uJxNgv͈ꎞIɂ ݂ȂƂɒӂKv.
     * 
     * @return Jf[^.
     */
    protected Vector getDataColumn() {
        return this.dataColumn;
    }

    /**
     * sVector, JxNg𑫂.
     */
    public void addDataRow() {
        this.dataRow.addElement(dataColumn.clone());
        dataColumn.clear();
    }

    /**
     * w̃t@Cǂݍ, p[XĂ.
     */
    public void readFile() {
        try {
            FileReader freader = new FileReader(filename);
            BufferedReader breader = new BufferedReader(freader);
            String str = new String();
            while ((str = breader.readLine()) != null) {
                parseString(str);
            }
            freader.close();
            processData();
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed read from file " + filename);
        }
        try {
            setNumRows(dataRow.size());
        } catch (Exception e) {
            e.printStackTrace();
            setNumRows(0);
        }
    }

    /**
     * t@CǂݍݒɊesłĂ΂郁\bh. ̃\bh K؂Ɏ邱Ƃɂăt@Cp[X邱Ƃł悤ɂȂ.
     */
    public abstract void parseString(String str);

    /**
     * ̃\bh̓t@C̓ǂݍ݂IĂĂ΂. ssł͑ΉłȂp[Xڂꍇ, ̃\bh
     * ƂɂđΏł.
     */
    protected void processData() {
    }

}
