/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/21 17:08:33
!  AUTHOR(S): KOGA, Junichiro
!  File : Primitive.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.symmetry;

public class Primitive extends BravaisLattice {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(Primitive.class.getName());

    /**
     * v~eBuZp. .
     */
    public Primitive() {
        isBravais(false);
    }

    public String getCrystalSystem() {
        return "primitive";
    }

    public String[] getLatticeSystemCandidate() {
        return new String[] { "----" };
    }

    public String getName() {
        return "primitive";
    }

    public double[][] getPrimitiveLatticeVector() {
        return getGenericPrimitiveVector();
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha,
            double beta, double gamma) {
        return true;
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec,
            double[] bvec, double[] cvec) {
        return this;
    }
}
