/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/12 16:55:38
!  AUTHOR(S): KOGA, Junichiro
!  File : Monoclinic.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.symmetry;

import ciss.phase_viewer.common.ConstParameters;

public class Monoclinic extends BravaisLattice {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(Monoclinic.class.getName());

    public String getName() {
        return latticeSystem + " monoclinic";
    }

    public double[][] getPrimitiveLatticeVector() {
        if (latticeSystem.equals(BASE_CENTERED)) {
            double[] avec = { 0.5 * a, -0.5 * b, 0 };
            double[] bvec = { 0.5 * a, 0.5 * b, 0 };
            double be = beta * ConstParameters.ANG_TO_RAD;
            double[] cvec = { c * Math.cos(be), 0, c * Math.sin(be) };
            return new double[][] { avec, bvec, cvec };
        }
        return getGenericPrimitiveVector();
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha,
            double beta, double gamma) {
        boolean len = !epsilonEquals(a, b) && !epsilonEquals(b, c)
                && !epsilonEquals(a, c);
        boolean ang = epsilonEquals(alpha, 90) && !epsilonEquals(beta, 90)
                && epsilonEquals(gamma, 90);
        return len && ang;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[] { PRIMITIVE, BASE_CENTERED };
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec,
            double[] bvec, double[] cvec) {
        if (!epsilonEquals(a, b) && !epsilonEquals(b, c)
                && !epsilonEquals(a, c) && epsilonEquals(alpha, 90)
                && !epsilonEquals(beta, 90) && epsilonEquals(gamma, 90)) {
            return this;
        }

        double cosbeta = Math.cos(ConstParameters.ANG_TO_RAD * beta);
        double sinbeta = Math.sin(ConstParameters.ANG_TO_RAD * beta);
        if (epsilonEquals(cosbeta, 0) || epsilonEquals(sinbeta, 0))
            return null;

        boolean b1 = epsilonEquals(avec[0], bvec[0])
                && epsilonEquals(avec[1], -bvec[1]);
        boolean b2 = epsilonEquals(avec[2], 0) && epsilonEquals(bvec[2], 0);
        boolean b3 = !epsilonEquals(avec[0], -avec[1]);
        boolean b4 = !epsilonEquals(beta, 90);

        if (b1 && b2 && b3 && b4) {
            logger.debug("base-centered monoclinic");
            Monoclinic mono = new Monoclinic();
            mono.a = avec[0] * 2;
            mono.b = -avec[1] * 2;
            mono.c = cvec[2] / sinbeta;
            mono.alpha = 90;
            mono.gamma = 90;
            mono.beta = beta;
            mono.latticeSystem = BASE_CENTERED;
            return mono;
        }
        return null;
    }

    public String getCrystalSystem() {
        return "monoclinic";
    }

}
