/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/01, 18:12
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomStateList.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord;

import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * qzu""ێĂNX
 * 
 * @author
 */
public class AtomStateList {
    private Logger logger = Logger.getLogger(AtomStateList.class.getName());
    private Vector stateVector;

    private int origNumAt;

    /**
     * @param numAt
     *            ̎_ł̌q̐
     */
    public AtomStateList(int numAt) {
        origNumAt = numAt;
        stateVector = new Vector();
        for (int i = 0; i < numAt; i++) {
            stateVector.addElement(new AtomState(AtomState.UNCHANGED, i));
        }
    }

    /**
     * CfbNXPȏłȂꍇ, ̃RXgN^[𗘗p IWĩCfbNXw肷.
     * 
     * @param CfbNXz
     */
    public AtomStateList(int[] indeces) {
        origNumAt = indeces.length;
        stateVector = new Vector();
        for (int i = 0; i < origNumAt; i++) {
            stateVector.addElement(new AtomState(AtomState.UNCHANGED,
                    indeces[i]));
        }
    }

    private int getNumAdded() {
        int ret = 0;
        for (int i = 0; i < stateVector.size(); i++) {
            AtomState as = (AtomState) stateVector.get(i);
            if (as.mode == AtomState.ADDED)
                ret++;
        }
        return ret;
    }

    /**
     * X̃CfbNXw肷, VCfbNXԂzԂ 폜ꂽqɑΉuX̃CfbNXv̏ꍇ̐Ԃ.
     * 
     * @return L̒ʂ
     */
    public int[] getIndexMap() {
        int added = getNumAdded();
        int[] ret = new int[origNumAt + added];
        for (int i = 0; i < stateVector.size(); i++) {
            AtomState as = (AtomState) stateVector.get(i);
            if (as.mode != AtomState.REMOVED) {
                ret[as.origIndex] = as.index;
            } else {
                ret[as.origIndex] = -1;
            }
        }
        return ret;
    }

    /**
     * qǉꍇɌĂ
     */
    public void atomAdded() {
        logger.debug("atom added");
        // int index = stateVector.size()-1;
        // for ( int i=0 ; i<stateVector.size() ; i++ ) {
        // AtomState as = (AtomState) stateVector.get(i);
        // if ( as.index >= index ) as.index++;
        // }
        int natNow = getNumAt();
        stateVector.addElement(new AtomState(AtomState.ADDED, natNow));
    }

    /**
     * w̏ꏊɌqǉꍇɂ
     */
    public void atomAdded(int index) {
        logger.debug("atom added at " + index);
        for (int i = 0; i < stateVector.size(); i++) {
            AtomState as = (AtomState) stateVector.get(i);
            if (as.index >= index)
                as.index++;
        }
        stateVector.add(new AtomState(AtomState.ADDED, index));
    }

    /**
     * q폜ꍇɌĂ
     * 
     * @param removed
     *            폜q̃CfbNX
     */
    public void atomRemoved(int removed) {
        if (removed < 0 || removed >= stateVector.size())
            return;
        for (int i = 0; i < stateVector.size(); i++) {
            AtomState as = (AtomState) stateVector.get(i);
            if (as.index > removed)
                as.index--;
        }
        stateVector.set(removed, new AtomState(AtomState.REMOVED, removed));
    }

    /**
     * q̑ύXꍇɂ
     * 
     * @param mod
     *            ύXq̃CfbNX
     */
    public void atomModified(int mod) {
        if (mod < 0 || mod >= stateVector.size())
            return;
        stateVector.set(mod, new AtomState(AtomState.MODIFIED, mod));
    }

    /**
     * (݂)q̐擾
     * 
     * @return ݂̌q̐
     */
    public int getNumAt() {
        int ret = 0;
        for (int i = 0; i < stateVector.size(); i++) {
            if (((AtomState) stateVector.get(i)).mode == AtomState.REMOVED)
                continue;
            ret++;
        }
        if (ret < 0)
            ret = 0;
        return ret;
    }

    /**
     * ʂ擾; z̃CfbNXq̃CfbNX, ADDED̏ꍇ͂͑܂ꂽq, REMOVED̏ꍇ͍폜ꂽq,
     * MODIFIED̏ꍇ͕ύXꂽq, UNCHANGED̏ꍇ͂ȂɂNȂqӖ zindex̏ɂȂĂ.
     * 
     * @return ʂi[z
     */
    public AtomState[] getResults() {
        AtomState[] res = new AtomState[stateVector.size()];
        stateVector.copyInto(res);
        java.util.Arrays.sort(res);
        return res;
    }

    //
    // /**
    // * ÂCfbNXVCfbNXԂ
    // */
    // public int [] oldIndex2NewIndex() {
    // int [] ret = new int[origNumAt];
    // int count = 0;
    // for ( int i=0 ; i<stateVector.size() ; i++ ) {
    // int state = ((Integer)stateVector.get(i)).intValue();
    // if ( state == MODIFIED || state == UNCHANGED ) {
    // ret[count] = i;
    // count++;
    // } else if ( state == REMOVED ) {
    // ret[count] = -1;
    // count++;
    // }
    // }
    // return ret;
    // }
    //
    // /**
    // * VCfbNXw肷, ÂCfbNXԂz擾. XȂq(ꂽq)̏ꍇ-1𓾂
    // * @return L̒ʂ
    // */
    // public int [] getIndexMap() {
    // Vector vec = new Vector();
    // int count=0;
    // for ( int i=0 ; i<stateVector.size() ; i++ ) {
    // int state = ((Integer)stateVector.get(i)).intValue();
    // if ( state != ADDED ) {
    // vec.addElement(new Integer(count));
    // count++;
    // } else {
    // vec.addElement(new Integer(-1));
    // }
    // }
    //
    // Integer [] inte = new Integer[vec.size()];
    // vec.copyInto(inte);
    // int [] ret = new int[inte.length];
    // for ( int i=0 ; i<inte.length ; i++ ) {
    // ret[i] = inte[i].intValue();
    // }
    //
    // return ret;
    // }
    //
    // /**
    // * q̃CfbNX擾 ɕԂ悤ɂȂĂ
    // * @return L̒ʂ
    // */
    // public int [] getIndecesOfAddedAtoms() {
    // Vector vec = new Vector();
    //
    // for ( int i=0 ; i<stateVector.size() ; i++ ) {
    // int state = ((Integer)stateVector.get(i)).intValue();
    // if ( state == ADDED ) {
    // vec.addElement(new Integer(i));
    // }
    // }
    //
    // Integer [] inte = new Integer[vec.size()];
    // vec.copyInto(inte);
    // int [] ret = new int[inte.length];
    // for ( int i=0 ; i<inte.length ; i++ ) {
    // ret[i] = inte[i].intValue();
    // }
    //
    // Arrays.sort(ret);
    //
    // return ret;
    // }
    //
    // /**
    // * 폜ꂽq̃CfbNX擾 ɂȂ
    // * @return L̒ʂ
    // */
    // public int [] getIndecesOfRemovedAtoms() {
    // Vector vec = new Vector();
    //
    // for ( int i=0 ; i<stateVector.size() ; i++ ) {
    // int state = ((Integer)stateVector.get(i)).intValue();
    // if ( state == REMOVED ) {
    // vec.addElement(new Integer(i));
    // }
    // }
    //
    // Integer [] inte = new Integer[vec.size()];
    // vec.copyInto(inte);
    // int [] ret = new int[inte.length];
    // for ( int i=0 ; i<inte.length ; i++ ) {
    // ret[i] = inte[i].intValue();
    // }
    //
    // Arrays.sort(ret);
    //
    // return ret;
    // }
    //
    /**
     * ̌q擾
     * 
     * @return ̌q
     */
    public int getOrigNumAt() {
        return this.origNumAt;
    }

}
