/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : LegendObject.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import java.awt.Font;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;

import com.sun.j3d.utils.geometry.Sphere;

class LegendObject extends SceneGraphElement {
    private static Logger logger = Logger.getLogger(LegendObject.class
            .getName());

    private int numAt = 1;
    private String[] elements;
    private String[] elementall;
    private int numEl = 100;

    private float[][] colors;
    private int numNodes = 30;

    public LegendObject() {
        super();
    }

    public int getType() {
        return SceneGraphElement.LEGEND;
    }

    public void configDataUpdate() {
        try {
            setElements(mCD.getElements());
            setNumAt(mCD.getNumAt());
            setElements(mCD.getElements());
            setNumEl(mACVD.getNumEl());
            setElementAll(mACVD.getElement());
            setColor(mACVD.getColor());
            setNumNodes(mACVD.getNumNodesAtom());

            removeAllChildren();
            create();
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
        configDataUpdate();
    }

    public boolean needsUpdate() {
        return true;
    }

    public void create() {
        if (numAt == 0)
            return;
        String[] DistinctElement = new String[numAt];
        int[] DistinctElementIndex = new int[numAt];
        int i;
        int k, iDistinct;
        float shift = 0.15f;
        boolean bdistinct = true;
        k = 0;
        iDistinct = 0;

        for (i = 0; i < numAt; i++) {
            DistinctElement[i] = "";
            DistinctElementIndex[i] = 0;
        }

        DistinctElement[0] = elements[0];
        DistinctElementIndex[0] = 0;
        iDistinct = 1;

        // set distinct element
        for (i = 1; i < numAt; i++) {
            bdistinct = true;
            for (k = 0; k < iDistinct; k++) {
                if (DistinctElement[k].equals(elements[i])) {
                    bdistinct = false;
                }
            }
            if (bdistinct) {
                DistinctElement[iDistinct] = elements[i];
                iDistinct++;
            }
        }

        // determine symbol for each distinct element
        for (i = 0; i < iDistinct; i++) {
            for (k = 0; k < numEl; k++) {
                if (elementall[k].equals(DistinctElement[i])) {
                    DistinctElementIndex[i] = k;
                }
            }
        }

        float[] color_wk = new float[3];
        for (i = 0; i < iDistinct; i++) {
            for (k = 0; k < 3; k++) {
                color_wk[k] = colors[DistinctElementIndex[i]][k];
            }
            logger.debug("color for legend no. " + i + ": " + color_wk[0] + " "
                    + color_wk[1] + " " + color_wk[2]);

            Appearance app = new Appearance();
            RenderingAttributes ra = new RenderingAttributes();
            ra.setIgnoreVertexColors(true);
            app.setRenderingAttributes(ra);
            Material material = new Material();

            material.setDiffuseColor(new Color3f(color_wk));
            material.setShininess(120.0f);
            app.setMaterial(material);

            Color3f fontColor = mACVD.getFontColor();
            Font font = mACVD.getFont();
            CapableText2D text2D = new CapableText2D(
                    ("   " + DistinctElement[i]), fontColor, font.getName(),
                    font.getSize(), font.getStyle());

            // Text3D t3D = new Text3D(new Font3D(new
            // Font("TimesRoman",Font.PLAIN,18),new
            // FontExtrusion()),"   "+DistinctElement[i],new
            // Point3f(-0.93f,0.8f-(float)i*shift,0.0f));

            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(-0.93f, 0.8f - (float) i * shift, 0.0f));
            translate.setScale(1.d);
            TransformGroup tfgl = new TransformGroup(translate);
            tfgl.addChild(text2D);
            // Shape3D st3d = new Shape3D();
            // st3d.setGeometry(t3D);
            // // st3d.setAppearance(app);
            // tfgl.addChild(st3d);
            BranchGroup tmpbg = new BranchGroup();
            tmpbg.setCapability(BranchGroup.ALLOW_DETACH);
            tmpbg.addChild(tfgl);
            this.addChild(tmpbg);
            // this.addChild(st3d);

            Transform3D translateat = new Transform3D();
            translateat.set(new Vector3f(-0.93f, 0.84f - (float) i * shift,
                    0.0f));
            translateat.setScale(1.d);
            Sphere sphere1 = new Sphere(0.04f, Sphere.GENERATE_NORMALS,
                    numNodes, app);
            TransformGroup tfg = new TransformGroup(translateat);
            tfg.addChild(sphere1);

            BranchGroup bg = new BranchGroup();
            bg.setCapability(BranchGroup.ALLOW_DETACH);
            bg.addChild(tfg);
            this.addChild(bg);

            logger.debug("finished creating legend no. " + i);
        }
    }

    protected void setNumAt(int numAt) {
        this.numAt = numAt;
    }

    protected void setElements(String[] elements) {
        this.elements = elements;
    }

    protected void setElementAll(String[] elementall) {
        this.elementall = elementall;
    }

    protected void setNumEl(int numEl) {
        this.numEl = numEl;
    }

    protected void setColor(float[][] colors) {
        this.colors = colors;
    }

    protected void setNumNodes(int numNodes) {
        logger.debug("numNodes: " + numNodes);
        this.numNodes = numNodes;
    }

}
