/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/17, 15:20
!  AUTHOR(S): KOGA, Junichiro
!  File : MeasureBranchGroup.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.measure;

import java.util.Vector;

import javax.media.j3d.BranchGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;

/**
 * MeasureIuWFNgpBranchGroup. ؂蕪̂߂݂̗̂p.
 * 
 * @author
 */
public class MeasureBranchGroup extends BranchGroup {
    private Logger logger = Logger
            .getLogger(MeasureBranchGroup.class.getName());

    /** Creates a new instance of MeasureBranchGroup */
    public MeasureBranchGroup() {
        super();
        setCapability(BranchGroup.ALLOW_DETACH);
        setCapability(BranchGroup.ALLOW_CHILDREN_READ);
    }

    private Vector mobjs;

    public void addMeasureObject(MeasureObject mobj) {
        super.addChild(mobj);
        if (mobjs == null)
            mobjs = new Vector();
        mobjs.add(mobj);
    }

    public void removeMeasureObject(MeasureObject mobj) {
        mobj.detach();
        mobjs.removeElement(mobj);
    }

    public int getNumMeasureObjects() {
        return numChildren();
    }
}
