/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/21, 14:11
!  AUTHOR(S): KOGA, Junichiro
!  File : FBZUtils.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import java.text.DecimalFormat;

import org.apache.log4j.Logger;

/**
 * ֗?ȃ\bh`.
 * 
 * @author
 */
public class FBZUtils {
    private Logger logger = Logger.getLogger(FBZUtils.class.getName());

    /** Creates a new instance of FBZUtils */
    public FBZUtils() {
    }

    /**
     * ̎uv. 0.333..1/3, 0.666..2/3ɂȂ.
     * 
     * @return uv; 1vf: , 2vf: q, 3vf:  Ƃ1.5Ȃ {1,1,2}Ԃ.
     *         ͑vfvf.
     */
    public static int[] getBunsu(float val) {
        DecimalFormat form = new DecimalFormat("0.000");
        val = Float.parseFloat(form.format(val));
        if (val == 0) {
            return new int[] { 0, 0, 1 };
        }
        int intval = (int) val;
        int deci = (int) ((val - intval) * 1000f);

        if (deci == 0) {
            return new int[] { intval, 0, 1 };
        } else if (Math.abs(deci) == 333) {
            return new int[] { intval, sign(deci) * 1, 3 };
        } else if (Math.abs(deci) == 667) {
            return new int[] { intval, sign(deci) * 2, 3 };
        } else if (Math.abs(deci) == 111) {
            return new int[] { intval, sign(deci) * 1, 9 };
        } else if (Math.abs(deci) == 222) {
            return new int[] { intval, sign(deci) * 2, 9 };
        } else if (Math.abs(deci) == 444) {
            return new int[] { intval, sign(deci) * 4, 9 };
        } else if (Math.abs(deci) == 556) {
            return new int[] { intval, sign(deci) * 5, 9 };
        } else if (Math.abs(deci) == 778) {
            return new int[] { intval, sign(deci) * 7, 9 };
        } else if (Math.abs(deci) == 889) {
            return new int[] { intval, sign(deci) * 8, 9 };
        }

        int gcd = gcd(1000, deci);

        int denom = 1000 / gcd;
        int nume = sign(denom) * deci / gcd;
        return new int[] { intval, nume, Math.abs(denom) };
    }

    private static int sign(int val) {
        if (val == 0) {
            return 1;
        }
        return val / (Math.abs(val));
    }

    /**
     * [Nbhݏ@ōő񐔂߂
     * 
     * @param m
     *            ߂̐
     * @param n
     *            ڂ̐
     * @return ő
     */
    public static int gcd(int m, int n) {
        int t = 0;
        while (n != 0) {
            t = m % n;
            m = n;
            n = t;
        }
        return m;
    }

    /**
     * ŏ{߂
     * 
     * @param m
     *            ڂ̐
     * @param n
     *            ڂ̐
     * @return ŏ{
     */
    public static int lcm(int m, int n) {
        return m * n / gcd(m, n);
    }

}
