/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/02, 16:18
!  AUTHOR(S): KOGA, Junichiro
!  File : FBZTransform.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.atomcoord.VolumetricData;

/**
 * FBZpTransformGroup
 * 
 * @author
 */
public class FBZTransform extends ChaseTransformGroup {
    private Logger logger = Logger.getLogger(FBZTransform.class.getName());
    private FBZ fbz;

    /** Creates a new instance of FBZTransform */
    public FBZTransform(FBZ fbz) {
        this.fbz = fbz;
    }

    public float[][] getEffectiveBounds() {
        float[][] rl = fbz.getReciprocalLatticeVector();
        float[][] ret = new float[3][3];
        VolumetricData[] data = fbz.getAssociatedVolumetricData();
        if (data == null || data.length == 0)
            return null;
        float[] orig = data[0].getOrigin();
        for (int i = 0; i < 3; i++)
            for (int j = 0; j < 3; j++)
                ret[i][j] = rl[i][j] * 0.5f + orig[j];
        return ret;
    }

}
