/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/29, 14:49
!  AUTHOR(S): KOGA, Junichiro
!  File : ColorMap.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.colormap;

import java.awt.Color;

import javax.media.j3d.BranchGroup;
import javax.vecmath.Color3f;

/**
 * J[}bṽC^[tF[X
 * 
 * @author
 */
public interface ColorMap {

    /**
     * ΏۃJ[}bv̖O.
     * 
     * @return J[}bv̖O.
     */
    public String getName();

    /**
     * ̒lɕColor3f̃CX^XԂ.
     * 
     * @param value
     *            l(ʏ, 01)
     * @return valueɑΉColor3f̃IuWFNg
     */
    public Color3f getColor3f(float value);

    /**
     * ̒lɕColor3f̃CX^XԂ. J["t"ɂ邩ۂIׂ.
     * 
     * @param value
     *            l(ʏ, 01)
     * @param invert
     *            ^̏ꍇ, ʏƋt̃J[}bvɂȂ.
     * @return valueɑΉColor3f̃IuWFNg
     */
    public Color3f getColor3f(float value, boolean invert);

    /**
     * ̒lɕColor̃CX^XԂ.
     * 
     * @param value
     *            l(ʏ, 01)
     * @return valueɑΉColor̃IuWFNg
     */
    public Color getColor(float value);

    /**
     * ̒lɕColor̃CX^XԂ. J["t"ɂ邩ۂIׂ.
     * 
     * @param value
     *            l(ʏ, 01)
     * @return valueɑΉColor̃IuWFNg
     */
    public Color getColor(float value, boolean invert);

    /**
     * J[}bv"𑜓x"Ԃ.
     * 
     * @return J[}bv̉𑜓x
     */
    public int getResolution();

    /**
     * uJ[o[v쐬; Java3DBranchGroup̃CX^Xł邱Ƃ肵Ă܂.
     * 
     * @return J[o[
     */
    public BranchGroup getColorBar();

}
