/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/30, 15:28
!  AUTHOR(S): KOGA, Junichiro
!  File : ColorBarAttributesEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.colormap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * J[o[̑ҏW邽߂GUI.
 * 
 * @author
 */
public class ColorBarAttributesEditor extends InternalFrameChase {
    private Logger logger = Logger.getLogger(ColorBarAttributesEditor.class
            .getName());
    private MainPanel parent;
    private GlobalProperties gp = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    /** Creates a new instance of ColorBarAttributesEditor */
    public ColorBarAttributesEditor(MainPanel parent) {
        super("edit colorbar attributes", true, true, true, true,
                new Dimension(350, 400));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private JTextField posx;
    private JTextField posy;
    private JTextField posz;
    private JTextField height;
    private JTextField width;
    private JTextField fontSize;
    private JButton fontColor;
    private JTextField division;
    private JTextField format;

    private void init() {
        JPanel pall = new JPanel();
        pall.setLayout(new BoxLayout(pall, BoxLayout.Y_AXIS));

        JPanel pgen = new JPanel();
        pgen.setBorder(new TitledBorder("general"));
        pgen.setLayout(new BoxLayout(pgen, BoxLayout.Y_AXIS));
        JPanel ppos = new JPanel();
        ppos.setBorder(new TitledBorder("position"));
        ppos.setLayout(new BoxLayout(ppos, BoxLayout.X_AXIS));

        String x = "-0.85";
        String y = "-0.8";
        String z = "0.0";
        try {
            String[] strpos = gp.getProperty("colorbar_position").split(",");
            x = strpos[0];
            y = strpos[1];
            z = strpos[2];
        } catch (Exception exc) {
        }
        posx = new JTextField(7);
        posy = new JTextField(7);
        posz = new JTextField(7);
        posx.setText(x);
        posy.setText(y);
        posz.setText(z);
        JPanel panelx = new JPanel();
        panelx.setBorder(new TitledBorder("x"));
        panelx.add(posx);
        JPanel panely = new JPanel();
        panely.setBorder(new TitledBorder("y"));
        panely.add(posy);
        JPanel panelz = new JPanel();
        panelz.setBorder(new TitledBorder("z"));
        panelz.add(posz);
        ppos.add(panelx, BorderLayout.WEST);
        ppos.add(panely, BorderLayout.CENTER);
        ppos.add(panelz, BorderLayout.EAST);

        String strheight = "0.6";
        String strwidth = "0.1";
        strheight = gp.getProperty("colorbar_height");
        strwidth = gp.getProperty("colorbar_width");
        height = new JTextField(10);
        width = new JTextField(10);
        height.setText(strheight);
        width.setText(strwidth);
        JPanel pdim = new JPanel();
        pdim.setLayout(new BoxLayout(pdim, BoxLayout.X_AXIS));
        JPanel pheight = new JPanel();
        pheight.setBorder(new TitledBorder("height"));
        JPanel pwidth = new JPanel();
        pwidth.setBorder(new TitledBorder("width"));
        pheight.add(height);
        pwidth.add(width);
        pdim.add(pheight);
        pdim.add(pwidth);

        pgen.add(ppos);
        pgen.add(pdim);

        JPanel pscale = new JPanel();
        pscale.setLayout(new BoxLayout(pscale, BoxLayout.Y_AXIS));
        pscale.setBorder(new TitledBorder("scale"));

        JPanel pfonts = new JPanel();
        pfonts.setLayout(new BoxLayout(pfonts, BoxLayout.X_AXIS));
        String fontsize = gp.getProperty("colorbar_scale_fontsize");
        fontSize = new JTextField(7);
        fontSize.setText(fontsize);
        JPanel pfontsize = new JPanel();
        pfontsize.setBorder(new TitledBorder("font size"));
        pfontsize.add(fontSize);
        fontColor = new JButton("color");
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.6f;
        try {
            String[] strcolor = gp.getProperty("colorbar_scale_fontcolor")
                    .split(",");
            red = Float.parseFloat(strcolor[0]);
            green = Float.parseFloat(strcolor[1]);
            blue = Float.parseFloat(strcolor[2]);
            fontColor.setBackground(new Color(red, green, blue));
        } catch (Exception exc) {
        }
        JPanel pcolor = new JPanel();
        pcolor.setBorder(new TitledBorder("font color"));
        pcolor.add(fontColor);
        pfonts.add(pfontsize);
        pfonts.add(pcolor);
        pscale.add(pfonts);

        JPanel pscaleother = new JPanel();
        pscaleother.setLayout(new BoxLayout(pscaleother, BoxLayout.X_AXIS));
        division = new JTextField(7);
        String strdiv = gp.getProperty("colorbar_scale_division");
        division.setText(strdiv);
        JPanel pdivision = new JPanel();
        pdivision.setBorder(new TitledBorder("division"));
        pdivision.add(division);

        format = new JTextField(10);
        String strformat = gp.getProperty("colorbar_scale_format");
        format.setText(strformat);
        JPanel pformat = new JPanel();
        pformat.setBorder(new TitledBorder("format"));
        pformat.add(format);

        pscaleother.add(pdivision);
        pscaleother.add(pformat);
        pscale.add(pscaleother);

        pall.add(pgen);
        pall.add(pscale);

        JPanel btns = new JPanel();
        // btns.setLayout(new BoxLayout(btns,BoxLayout.X_AXIS));
        JButton save = new JButton("apply");
        JButton close = new JButton("close");
        btns.add(save);
        btns.add(close);

        Container container = getContentPane();
        container.setLayout(new BorderLayout());

        container.add(pall, BorderLayout.CENTER);
        container.add(btns, BorderLayout.SOUTH);

        save.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                if (doIt()) {
                    gp.storeProperty();
                }
                BranchGroup bg = parent.getRootBranch();
                for (int i = 0; i < bg.numChildren(); i++) {
                    if (bg.getChild(i) instanceof ColorBar) {
                        logger.info("recreating colorbar...");
                        ((ColorBar) bg.getChild(i)).recreate();
                    }
                }
            }
        });

        close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                dispose();
            }
        });

        fontColor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = fontColor.getBackground();
                Color color = JColorChooser.showDialog(parent, "Choose", col);
                if (color != null) {
                    fontColor.setBackground(color);
                }
            }
        });
    }

    private boolean doIt() {
        try {
            String strx = posx.getText().trim();
            String stry = posy.getText().trim();
            String strz = posz.getText().trim();
            Float.parseFloat(strx);
            Float.parseFloat(stry);
            Float.parseFloat(strz);

            String strheight = height.getText().trim();
            String strwidth = width.getText().trim();
            Float.parseFloat(strheight);
            Float.parseFloat(strwidth);

            String strsize = fontSize.getText().trim();
            Integer.parseInt(strsize);
            Color c = fontColor.getBackground();
            String strcolor = String.valueOf(c.getRed() / 255.f) + ","
                    + String.valueOf(c.getGreen() / 255.f) + ","
                    + String.valueOf(c.getBlue() / 255.f);

            String strdiv = division.getText().trim();
            Integer.parseInt(strdiv);
            String form = format.getText().trim();

            gp.setProperty("colorbar_position", strx + "," + stry + "," + strz);
            gp.setProperty("colorbar_height", strheight);
            gp.setProperty("colorbar_width", strwidth);
            gp.setProperty("colorbar_scale_fontsize", strsize);
            gp.setProperty("colorbar_scale_fontcolor", strcolor);
            gp.setProperty("colorbar_scale_division", strdiv);
            gp.setProperty("colorbar_scale_format", form);
        } catch (Exception exc) {
            logger.error("failed to set properties.");
            exc.printStackTrace();
            return false;
        }
        return true;
    }

}
