/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/22 18:13:03
!  AUTHOR(S): KOGA, Junichiro
!  File : J3DPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer;

import java.awt.Window;
import java.io.IOException;
import java.util.Vector;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;

import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;

import com.sun.j3d.utils.universe.SimpleUniverse;

public interface J3DPanel {

    /**
     * `悳ĂIuWFNg, [gu`擾ł
     * 
     * @return `悳ĂIuWFNg̃[gu`
     */
    public abstract BranchGroup getRootBranch();

    /**
     * vOCIuWFNg擾
     * 
     * @return vOC̏sIuWFNg
     */
    public abstract PluginParser getPluginParser();

    /**
     * HeavyWeightR|[lg
     */
    public abstract boolean isHeavyWeight();

    /**
     * `悳ĂIuWFNgɊ֘AtꂽUniverse擾
     * 
     * @return ֘AtꂽUniverse
     */
    public abstract SimpleUniverse getUniverse();

    /**
     * ̉ʂ[ォ炫ꂢɃfAP[g郁\bh (ۂɂ̓K[x[WRNV҂Kv͂)
     */
    public abstract void destroy();

    /**
     * cleanup\bȟɌĂ΂ Kvɉoverride
     */
    public abstract void postCleanUp();

    /**
     * CʂƓɕGUIVector擾.
     * 
     * @return IɓɏIGUIVector
     */
    public abstract Vector getDisposeOnExit();

    /**
     * ̃IuWFNgIɓɏIEBhEȂǂo^.
     * 
     * @param window
     *            ̃IuWFNgIƓɏIWindow
     */
    public abstract void addDisposeOnExit(Window window);

    /**
     * ̃IuWFNgIɓɏIEBhEȂǂo^.
     * 
     * @param window
     *            ̃IuWFNgIƓɏIWindow
     */
    public abstract void addDisposeOnExit(InternalFrameChase window);

    /**
     * Ot@C, ̃IuWFNg`Ă3DԂGNX|[g
     * 
     * @param fileName
     *            GNX|[g̃t@C
     */
    public abstract void export(String fileName) throws IOException;

    /**
     * Ot@C, ̃IuWFNg`Ă3DԂGNX|[g. t@C, ftHgp.
     */
    public abstract void export() throws IOException;

    /**
     * x[XƂȂĂfBNg[Ԃ.
     * 
     * @return x[XfBNg[
     */
    public abstract String getParentDirectory();

    /**
     * VRML97`ŃV[w̃t@C֏o͂
     * 
     * @param fileName
     *            o͐̃t@C
     */
    public abstract void doExportVRML(String fileName) throws IOException;

    /**
     * @return 3DԂCanvas3DIuWFNgԂ.
     */
    public abstract Canvas3D getCanvas();

    /**
     * @return Java3D\@ɊւݒێNXԂ.
     */
    public abstract J3DDataManager getJ3DDataManager();

    /**
     * udĕ`vsȂĂ΂ȂĂǂ\bh. ̔̂ ōĕ`sۂԂ.
     * 
     * @return ̃plōĕ`sȂtrue.
     */
    public abstract boolean doRedraw();

    /**
     * ĕ`, ptH[}XdōsꍇfalseƂ. falsȅꍇ, ႦΌf̕\FȂǂ͕ύXȂ.
     * 
     * @param ptH[}Xd̍ĕ`sꍇfalse
     *            (ftHgtrue)
     */
    public abstract void doRedraw(boolean doRedraw);

    public abstract void prepareRedraw();

    /**
     * e@ύX
     * 
     * @param projectionPolicy
     *            e@; View.PARALLEL_PROJECTIONView.PERSPECTIVE_PROJECTION
     */
    public abstract void setProjectionPolicy(int projectionPolicy);

    /**
     * ݂̓e@擾
     * 
     * @return ݂̓e@; View.PARALLEL_PROJECTIONView.PERSPECTIVE_PROJECTION
     */
    public abstract int getProjectionPolicy();

    public abstract void postRedraw();

    /**
     * `ɊւvpeB[擾.
     * 
     * @return `ɊւvpeB[.
     */
    public abstract GlobalProperties getJ3DProperties();

    /**
     * {[f[^̔z擾邱Ƃł郁\bh; ftHgłnullԂ. Kvɉoverride.
     * 
     * @return ֘Atꂽ{[f[^̔z; ftHgłnull.
     */
    public abstract VolumetricData[] getAssociatedVolumetricData();

    /**
     * ԏTransformGroupԂ. , "ԏTransformGroup"̓TuNXɂ
     * ɍ쐬@Ⴄ̂Ńx[XNXłnullԂ
     * 
     * @return ԏTransformGroup
     */
    public abstract TransformGroup getRootTransform();

    /**
     * "]"TransformGroup̔zԂ; ftHgłrootTransform.
     * 
     * @return ]TransformGroup
     */
    public abstract TransformGroup[] getRotatingTransform();

    /**
     * t[ꍇtrue; łȂfalse.
     * 
     * @param t[̂vOȂtrue
     *            .
     */
    public abstract boolean supportsFrame();

}
