/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : HostConnector.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.hosts;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.ssh.SshClient;

public class HostConnector extends JPanel implements ActionListener {
    private static Logger logger = Logger.getLogger(HostConnector.class
            .getName());

    private SshClient client;

    private HostSelectorList list;

    public HostConnector(SshClient client) {
        this.client = client;
        init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        JScrollPane scrollpane = new JScrollPane();
        list = new HostSelectorList();
        list.getJList().setSelectedIndex(0);
        scrollpane.getViewport().setView(list);
        scrollpane.setBorder(new TitledBorder("list of hosts"));
        this.add(scrollpane);
        JButton connect = new JButton("connect");
        connect.addActionListener(this);
        this.add(connect);
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JButton) {
            HostInfo host = list.getSelectedHost();
            if (host == null) {
                logger.error("select host!");
            } else {
                client.connect(host);
            }
        }
    }

}
