/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/16, 13:12
!  AUTHOR(S): KOGA, Junichiro
!  File : EkCalScriptReplaceRules.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.ekcal;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.scripting.scriptreplace.ScriptReplaceRules;

/**
 * EKCALpXNvguK߂NX
 * 
 * @author
 */
public class EkCalScriptReplaceRules extends ScriptReplaceRules {
    private Logger logger = Logger.getLogger(EkCalScriptReplaceRules.class
            .getName());
    private final String __EKCALL__ = "__EKCAL__";
    private String[] keys = { __EKCALL__ };

    /** Creates a new instance of EkCalScriptReplaceRules */
    public EkCalScriptReplaceRules() {
    }

    public String[] getKeys() {
        return keys;
    }

    public String replace(String file, Document document, boolean overwrite) {
        if (document == null || !document.hasRootElement()) {
            logger.error("invalid document");
            return null;
        }

        Element jobcontrol = document.getRootElement().getChild(
                JobController.JOBCONTROL);
        if (jobcontrol == null) {
            logger.error("invalid jobcontrol element");
            return null;
        }

        Element targethost = jobcontrol.getChild("targethost");
        if (targethost == null) {
            logger.error("invalid 'targethost' element");
            return null;
        }

        Element env = targethost.getChild("env");
        if (env == null) {
            logger.error("invalid 'env' element");
            return null;
        }

        String[] keys = getKeys();
        for (int i = 0; i < keys.length; i++) {
            String key = keys[i];
            if (key.equals(__EKCALL__)) {
                String bindir = MyElement
                        .decode(env.getChildTextTrim("bindir"));
                String ekcal = bindir + "/ekcal";
                if (bindir == null || bindir.trim().length() == 0) {
                    ekcal = "ekcal";
                }
                if (targethost.getTextTrim().equals("localhost")
                        && System.getProperty("os.name").toLowerCase()
                                .startsWith("windows")) {
                    ekcal = Utils.escapeBackSlash(bindir) + "\\\\"
                            + "ekcal.exe";
                    if (bindir == null || bindir.trim().length() == 0) {
                        ekcal = "ekcal.exe";
                    }
                }
                file = file.replaceAll(key, ekcal);
            }
        }

        if (!(targethost.getTextTrim().equals("localhost") && System
                .getProperty("os.name").toLowerCase().startsWith("windows"))) {
            file = file.replaceAll("\\r", "");
        }

        return file;
    }

    public String replace(String script, Document document) {
        return replace(script, document, false);
    }

}
