/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/21, 18:10
!  AUTHOR(S): KOGA, Junichiro
!  File : KPointPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.fbz.edit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.KpointGenerator;
import ciss.phase_viewer.acviewer.fbz.KpointsListener;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * I𒆂k_\t@C֏o͂肷鑀s߂GUI
 * 
 * @author
 */
public class KPointPanel extends InternalFrameChase {
    private Logger logger = Logger.getLogger(KPointPanel.class.getName());
    private FBZ fbz;

    /** Creates a new instance of KPointPanel */
    public KPointPanel(J3DPanel parent) {
        super("kpoints", new Dimension(400, 300));
        parent.addDisposeOnExit(this);
        fbz = (FBZ) parent;
        wscell = fbz.getFBZ();
        init();
        // addWindowListener(new WindowAdapter() {
        // public void windowClosed(WindowEvent e) {
        // close();
        // }
        // });
        addInternalFrameListener(new InternalFrameAdapter() {
            public void internalFrameClosed() {
                close();
            }
        });
        setVisible(true);
    }

    private void close() {
        wscell.removeKPointListener((KpointsListener) tabbedPane
                .getComponent(0));
    }

    private WignerSeitzCell wscell;
    private JTabbedPane tabbedPane;

    private void init() {
        SymmKpointPanel sympanel = new SymmKpointPanel(fbz);
        KpointMeshPanel meshpanel = new KpointMeshPanel(fbz);
        tabbedPane = new JTabbedPane();
        tabbedPane.addTab("symm. kpoints", sympanel);
        tabbedPane.addTab("mesh", meshpanel);

        JButton btnsave = new JButton("to file");
        JButton btnbandkpt = new JButton("generate kpoints");
        JButton btninit = new JButton("clear");
        JButton btndismiss = new JButton("dismiss");
        JPanel pbtn = new JPanel();
        pbtn.add(btnsave);
        pbtn.add(btnbandkpt);
        pbtn.add(btninit);
        pbtn.add(btndismiss);

        Container container = getContentPane();
        container.setLayout(new BorderLayout());
        container.add(tabbedPane, BorderLayout.CENTER);
        container.add(pbtn, BorderLayout.SOUTH);

        btnsave.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ((KpointGenerator) tabbedPane.getSelectedComponent())
                        .saveInput(null, 0.2);
            }
        });

        btnbandkpt.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    ((KpointGenerator) tabbedPane.getSelectedComponent())
                            .saveInput(null, 0.2);
                    ((KpointGenerator) tabbedPane.getSelectedComponent())
                            .generateKpoints(null, 0.2);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });

        btninit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                wscell.removeAllSymmetryLines();
            }
        });

        btndismiss.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                dispose();
            }
        });
    }

}
